/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnRowFilter;
import software.amazon.awssdk.services.glue.model.ColumnRowFilterListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.NameStringListCopier;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUnfilteredTableMetadataResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetUnfilteredTableMetadataResponse> {
    private static final SdkField<Table> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Table").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::table)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::table)).constructor(Table::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<List<String>> AUTHORIZED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedColumns").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::authorizedColumns)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::authorizedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_REGISTERED_WITH_LAKE_FORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsRegisteredWithLakeFormation").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::isRegisteredWithLakeFormation)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::isRegisteredWithLakeFormation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRegisteredWithLakeFormation").build()}).build();
    private static final SdkField<List<ColumnRowFilter>> CELL_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CellFilters").getter(GetUnfilteredTableMetadataResponse.getter(GetUnfilteredTableMetadataResponse::cellFilters)).setter(GetUnfilteredTableMetadataResponse.setter(Builder::cellFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnRowFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_FIELD, AUTHORIZED_COLUMNS_FIELD, IS_REGISTERED_WITH_LAKE_FORMATION_FIELD, CELL_FILTERS_FIELD));
    private final Table table;
    private final List<String> authorizedColumns;
    private final Boolean isRegisteredWithLakeFormation;
    private final List<ColumnRowFilter> cellFilters;

    private GetUnfilteredTableMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.table = builder.table;
        this.authorizedColumns = builder.authorizedColumns;
        this.isRegisteredWithLakeFormation = builder.isRegisteredWithLakeFormation;
        this.cellFilters = builder.cellFilters;
    }

    public final Table table() {
        return this.table;
    }

    public final boolean hasAuthorizedColumns() {
        return this.authorizedColumns != null && !(this.authorizedColumns instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedColumns() {
        return this.authorizedColumns;
    }

    public final Boolean isRegisteredWithLakeFormation() {
        return this.isRegisteredWithLakeFormation;
    }

    public final boolean hasCellFilters() {
        return this.cellFilters != null && !(this.cellFilters instanceof SdkAutoConstructList);
    }

    public final List<ColumnRowFilter> cellFilters() {
        return this.cellFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedColumns() ? this.authorizedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isRegisteredWithLakeFormation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCellFilters() ? this.cellFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredTableMetadataResponse)) {
            return false;
        }
        GetUnfilteredTableMetadataResponse other = (GetUnfilteredTableMetadataResponse)((Object)obj);
        return Objects.equals(this.table(), other.table()) && this.hasAuthorizedColumns() == other.hasAuthorizedColumns() && Objects.equals(this.authorizedColumns(), other.authorizedColumns()) && Objects.equals(this.isRegisteredWithLakeFormation(), other.isRegisteredWithLakeFormation()) && this.hasCellFilters() == other.hasCellFilters() && Objects.equals(this.cellFilters(), other.cellFilters());
    }

    public final String toString() {
        return ToString.builder((String)"GetUnfilteredTableMetadataResponse").add("Table", (Object)this.table()).add("AuthorizedColumns", this.hasAuthorizedColumns() ? this.authorizedColumns() : null).add("IsRegisteredWithLakeFormation", (Object)this.isRegisteredWithLakeFormation()).add("CellFilters", this.hasCellFilters() ? this.cellFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "AuthorizedColumns": {
                return Optional.ofNullable(clazz.cast(this.authorizedColumns()));
            }
            case "IsRegisteredWithLakeFormation": {
                return Optional.ofNullable(clazz.cast(this.isRegisteredWithLakeFormation()));
            }
            case "CellFilters": {
                return Optional.ofNullable(clazz.cast(this.cellFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredTableMetadataResponse, T> g) {
        return obj -> g.apply((GetUnfilteredTableMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private Table table;
        private List<String> authorizedColumns = DefaultSdkAutoConstructList.getInstance();
        private Boolean isRegisteredWithLakeFormation;
        private List<ColumnRowFilter> cellFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredTableMetadataResponse model) {
            super(model);
            this.table(model.table);
            this.authorizedColumns(model.authorizedColumns);
            this.isRegisteredWithLakeFormation(model.isRegisteredWithLakeFormation);
            this.cellFilters(model.cellFilters);
        }

        public final Table.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        public final void setTable(Table.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(Table table) {
            this.table = table;
            return this;
        }

        public final Collection<String> getAuthorizedColumns() {
            if (this.authorizedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedColumns;
        }

        public final void setAuthorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
        }

        @Override
        public final Builder authorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedColumns(String ... authorizedColumns) {
            this.authorizedColumns(Arrays.asList(authorizedColumns));
            return this;
        }

        public final Boolean getIsRegisteredWithLakeFormation() {
            return this.isRegisteredWithLakeFormation;
        }

        public final void setIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
        }

        @Override
        public final Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
            return this;
        }

        public final List<ColumnRowFilter.Builder> getCellFilters() {
            List<ColumnRowFilter.Builder> result = ColumnRowFilterListCopier.copyToBuilder(this.cellFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCellFilters(Collection<ColumnRowFilter.BuilderImpl> cellFilters) {
            this.cellFilters = ColumnRowFilterListCopier.copyFromBuilder(cellFilters);
        }

        @Override
        public final Builder cellFilters(Collection<ColumnRowFilter> cellFilters) {
            this.cellFilters = ColumnRowFilterListCopier.copy(cellFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellFilters(ColumnRowFilter ... cellFilters) {
            this.cellFilters(Arrays.asList(cellFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellFilters(Consumer<ColumnRowFilter.Builder> ... cellFilters) {
            this.cellFilters(Stream.of(cellFilters).map(c -> (ColumnRowFilter)((ColumnRowFilter.Builder)ColumnRowFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetUnfilteredTableMetadataResponse build() {
            return new GetUnfilteredTableMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUnfilteredTableMetadataResponse> {
        public Builder table(Table var1);

        default public Builder table(Consumer<Table.Builder> table) {
            return this.table((Table)((Table.Builder)Table.builder().applyMutation(table)).build());
        }

        public Builder authorizedColumns(Collection<String> var1);

        public Builder authorizedColumns(String ... var1);

        public Builder isRegisteredWithLakeFormation(Boolean var1);

        public Builder cellFilters(Collection<ColumnRowFilter> var1);

        public Builder cellFilters(ColumnRowFilter ... var1);

        public Builder cellFilters(Consumer<ColumnRowFilter.Builder> ... var1);
    }
}

