/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableVersionsResponse extends GlueResponse implements
        ToCopyableBuilder<GetTableVersionsResponse.Builder, GetTableVersionsResponse> {
    private static final SdkField<List<TableVersion>> TABLE_VERSIONS_FIELD = SdkField
            .<List<TableVersion>> builder(MarshallingType.LIST)
            .memberName("TableVersions")
            .getter(getter(GetTableVersionsResponse::tableVersions))
            .setter(setter(Builder::tableVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetTableVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TableVersion> tableVersions;

    private final String nextToken;

    private GetTableVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.tableVersions = builder.tableVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TableVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTableVersions() {
        return tableVersions != null && !(tableVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings identifying available versions of the specified table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTableVersions} method.
     * </p>
     * 
     * @return A list of strings identifying available versions of the specified table.
     */
    public final List<TableVersion> tableVersions() {
        return tableVersions;
    }

    /**
     * <p>
     * A continuation token, if the list of available versions does not include the last one.
     * </p>
     * 
     * @return A continuation token, if the list of available versions does not include the last one.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTableVersions() ? tableVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableVersionsResponse)) {
            return false;
        }
        GetTableVersionsResponse other = (GetTableVersionsResponse) obj;
        return hasTableVersions() == other.hasTableVersions() && Objects.equals(tableVersions(), other.tableVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableVersionsResponse").add("TableVersions", hasTableVersions() ? tableVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableVersions":
            return Optional.ofNullable(clazz.cast(tableVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTableVersionsResponse, T> g) {
        return obj -> g.apply((GetTableVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTableVersionsResponse> {
        /**
         * <p>
         * A list of strings identifying available versions of the specified table.
         * </p>
         * 
         * @param tableVersions
         *        A list of strings identifying available versions of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableVersions(Collection<TableVersion> tableVersions);

        /**
         * <p>
         * A list of strings identifying available versions of the specified table.
         * </p>
         * 
         * @param tableVersions
         *        A list of strings identifying available versions of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableVersions(TableVersion... tableVersions);

        /**
         * <p>
         * A list of strings identifying available versions of the specified table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.TableVersion.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.TableVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.TableVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #tableVersions(List<TableVersion>)}.
         * 
         * @param tableVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.TableVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableVersions(java.util.Collection<TableVersion>)
         */
        Builder tableVersions(Consumer<TableVersion.Builder>... tableVersions);

        /**
         * <p>
         * A continuation token, if the list of available versions does not include the last one.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if the list of available versions does not include the last one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<TableVersion> tableVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableVersionsResponse model) {
            super(model);
            tableVersions(model.tableVersions);
            nextToken(model.nextToken);
        }

        public final List<TableVersion.Builder> getTableVersions() {
            List<TableVersion.Builder> result = GetTableVersionsListCopier.copyToBuilder(this.tableVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableVersions(Collection<TableVersion.BuilderImpl> tableVersions) {
            this.tableVersions = GetTableVersionsListCopier.copyFromBuilder(tableVersions);
        }

        @Override
        public final Builder tableVersions(Collection<TableVersion> tableVersions) {
            this.tableVersions = GetTableVersionsListCopier.copy(tableVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableVersions(TableVersion... tableVersions) {
            tableVersions(Arrays.asList(tableVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableVersions(Consumer<TableVersion.Builder>... tableVersions) {
            tableVersions(Stream.of(tableVersions).map(c -> TableVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTableVersionsResponse build() {
            return new GetTableVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
