/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetJobRunsRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunsResponse;

public class GetJobRunsPublisher
implements SdkPublisher<GetJobRunsResponse> {
    private final GlueAsyncClient client;
    private final GetJobRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetJobRunsPublisher(GlueAsyncClient client, GetJobRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetJobRunsPublisher(GlueAsyncClient client, GetJobRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetJobRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetJobRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetJobRunsResponseFetcher
    implements AsyncPageFetcher<GetJobRunsResponse> {
        private GetJobRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetJobRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetJobRunsResponse> nextPage(GetJobRunsResponse previousPage) {
            if (previousPage == null) {
                return GetJobRunsPublisher.this.client.getJobRuns(GetJobRunsPublisher.this.firstRequest);
            }
            return GetJobRunsPublisher.this.client.getJobRuns((GetJobRunsRequest)((Object)GetJobRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

