/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing a key value pair for metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataKeyValuePair implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataKeyValuePair.Builder, MetadataKeyValuePair> {
    private static final SdkField<String> METADATA_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataKey").getter(getter(MetadataKeyValuePair::metadataKey)).setter(setter(Builder::metadataKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataKey").build()).build();

    private static final SdkField<String> METADATA_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataValue").getter(getter(MetadataKeyValuePair::metadataValue))
            .setter(setter(Builder::metadataValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_KEY_FIELD,
            METADATA_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metadataKey;

    private final String metadataValue;

    private MetadataKeyValuePair(BuilderImpl builder) {
        this.metadataKey = builder.metadataKey;
        this.metadataValue = builder.metadataValue;
    }

    /**
     * <p>
     * A metadata key.
     * </p>
     * 
     * @return A metadata key.
     */
    public final String metadataKey() {
        return metadataKey;
    }

    /**
     * <p>
     * A metadata key’s corresponding value.
     * </p>
     * 
     * @return A metadata key’s corresponding value.
     */
    public final String metadataValue() {
        return metadataValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadataKey());
        hashCode = 31 * hashCode + Objects.hashCode(metadataValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataKeyValuePair)) {
            return false;
        }
        MetadataKeyValuePair other = (MetadataKeyValuePair) obj;
        return Objects.equals(metadataKey(), other.metadataKey()) && Objects.equals(metadataValue(), other.metadataValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataKeyValuePair").add("MetadataKey", metadataKey()).add("MetadataValue", metadataValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetadataKey":
            return Optional.ofNullable(clazz.cast(metadataKey()));
        case "MetadataValue":
            return Optional.ofNullable(clazz.cast(metadataValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetadataKeyValuePair, T> g) {
        return obj -> g.apply((MetadataKeyValuePair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataKeyValuePair> {
        /**
         * <p>
         * A metadata key.
         * </p>
         * 
         * @param metadataKey
         *        A metadata key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataKey(String metadataKey);

        /**
         * <p>
         * A metadata key’s corresponding value.
         * </p>
         * 
         * @param metadataValue
         *        A metadata key’s corresponding value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataValue(String metadataValue);
    }

    static final class BuilderImpl implements Builder {
        private String metadataKey;

        private String metadataValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataKeyValuePair model) {
            metadataKey(model.metadataKey);
            metadataValue(model.metadataValue);
        }

        public final String getMetadataKey() {
            return metadataKey;
        }

        public final void setMetadataKey(String metadataKey) {
            this.metadataKey = metadataKey;
        }

        @Override
        public final Builder metadataKey(String metadataKey) {
            this.metadataKey = metadataKey;
            return this;
        }

        public final String getMetadataValue() {
            return metadataValue;
        }

        public final void setMetadataValue(String metadataValue) {
            this.metadataValue = metadataValue;
        }

        @Override
        public final Builder metadataValue(String metadataValue) {
            this.metadataValue = metadataValue;
            return this;
        }

        @Override
        public MetadataKeyValuePair build() {
            return new MetadataKeyValuePair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
