/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.glue.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.glue.model.SchemaVersionListItem;

public class ListSchemaVersionsPublisher
implements SdkPublisher<ListSchemaVersionsResponse> {
    private final GlueAsyncClient client;
    private final ListSchemaVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSchemaVersionsPublisher(GlueAsyncClient client, ListSchemaVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSchemaVersionsPublisher(GlueAsyncClient client, ListSchemaVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSchemaVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSchemaVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SchemaVersionListItem> schemas() {
        Function<ListSchemaVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemas() != null) {
                return response.schemas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSchemaVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSchemaVersionsResponseFetcher
    implements AsyncPageFetcher<ListSchemaVersionsResponse> {
        private ListSchemaVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSchemaVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSchemaVersionsResponse> nextPage(ListSchemaVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListSchemaVersionsPublisher.this.client.listSchemaVersions(ListSchemaVersionsPublisher.this.firstRequest);
            }
            return ListSchemaVersionsPublisher.this.client.listSchemaVersions((ListSchemaVersionsRequest)((Object)ListSchemaVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

