/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataQualityRulesetRequest extends GlueRequest implements
        ToCopyableBuilder<CreateDataQualityRulesetRequest.Builder, CreateDataQualityRulesetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDataQualityRulesetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateDataQualityRulesetRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> RULESET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ruleset")
            .getter(getter(CreateDataQualityRulesetRequest::ruleset)).setter(setter(Builder::ruleset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ruleset").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDataQualityRulesetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DataQualityTargetTable> TARGET_TABLE_FIELD = SdkField
            .<DataQualityTargetTable> builder(MarshallingType.SDK_POJO).memberName("TargetTable")
            .getter(getter(CreateDataQualityRulesetRequest::targetTable)).setter(setter(Builder::targetTable))
            .constructor(DataQualityTargetTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTable").build()).build();

    private static final SdkField<String> DATA_QUALITY_SECURITY_CONFIGURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataQualitySecurityConfiguration")
            .getter(getter(CreateDataQualityRulesetRequest::dataQualitySecurityConfiguration))
            .setter(setter(Builder::dataQualitySecurityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySecurityConfiguration")
                    .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateDataQualityRulesetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            RULESET_FIELD, TAGS_FIELD, TARGET_TABLE_FIELD, DATA_QUALITY_SECURITY_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));

    private final String name;

    private final String description;

    private final String ruleset;

    private final Map<String, String> tags;

    private final DataQualityTargetTable targetTable;

    private final String dataQualitySecurityConfiguration;

    private final String clientToken;

    private CreateDataQualityRulesetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.ruleset = builder.ruleset;
        this.tags = builder.tags;
        this.targetTable = builder.targetTable;
        this.dataQualitySecurityConfiguration = builder.dataQualitySecurityConfiguration;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A unique name for the data quality ruleset.
     * </p>
     * 
     * @return A unique name for the data quality ruleset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the data quality ruleset.
     * </p>
     * 
     * @return A description of the data quality ruleset.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A Data Quality Definition Language (DQDL) ruleset. For more information, see the Glue developer guide.
     * </p>
     * 
     * @return A Data Quality Definition Language (DQDL) ruleset. For more information, see the Glue developer guide.
     */
    public final String ruleset() {
        return ruleset;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags applied to the data quality ruleset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags applied to the data quality ruleset.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A target table associated with the data quality ruleset.
     * </p>
     * 
     * @return A target table associated with the data quality ruleset.
     */
    public final DataQualityTargetTable targetTable() {
        return targetTable;
    }

    /**
     * <p>
     * The name of the security configuration created with the data quality encryption option.
     * </p>
     * 
     * @return The name of the security configuration created with the data quality encryption option.
     */
    public final String dataQualitySecurityConfiguration() {
        return dataQualitySecurityConfiguration;
    }

    /**
     * <p>
     * Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or starting
     * multiple instances of the same resource.
     * </p>
     * 
     * @return Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or
     *         starting multiple instances of the same resource.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ruleset());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetTable());
        hashCode = 31 * hashCode + Objects.hashCode(dataQualitySecurityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataQualityRulesetRequest)) {
            return false;
        }
        CreateDataQualityRulesetRequest other = (CreateDataQualityRulesetRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(ruleset(), other.ruleset()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(targetTable(), other.targetTable())
                && Objects.equals(dataQualitySecurityConfiguration(), other.dataQualitySecurityConfiguration())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataQualityRulesetRequest").add("Name", name()).add("Description", description())
                .add("Ruleset", ruleset()).add("Tags", hasTags() ? tags() : null).add("TargetTable", targetTable())
                .add("DataQualitySecurityConfiguration", dataQualitySecurityConfiguration()).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Ruleset":
            return Optional.ofNullable(clazz.cast(ruleset()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TargetTable":
            return Optional.ofNullable(clazz.cast(targetTable()));
        case "DataQualitySecurityConfiguration":
            return Optional.ofNullable(clazz.cast(dataQualitySecurityConfiguration()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataQualityRulesetRequest, T> g) {
        return obj -> g.apply((CreateDataQualityRulesetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataQualityRulesetRequest> {
        /**
         * <p>
         * A unique name for the data quality ruleset.
         * </p>
         * 
         * @param name
         *        A unique name for the data quality ruleset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the data quality ruleset.
         * </p>
         * 
         * @param description
         *        A description of the data quality ruleset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A Data Quality Definition Language (DQDL) ruleset. For more information, see the Glue developer guide.
         * </p>
         * 
         * @param ruleset
         *        A Data Quality Definition Language (DQDL) ruleset. For more information, see the Glue developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleset(String ruleset);

        /**
         * <p>
         * A list of tags applied to the data quality ruleset.
         * </p>
         * 
         * @param tags
         *        A list of tags applied to the data quality ruleset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A target table associated with the data quality ruleset.
         * </p>
         * 
         * @param targetTable
         *        A target table associated with the data quality ruleset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTable(DataQualityTargetTable targetTable);

        /**
         * <p>
         * A target table associated with the data quality ruleset.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQualityTargetTable.Builder} avoiding
         * the need to create one manually via {@link DataQualityTargetTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQualityTargetTable.Builder#build()} is called immediately and
         * its result is passed to {@link #targetTable(DataQualityTargetTable)}.
         * 
         * @param targetTable
         *        a consumer that will call methods on {@link DataQualityTargetTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTable(DataQualityTargetTable)
         */
        default Builder targetTable(Consumer<DataQualityTargetTable.Builder> targetTable) {
            return targetTable(DataQualityTargetTable.builder().applyMutation(targetTable).build());
        }

        /**
         * <p>
         * The name of the security configuration created with the data quality encryption option.
         * </p>
         * 
         * @param dataQualitySecurityConfiguration
         *        The name of the security configuration created with the data quality encryption option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration);

        /**
         * <p>
         * Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or
         * starting multiple instances of the same resource.
         * </p>
         * 
         * @param clientToken
         *        Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or
         *        starting multiple instances of the same resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String ruleset;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private DataQualityTargetTable targetTable;

        private String dataQualitySecurityConfiguration;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataQualityRulesetRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            ruleset(model.ruleset);
            tags(model.tags);
            targetTable(model.targetTable);
            dataQualitySecurityConfiguration(model.dataQualitySecurityConfiguration);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRuleset() {
            return ruleset;
        }

        public final void setRuleset(String ruleset) {
            this.ruleset = ruleset;
        }

        @Override
        public final Builder ruleset(String ruleset) {
            this.ruleset = ruleset;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final DataQualityTargetTable.Builder getTargetTable() {
            return targetTable != null ? targetTable.toBuilder() : null;
        }

        public final void setTargetTable(DataQualityTargetTable.BuilderImpl targetTable) {
            this.targetTable = targetTable != null ? targetTable.build() : null;
        }

        @Override
        public final Builder targetTable(DataQualityTargetTable targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public final String getDataQualitySecurityConfiguration() {
            return dataQualitySecurityConfiguration;
        }

        public final void setDataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
        }

        @Override
        public final Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataQualityRulesetRequest build() {
            return new CreateDataQualityRulesetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
