/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the direct JDBC source connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectJDBCSource implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectJDBCSource.Builder, DirectJDBCSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DirectJDBCSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(DirectJDBCSource::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(DirectJDBCSource::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(DirectJDBCSource::connectionName))
            .setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(DirectJDBCSource::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<String> REDSHIFT_TMP_DIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedshiftTmpDir").getter(getter(DirectJDBCSource::redshiftTmpDir))
            .setter(setter(Builder::redshiftTmpDir))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftTmpDir").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATABASE_FIELD,
            TABLE_FIELD, CONNECTION_NAME_FIELD, CONNECTION_TYPE_FIELD, REDSHIFT_TMP_DIR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String database;

    private final String table;

    private final String connectionName;

    private final String connectionType;

    private final String redshiftTmpDir;

    private DirectJDBCSource(BuilderImpl builder) {
        this.name = builder.name;
        this.database = builder.database;
        this.table = builder.table;
        this.connectionName = builder.connectionName;
        this.connectionType = builder.connectionType;
        this.redshiftTmpDir = builder.redshiftTmpDir;
    }

    /**
     * <p>
     * The name of the JDBC source connection.
     * </p>
     * 
     * @return The name of the JDBC source connection.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The database of the JDBC source connection.
     * </p>
     * 
     * @return The database of the JDBC source connection.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The table of the JDBC source connection.
     * </p>
     * 
     * @return The table of the JDBC source connection.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * The connection name of the JDBC source.
     * </p>
     * 
     * @return The connection name of the JDBC source.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * The connection type of the JDBC source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link JDBCConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The connection type of the JDBC source.
     * @see JDBCConnectionType
     */
    public final JDBCConnectionType connectionType() {
        return JDBCConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The connection type of the JDBC source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link JDBCConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The connection type of the JDBC source.
     * @see JDBCConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * <p>
     * The temp directory of the JDBC Redshift source.
     * </p>
     * 
     * @return The temp directory of the JDBC Redshift source.
     */
    public final String redshiftTmpDir() {
        return redshiftTmpDir;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftTmpDir());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectJDBCSource)) {
            return false;
        }
        DirectJDBCSource other = (DirectJDBCSource) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(database(), other.database())
                && Objects.equals(table(), other.table()) && Objects.equals(connectionName(), other.connectionName())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && Objects.equals(redshiftTmpDir(), other.redshiftTmpDir());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DirectJDBCSource").add("Name", name()).add("Database", database()).add("Table", table())
                .add("ConnectionName", connectionName()).add("ConnectionType", connectionTypeAsString())
                .add("RedshiftTmpDir", redshiftTmpDir()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "RedshiftTmpDir":
            return Optional.ofNullable(clazz.cast(redshiftTmpDir()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectJDBCSource, T> g) {
        return obj -> g.apply((DirectJDBCSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectJDBCSource> {
        /**
         * <p>
         * The name of the JDBC source connection.
         * </p>
         * 
         * @param name
         *        The name of the JDBC source connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The database of the JDBC source connection.
         * </p>
         * 
         * @param database
         *        The database of the JDBC source connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The table of the JDBC source connection.
         * </p>
         * 
         * @param table
         *        The table of the JDBC source connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * The connection name of the JDBC source.
         * </p>
         * 
         * @param connectionName
         *        The connection name of the JDBC source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The connection type of the JDBC source.
         * </p>
         * 
         * @param connectionType
         *        The connection type of the JDBC source.
         * @see JDBCConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JDBCConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The connection type of the JDBC source.
         * </p>
         * 
         * @param connectionType
         *        The connection type of the JDBC source.
         * @see JDBCConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JDBCConnectionType
         */
        Builder connectionType(JDBCConnectionType connectionType);

        /**
         * <p>
         * The temp directory of the JDBC Redshift source.
         * </p>
         * 
         * @param redshiftTmpDir
         *        The temp directory of the JDBC Redshift source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftTmpDir(String redshiftTmpDir);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String database;

        private String table;

        private String connectionName;

        private String connectionType;

        private String redshiftTmpDir;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectJDBCSource model) {
            name(model.name);
            database(model.database);
            table(model.table);
            connectionName(model.connectionName);
            connectionType(model.connectionType);
            redshiftTmpDir(model.redshiftTmpDir);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(JDBCConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getRedshiftTmpDir() {
            return redshiftTmpDir;
        }

        public final void setRedshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
        }

        @Override
        public final Builder redshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
            return this;
        }

        @Override
        public DirectJDBCSource build() {
            return new DirectJDBCSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
