/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectionResponse extends GlueResponse implements
        ToCopyableBuilder<CreateConnectionResponse.Builder, CreateConnectionResponse> {
    private static final SdkField<String> CREATE_CONNECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateConnectionStatus").getter(getter(CreateConnectionResponse::createConnectionStatusAsString))
            .setter(setter(Builder::createConnectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateConnectionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CREATE_CONNECTION_STATUS_FIELD));

    private final String createConnectionStatus;

    private CreateConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.createConnectionStatus = builder.createConnectionStatus;
    }

    /**
     * <p>
     * The status of the connection creation request. The request can take some time for certain authentication types,
     * for example when creating an OAuth connection with token exchange over VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createConnectionStatus} will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #createConnectionStatusAsString}.
     * </p>
     * 
     * @return The status of the connection creation request. The request can take some time for certain authentication
     *         types, for example when creating an OAuth connection with token exchange over VPC.
     * @see ConnectionStatus
     */
    public final ConnectionStatus createConnectionStatus() {
        return ConnectionStatus.fromValue(createConnectionStatus);
    }

    /**
     * <p>
     * The status of the connection creation request. The request can take some time for certain authentication types,
     * for example when creating an OAuth connection with token exchange over VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createConnectionStatus} will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #createConnectionStatusAsString}.
     * </p>
     * 
     * @return The status of the connection creation request. The request can take some time for certain authentication
     *         types, for example when creating an OAuth connection with token exchange over VPC.
     * @see ConnectionStatus
     */
    public final String createConnectionStatusAsString() {
        return createConnectionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createConnectionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionResponse)) {
            return false;
        }
        CreateConnectionResponse other = (CreateConnectionResponse) obj;
        return Objects.equals(createConnectionStatusAsString(), other.createConnectionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectionResponse").add("CreateConnectionStatus", createConnectionStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateConnectionStatus":
            return Optional.ofNullable(clazz.cast(createConnectionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionResponse, T> g) {
        return obj -> g.apply((CreateConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectionResponse> {
        /**
         * <p>
         * The status of the connection creation request. The request can take some time for certain authentication
         * types, for example when creating an OAuth connection with token exchange over VPC.
         * </p>
         * 
         * @param createConnectionStatus
         *        The status of the connection creation request. The request can take some time for certain
         *        authentication types, for example when creating an OAuth connection with token exchange over VPC.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder createConnectionStatus(String createConnectionStatus);

        /**
         * <p>
         * The status of the connection creation request. The request can take some time for certain authentication
         * types, for example when creating an OAuth connection with token exchange over VPC.
         * </p>
         * 
         * @param createConnectionStatus
         *        The status of the connection creation request. The request can take some time for certain
         *        authentication types, for example when creating an OAuth connection with token exchange over VPC.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder createConnectionStatus(ConnectionStatus createConnectionStatus);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String createConnectionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionResponse model) {
            super(model);
            createConnectionStatus(model.createConnectionStatus);
        }

        public final String getCreateConnectionStatus() {
            return createConnectionStatus;
        }

        public final void setCreateConnectionStatus(String createConnectionStatus) {
            this.createConnectionStatus = createConnectionStatus;
        }

        @Override
        public final Builder createConnectionStatus(String createConnectionStatus) {
            this.createConnectionStatus = createConnectionStatus;
            return this;
        }

        @Override
        public final Builder createConnectionStatus(ConnectionStatus createConnectionStatus) {
            this.createConnectionStatus(createConnectionStatus == null ? null : createConnectionStatus.toString());
            return this;
        }

        @Override
        public CreateConnectionResponse build() {
            return new CreateConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
