/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataQualityResultResponse extends GlueResponse implements
        ToCopyableBuilder<GetDataQualityResultResponse.Builder, GetDataQualityResultResponse> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultId").getter(getter(GetDataQualityResultResponse::resultId)).setter(setter(Builder::resultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(GetDataQualityResultResponse::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<Double> SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Score")
            .getter(getter(GetDataQualityResultResponse::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(GetDataQualityResultResponse::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> RULESET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RulesetName").getter(getter(GetDataQualityResultResponse::rulesetName))
            .setter(setter(Builder::rulesetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesetName").build()).build();

    private static final SdkField<String> EVALUATION_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationContext").getter(getter(GetDataQualityResultResponse::evaluationContext))
            .setter(setter(Builder::evaluationContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContext").build()).build();

    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedOn").getter(getter(GetDataQualityResultResponse::startedOn)).setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()).build();

    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedOn").getter(getter(GetDataQualityResultResponse::completedOn))
            .setter(setter(Builder::completedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(GetDataQualityResultResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobRunId").getter(getter(GetDataQualityResultResponse::jobRunId)).setter(setter(Builder::jobRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunId").build()).build();

    private static final SdkField<String> RULESET_EVALUATION_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RulesetEvaluationRunId").getter(getter(GetDataQualityResultResponse::rulesetEvaluationRunId))
            .setter(setter(Builder::rulesetEvaluationRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesetEvaluationRunId").build())
            .build();

    private static final SdkField<List<DataQualityRuleResult>> RULE_RESULTS_FIELD = SdkField
            .<List<DataQualityRuleResult>> builder(MarshallingType.LIST)
            .memberName("RuleResults")
            .getter(getter(GetDataQualityResultResponse::ruleResults))
            .setter(setter(Builder::ruleResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataQualityRuleResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataQualityRuleResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataQualityAnalyzerResult>> ANALYZER_RESULTS_FIELD = SdkField
            .<List<DataQualityAnalyzerResult>> builder(MarshallingType.LIST)
            .memberName("AnalyzerResults")
            .getter(getter(GetDataQualityResultResponse::analyzerResults))
            .setter(setter(Builder::analyzerResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzerResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataQualityAnalyzerResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataQualityAnalyzerResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataQualityObservation>> OBSERVATIONS_FIELD = SdkField
            .<List<DataQualityObservation>> builder(MarshallingType.LIST)
            .memberName("Observations")
            .getter(getter(GetDataQualityResultResponse::observations))
            .setter(setter(Builder::observations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Observations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataQualityObservation> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataQualityObservation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD,
            PROFILE_ID_FIELD, SCORE_FIELD, DATA_SOURCE_FIELD, RULESET_NAME_FIELD, EVALUATION_CONTEXT_FIELD, STARTED_ON_FIELD,
            COMPLETED_ON_FIELD, JOB_NAME_FIELD, JOB_RUN_ID_FIELD, RULESET_EVALUATION_RUN_ID_FIELD, RULE_RESULTS_FIELD,
            ANALYZER_RESULTS_FIELD, OBSERVATIONS_FIELD));

    private final String resultId;

    private final String profileId;

    private final Double score;

    private final DataSource dataSource;

    private final String rulesetName;

    private final String evaluationContext;

    private final Instant startedOn;

    private final Instant completedOn;

    private final String jobName;

    private final String jobRunId;

    private final String rulesetEvaluationRunId;

    private final List<DataQualityRuleResult> ruleResults;

    private final List<DataQualityAnalyzerResult> analyzerResults;

    private final List<DataQualityObservation> observations;

    private GetDataQualityResultResponse(BuilderImpl builder) {
        super(builder);
        this.resultId = builder.resultId;
        this.profileId = builder.profileId;
        this.score = builder.score;
        this.dataSource = builder.dataSource;
        this.rulesetName = builder.rulesetName;
        this.evaluationContext = builder.evaluationContext;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
        this.jobName = builder.jobName;
        this.jobRunId = builder.jobRunId;
        this.rulesetEvaluationRunId = builder.rulesetEvaluationRunId;
        this.ruleResults = builder.ruleResults;
        this.analyzerResults = builder.analyzerResults;
        this.observations = builder.observations;
    }

    /**
     * <p>
     * A unique result ID for the data quality result.
     * </p>
     * 
     * @return A unique result ID for the data quality result.
     */
    public final String resultId() {
        return resultId;
    }

    /**
     * <p>
     * The Profile ID for the data quality result.
     * </p>
     * 
     * @return The Profile ID for the data quality result.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * An aggregate data quality score. Represents the ratio of rules that passed to the total number of rules.
     * </p>
     * 
     * @return An aggregate data quality score. Represents the ratio of rules that passed to the total number of rules.
     */
    public final Double score() {
        return score;
    }

    /**
     * <p>
     * The table associated with the data quality result, if any.
     * </p>
     * 
     * @return The table associated with the data quality result, if any.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The name of the ruleset associated with the data quality result.
     * </p>
     * 
     * @return The name of the ruleset associated with the data quality result.
     */
    public final String rulesetName() {
        return rulesetName;
    }

    /**
     * <p>
     * In the context of a job in Glue Studio, each node in the canvas is typically assigned some sort of name and data
     * quality nodes will have names. In the case of multiple nodes, the <code>evaluationContext</code> can
     * differentiate the nodes.
     * </p>
     * 
     * @return In the context of a job in Glue Studio, each node in the canvas is typically assigned some sort of name
     *         and data quality nodes will have names. In the case of multiple nodes, the <code>evaluationContext</code>
     *         can differentiate the nodes.
     */
    public final String evaluationContext() {
        return evaluationContext;
    }

    /**
     * <p>
     * The date and time when the run for this data quality result started.
     * </p>
     * 
     * @return The date and time when the run for this data quality result started.
     */
    public final Instant startedOn() {
        return startedOn;
    }

    /**
     * <p>
     * The date and time when the run for this data quality result was completed.
     * </p>
     * 
     * @return The date and time when the run for this data quality result was completed.
     */
    public final Instant completedOn() {
        return completedOn;
    }

    /**
     * <p>
     * The job name associated with the data quality result, if any.
     * </p>
     * 
     * @return The job name associated with the data quality result, if any.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The job run ID associated with the data quality result, if any.
     * </p>
     * 
     * @return The job run ID associated with the data quality result, if any.
     */
    public final String jobRunId() {
        return jobRunId;
    }

    /**
     * <p>
     * The unique run ID associated with the ruleset evaluation.
     * </p>
     * 
     * @return The unique run ID associated with the ruleset evaluation.
     */
    public final String rulesetEvaluationRunId() {
        return rulesetEvaluationRunId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleResults() {
        return ruleResults != null && !(ruleResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataQualityRuleResult</code> objects representing the results for each rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleResults} method.
     * </p>
     * 
     * @return A list of <code>DataQualityRuleResult</code> objects representing the results for each rule.
     */
    public final List<DataQualityRuleResult> ruleResults() {
        return ruleResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalyzerResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalyzerResults() {
        return analyzerResults != null && !(analyzerResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataQualityAnalyzerResult</code> objects representing the results for each analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalyzerResults} method.
     * </p>
     * 
     * @return A list of <code>DataQualityAnalyzerResult</code> objects representing the results for each analyzer.
     */
    public final List<DataQualityAnalyzerResult> analyzerResults() {
        return analyzerResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Observations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasObservations() {
        return observations != null && !(observations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataQualityObservation</code> objects representing the observations generated after evaluating
     * the rules and analyzers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObservations} method.
     * </p>
     * 
     * @return A list of <code>DataQualityObservation</code> objects representing the observations generated after
     *         evaluating the rules and analyzers.
     */
    public final List<DataQualityObservation> observations() {
        return observations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resultId());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(rulesetName());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(rulesetEvaluationRunId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleResults() ? ruleResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalyzerResults() ? analyzerResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasObservations() ? observations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityResultResponse)) {
            return false;
        }
        GetDataQualityResultResponse other = (GetDataQualityResultResponse) obj;
        return Objects.equals(resultId(), other.resultId()) && Objects.equals(profileId(), other.profileId())
                && Objects.equals(score(), other.score()) && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(rulesetName(), other.rulesetName())
                && Objects.equals(evaluationContext(), other.evaluationContext())
                && Objects.equals(startedOn(), other.startedOn()) && Objects.equals(completedOn(), other.completedOn())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(jobRunId(), other.jobRunId())
                && Objects.equals(rulesetEvaluationRunId(), other.rulesetEvaluationRunId())
                && hasRuleResults() == other.hasRuleResults() && Objects.equals(ruleResults(), other.ruleResults())
                && hasAnalyzerResults() == other.hasAnalyzerResults()
                && Objects.equals(analyzerResults(), other.analyzerResults()) && hasObservations() == other.hasObservations()
                && Objects.equals(observations(), other.observations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataQualityResultResponse").add("ResultId", resultId()).add("ProfileId", profileId())
                .add("Score", score()).add("DataSource", dataSource()).add("RulesetName", rulesetName())
                .add("EvaluationContext", evaluationContext()).add("StartedOn", startedOn()).add("CompletedOn", completedOn())
                .add("JobName", jobName()).add("JobRunId", jobRunId()).add("RulesetEvaluationRunId", rulesetEvaluationRunId())
                .add("RuleResults", hasRuleResults() ? ruleResults() : null)
                .add("AnalyzerResults", hasAnalyzerResults() ? analyzerResults() : null)
                .add("Observations", hasObservations() ? observations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultId":
            return Optional.ofNullable(clazz.cast(resultId()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "RulesetName":
            return Optional.ofNullable(clazz.cast(rulesetName()));
        case "EvaluationContext":
            return Optional.ofNullable(clazz.cast(evaluationContext()));
        case "StartedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        case "CompletedOn":
            return Optional.ofNullable(clazz.cast(completedOn()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobRunId":
            return Optional.ofNullable(clazz.cast(jobRunId()));
        case "RulesetEvaluationRunId":
            return Optional.ofNullable(clazz.cast(rulesetEvaluationRunId()));
        case "RuleResults":
            return Optional.ofNullable(clazz.cast(ruleResults()));
        case "AnalyzerResults":
            return Optional.ofNullable(clazz.cast(analyzerResults()));
        case "Observations":
            return Optional.ofNullable(clazz.cast(observations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityResultResponse, T> g) {
        return obj -> g.apply((GetDataQualityResultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataQualityResultResponse> {
        /**
         * <p>
         * A unique result ID for the data quality result.
         * </p>
         * 
         * @param resultId
         *        A unique result ID for the data quality result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultId(String resultId);

        /**
         * <p>
         * The Profile ID for the data quality result.
         * </p>
         * 
         * @param profileId
         *        The Profile ID for the data quality result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * An aggregate data quality score. Represents the ratio of rules that passed to the total number of rules.
         * </p>
         * 
         * @param score
         *        An aggregate data quality score. Represents the ratio of rules that passed to the total number of
         *        rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Double score);

        /**
         * <p>
         * The table associated with the data quality result, if any.
         * </p>
         * 
         * @param dataSource
         *        The table associated with the data quality result, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The table associated with the data quality result, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The name of the ruleset associated with the data quality result.
         * </p>
         * 
         * @param rulesetName
         *        The name of the ruleset associated with the data quality result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesetName(String rulesetName);

        /**
         * <p>
         * In the context of a job in Glue Studio, each node in the canvas is typically assigned some sort of name and
         * data quality nodes will have names. In the case of multiple nodes, the <code>evaluationContext</code> can
         * differentiate the nodes.
         * </p>
         * 
         * @param evaluationContext
         *        In the context of a job in Glue Studio, each node in the canvas is typically assigned some sort of
         *        name and data quality nodes will have names. In the case of multiple nodes, the
         *        <code>evaluationContext</code> can differentiate the nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationContext(String evaluationContext);

        /**
         * <p>
         * The date and time when the run for this data quality result started.
         * </p>
         * 
         * @param startedOn
         *        The date and time when the run for this data quality result started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Instant startedOn);

        /**
         * <p>
         * The date and time when the run for this data quality result was completed.
         * </p>
         * 
         * @param completedOn
         *        The date and time when the run for this data quality result was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedOn(Instant completedOn);

        /**
         * <p>
         * The job name associated with the data quality result, if any.
         * </p>
         * 
         * @param jobName
         *        The job name associated with the data quality result, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job run ID associated with the data quality result, if any.
         * </p>
         * 
         * @param jobRunId
         *        The job run ID associated with the data quality result, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunId(String jobRunId);

        /**
         * <p>
         * The unique run ID associated with the ruleset evaluation.
         * </p>
         * 
         * @param rulesetEvaluationRunId
         *        The unique run ID associated with the ruleset evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesetEvaluationRunId(String rulesetEvaluationRunId);

        /**
         * <p>
         * A list of <code>DataQualityRuleResult</code> objects representing the results for each rule.
         * </p>
         * 
         * @param ruleResults
         *        A list of <code>DataQualityRuleResult</code> objects representing the results for each rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleResults(Collection<DataQualityRuleResult> ruleResults);

        /**
         * <p>
         * A list of <code>DataQualityRuleResult</code> objects representing the results for each rule.
         * </p>
         * 
         * @param ruleResults
         *        A list of <code>DataQualityRuleResult</code> objects representing the results for each rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleResults(DataQualityRuleResult... ruleResults);

        /**
         * <p>
         * A list of <code>DataQualityRuleResult</code> objects representing the results for each rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.DataQualityRuleResult.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.DataQualityRuleResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.DataQualityRuleResult.Builder#build()} is called
         * immediately and its result is passed to {@link #ruleResults(List<DataQualityRuleResult>)}.
         * 
         * @param ruleResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.DataQualityRuleResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleResults(java.util.Collection<DataQualityRuleResult>)
         */
        Builder ruleResults(Consumer<DataQualityRuleResult.Builder>... ruleResults);

        /**
         * <p>
         * A list of <code>DataQualityAnalyzerResult</code> objects representing the results for each analyzer.
         * </p>
         * 
         * @param analyzerResults
         *        A list of <code>DataQualityAnalyzerResult</code> objects representing the results for each analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerResults(Collection<DataQualityAnalyzerResult> analyzerResults);

        /**
         * <p>
         * A list of <code>DataQualityAnalyzerResult</code> objects representing the results for each analyzer.
         * </p>
         * 
         * @param analyzerResults
         *        A list of <code>DataQualityAnalyzerResult</code> objects representing the results for each analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerResults(DataQualityAnalyzerResult... analyzerResults);

        /**
         * <p>
         * A list of <code>DataQualityAnalyzerResult</code> objects representing the results for each analyzer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.DataQualityAnalyzerResult.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.glue.model.DataQualityAnalyzerResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.DataQualityAnalyzerResult.Builder#build()} is called
         * immediately and its result is passed to {@link #analyzerResults(List<DataQualityAnalyzerResult>)}.
         * 
         * @param analyzerResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.DataQualityAnalyzerResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyzerResults(java.util.Collection<DataQualityAnalyzerResult>)
         */
        Builder analyzerResults(Consumer<DataQualityAnalyzerResult.Builder>... analyzerResults);

        /**
         * <p>
         * A list of <code>DataQualityObservation</code> objects representing the observations generated after
         * evaluating the rules and analyzers.
         * </p>
         * 
         * @param observations
         *        A list of <code>DataQualityObservation</code> objects representing the observations generated after
         *        evaluating the rules and analyzers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observations(Collection<DataQualityObservation> observations);

        /**
         * <p>
         * A list of <code>DataQualityObservation</code> objects representing the observations generated after
         * evaluating the rules and analyzers.
         * </p>
         * 
         * @param observations
         *        A list of <code>DataQualityObservation</code> objects representing the observations generated after
         *        evaluating the rules and analyzers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observations(DataQualityObservation... observations);

        /**
         * <p>
         * A list of <code>DataQualityObservation</code> objects representing the observations generated after
         * evaluating the rules and analyzers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.DataQualityObservation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.DataQualityObservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.DataQualityObservation.Builder#build()} is called
         * immediately and its result is passed to {@link #observations(List<DataQualityObservation>)}.
         * 
         * @param observations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.DataQualityObservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #observations(java.util.Collection<DataQualityObservation>)
         */
        Builder observations(Consumer<DataQualityObservation.Builder>... observations);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String resultId;

        private String profileId;

        private Double score;

        private DataSource dataSource;

        private String rulesetName;

        private String evaluationContext;

        private Instant startedOn;

        private Instant completedOn;

        private String jobName;

        private String jobRunId;

        private String rulesetEvaluationRunId;

        private List<DataQualityRuleResult> ruleResults = DefaultSdkAutoConstructList.getInstance();

        private List<DataQualityAnalyzerResult> analyzerResults = DefaultSdkAutoConstructList.getInstance();

        private List<DataQualityObservation> observations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityResultResponse model) {
            super(model);
            resultId(model.resultId);
            profileId(model.profileId);
            score(model.score);
            dataSource(model.dataSource);
            rulesetName(model.rulesetName);
            evaluationContext(model.evaluationContext);
            startedOn(model.startedOn);
            completedOn(model.completedOn);
            jobName(model.jobName);
            jobRunId(model.jobRunId);
            rulesetEvaluationRunId(model.rulesetEvaluationRunId);
            ruleResults(model.ruleResults);
            analyzerResults(model.analyzerResults);
            observations(model.observations);
        }

        public final String getResultId() {
            return resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final Double getScore() {
            return score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRulesetName() {
            return rulesetName;
        }

        public final void setRulesetName(String rulesetName) {
            this.rulesetName = rulesetName;
        }

        @Override
        public final Builder rulesetName(String rulesetName) {
            this.rulesetName = rulesetName;
            return this;
        }

        public final String getEvaluationContext() {
            return evaluationContext;
        }

        public final void setEvaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        public final Builder evaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final Instant getStartedOn() {
            return startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobRunId() {
            return jobRunId;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final String getRulesetEvaluationRunId() {
            return rulesetEvaluationRunId;
        }

        public final void setRulesetEvaluationRunId(String rulesetEvaluationRunId) {
            this.rulesetEvaluationRunId = rulesetEvaluationRunId;
        }

        @Override
        public final Builder rulesetEvaluationRunId(String rulesetEvaluationRunId) {
            this.rulesetEvaluationRunId = rulesetEvaluationRunId;
            return this;
        }

        public final List<DataQualityRuleResult.Builder> getRuleResults() {
            List<DataQualityRuleResult.Builder> result = DataQualityRuleResultsCopier.copyToBuilder(this.ruleResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleResults(Collection<DataQualityRuleResult.BuilderImpl> ruleResults) {
            this.ruleResults = DataQualityRuleResultsCopier.copyFromBuilder(ruleResults);
        }

        @Override
        public final Builder ruleResults(Collection<DataQualityRuleResult> ruleResults) {
            this.ruleResults = DataQualityRuleResultsCopier.copy(ruleResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(DataQualityRuleResult... ruleResults) {
            ruleResults(Arrays.asList(ruleResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(Consumer<DataQualityRuleResult.Builder>... ruleResults) {
            ruleResults(Stream.of(ruleResults).map(c -> DataQualityRuleResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DataQualityAnalyzerResult.Builder> getAnalyzerResults() {
            List<DataQualityAnalyzerResult.Builder> result = DataQualityAnalyzerResultsCopier.copyToBuilder(this.analyzerResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalyzerResults(Collection<DataQualityAnalyzerResult.BuilderImpl> analyzerResults) {
            this.analyzerResults = DataQualityAnalyzerResultsCopier.copyFromBuilder(analyzerResults);
        }

        @Override
        public final Builder analyzerResults(Collection<DataQualityAnalyzerResult> analyzerResults) {
            this.analyzerResults = DataQualityAnalyzerResultsCopier.copy(analyzerResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzerResults(DataQualityAnalyzerResult... analyzerResults) {
            analyzerResults(Arrays.asList(analyzerResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzerResults(Consumer<DataQualityAnalyzerResult.Builder>... analyzerResults) {
            analyzerResults(Stream.of(analyzerResults).map(c -> DataQualityAnalyzerResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DataQualityObservation.Builder> getObservations() {
            List<DataQualityObservation.Builder> result = DataQualityObservationsCopier.copyToBuilder(this.observations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObservations(Collection<DataQualityObservation.BuilderImpl> observations) {
            this.observations = DataQualityObservationsCopier.copyFromBuilder(observations);
        }

        @Override
        public final Builder observations(Collection<DataQualityObservation> observations) {
            this.observations = DataQualityObservationsCopier.copy(observations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder observations(DataQualityObservation... observations) {
            observations(Arrays.asList(observations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder observations(Consumer<DataQualityObservation.Builder>... observations) {
            observations(Stream.of(observations).map(c -> DataQualityObservation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDataQualityResultResponse build() {
            return new GetDataQualityResultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
