/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListCustomEntityTypesRequest;
import software.amazon.awssdk.services.glue.model.ListCustomEntityTypesResponse;

public class ListCustomEntityTypesPublisher
implements SdkPublisher<ListCustomEntityTypesResponse> {
    private final GlueAsyncClient client;
    private final ListCustomEntityTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomEntityTypesPublisher(GlueAsyncClient client, ListCustomEntityTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomEntityTypesPublisher(GlueAsyncClient client, ListCustomEntityTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomEntityTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomEntityTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCustomEntityTypesResponseFetcher
    implements AsyncPageFetcher<ListCustomEntityTypesResponse> {
        private ListCustomEntityTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomEntityTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomEntityTypesResponse> nextPage(ListCustomEntityTypesResponse previousPage) {
            if (previousPage == null) {
                return ListCustomEntityTypesPublisher.this.client.listCustomEntityTypes(ListCustomEntityTypesPublisher.this.firstRequest);
            }
            return ListCustomEntityTypesPublisher.this.client.listCustomEntityTypes((ListCustomEntityTypesRequest)((Object)ListCustomEntityTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

