/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LastActiveDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LastActiveDefinition> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(LastActiveDefinition.getter(LastActiveDefinition::description)).setter(LastActiveDefinition.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedOn").getter(LastActiveDefinition.getter(LastActiveDefinition::lastModifiedOn)).setter(LastActiveDefinition.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<String> PARAMETER_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterSpec").getter(LastActiveDefinition.getter(LastActiveDefinition::parameterSpec)).setter(LastActiveDefinition.setter(Builder::parameterSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterSpec").build()}).build();
    private static final SdkField<String> BLUEPRINT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueprintLocation").getter(LastActiveDefinition.getter(LastActiveDefinition::blueprintLocation)).setter(LastActiveDefinition.setter(Builder::blueprintLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintLocation").build()}).build();
    private static final SdkField<String> BLUEPRINT_SERVICE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueprintServiceLocation").getter(LastActiveDefinition.getter(LastActiveDefinition::blueprintServiceLocation)).setter(LastActiveDefinition.setter(Builder::blueprintServiceLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintServiceLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, LAST_MODIFIED_ON_FIELD, PARAMETER_SPEC_FIELD, BLUEPRINT_LOCATION_FIELD, BLUEPRINT_SERVICE_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Description", DESCRIPTION_FIELD);
            this.put("LastModifiedOn", LAST_MODIFIED_ON_FIELD);
            this.put("ParameterSpec", PARAMETER_SPEC_FIELD);
            this.put("BlueprintLocation", BLUEPRINT_LOCATION_FIELD);
            this.put("BlueprintServiceLocation", BLUEPRINT_SERVICE_LOCATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String description;
    private final Instant lastModifiedOn;
    private final String parameterSpec;
    private final String blueprintLocation;
    private final String blueprintServiceLocation;

    private LastActiveDefinition(BuilderImpl builder) {
        this.description = builder.description;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.parameterSpec = builder.parameterSpec;
        this.blueprintLocation = builder.blueprintLocation;
        this.blueprintServiceLocation = builder.blueprintServiceLocation;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public final String parameterSpec() {
        return this.parameterSpec;
    }

    public final String blueprintLocation() {
        return this.blueprintLocation;
    }

    public final String blueprintServiceLocation() {
        return this.blueprintServiceLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintServiceLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastActiveDefinition)) {
            return false;
        }
        LastActiveDefinition other = (LastActiveDefinition)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.parameterSpec(), other.parameterSpec()) && Objects.equals(this.blueprintLocation(), other.blueprintLocation()) && Objects.equals(this.blueprintServiceLocation(), other.blueprintServiceLocation());
    }

    public final String toString() {
        return ToString.builder((String)"LastActiveDefinition").add("Description", (Object)this.description()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("ParameterSpec", (Object)this.parameterSpec()).add("BlueprintLocation", (Object)this.blueprintLocation()).add("BlueprintServiceLocation", (Object)this.blueprintServiceLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "ParameterSpec": {
                return Optional.ofNullable(clazz.cast(this.parameterSpec()));
            }
            case "BlueprintLocation": {
                return Optional.ofNullable(clazz.cast(this.blueprintLocation()));
            }
            case "BlueprintServiceLocation": {
                return Optional.ofNullable(clazz.cast(this.blueprintServiceLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LastActiveDefinition, T> g) {
        return obj -> g.apply((LastActiveDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private Instant lastModifiedOn;
        private String parameterSpec;
        private String blueprintLocation;
        private String blueprintServiceLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(LastActiveDefinition model) {
            this.description(model.description);
            this.lastModifiedOn(model.lastModifiedOn);
            this.parameterSpec(model.parameterSpec);
            this.blueprintLocation(model.blueprintLocation);
            this.blueprintServiceLocation(model.blueprintServiceLocation);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final String getParameterSpec() {
            return this.parameterSpec;
        }

        public final void setParameterSpec(String parameterSpec) {
            this.parameterSpec = parameterSpec;
        }

        @Override
        public final Builder parameterSpec(String parameterSpec) {
            this.parameterSpec = parameterSpec;
            return this;
        }

        public final String getBlueprintLocation() {
            return this.blueprintLocation;
        }

        public final void setBlueprintLocation(String blueprintLocation) {
            this.blueprintLocation = blueprintLocation;
        }

        @Override
        public final Builder blueprintLocation(String blueprintLocation) {
            this.blueprintLocation = blueprintLocation;
            return this;
        }

        public final String getBlueprintServiceLocation() {
            return this.blueprintServiceLocation;
        }

        public final void setBlueprintServiceLocation(String blueprintServiceLocation) {
            this.blueprintServiceLocation = blueprintServiceLocation;
        }

        @Override
        public final Builder blueprintServiceLocation(String blueprintServiceLocation) {
            this.blueprintServiceLocation = blueprintServiceLocation;
            return this;
        }

        public LastActiveDefinition build() {
            return new LastActiveDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LastActiveDefinition> {
        public Builder description(String var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder parameterSpec(String var1);

        public Builder blueprintLocation(String var1);

        public Builder blueprintServiceLocation(String var1);
    }
}

