/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DatapointInclusionAnnotation;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.InclusionAnnotationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutDataQualityStatisticAnnotationRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchPutDataQualityStatisticAnnotationRequest> {
    private static final SdkField<List<DatapointInclusionAnnotation>> INCLUSION_ANNOTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionAnnotations").getter(BatchPutDataQualityStatisticAnnotationRequest.getter(BatchPutDataQualityStatisticAnnotationRequest::inclusionAnnotations)).setter(BatchPutDataQualityStatisticAnnotationRequest.setter(Builder::inclusionAnnotations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatapointInclusionAnnotation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(BatchPutDataQualityStatisticAnnotationRequest.getter(BatchPutDataQualityStatisticAnnotationRequest::clientToken)).setter(BatchPutDataQualityStatisticAnnotationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUSION_ANNOTATIONS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InclusionAnnotations", INCLUSION_ANNOTATIONS_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final List<DatapointInclusionAnnotation> inclusionAnnotations;
    private final String clientToken;

    private BatchPutDataQualityStatisticAnnotationRequest(BuilderImpl builder) {
        super(builder);
        this.inclusionAnnotations = builder.inclusionAnnotations;
        this.clientToken = builder.clientToken;
    }

    public final boolean hasInclusionAnnotations() {
        return this.inclusionAnnotations != null && !(this.inclusionAnnotations instanceof SdkAutoConstructList);
    }

    public final List<DatapointInclusionAnnotation> inclusionAnnotations() {
        return this.inclusionAnnotations;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionAnnotations() ? this.inclusionAnnotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutDataQualityStatisticAnnotationRequest)) {
            return false;
        }
        BatchPutDataQualityStatisticAnnotationRequest other = (BatchPutDataQualityStatisticAnnotationRequest)((Object)obj);
        return this.hasInclusionAnnotations() == other.hasInclusionAnnotations() && Objects.equals(this.inclusionAnnotations(), other.inclusionAnnotations()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutDataQualityStatisticAnnotationRequest").add("InclusionAnnotations", this.hasInclusionAnnotations() ? this.inclusionAnnotations() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InclusionAnnotations": {
                return Optional.ofNullable(clazz.cast(this.inclusionAnnotations()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutDataQualityStatisticAnnotationRequest, T> g) {
        return obj -> g.apply((BatchPutDataQualityStatisticAnnotationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private List<DatapointInclusionAnnotation> inclusionAnnotations = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutDataQualityStatisticAnnotationRequest model) {
            super(model);
            this.inclusionAnnotations(model.inclusionAnnotations);
            this.clientToken(model.clientToken);
        }

        public final List<DatapointInclusionAnnotation.Builder> getInclusionAnnotations() {
            List<DatapointInclusionAnnotation.Builder> result = InclusionAnnotationListCopier.copyToBuilder(this.inclusionAnnotations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInclusionAnnotations(Collection<DatapointInclusionAnnotation.BuilderImpl> inclusionAnnotations) {
            this.inclusionAnnotations = InclusionAnnotationListCopier.copyFromBuilder(inclusionAnnotations);
        }

        @Override
        public final Builder inclusionAnnotations(Collection<DatapointInclusionAnnotation> inclusionAnnotations) {
            this.inclusionAnnotations = InclusionAnnotationListCopier.copy(inclusionAnnotations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionAnnotations(DatapointInclusionAnnotation ... inclusionAnnotations) {
            this.inclusionAnnotations(Arrays.asList(inclusionAnnotations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionAnnotations(Consumer<DatapointInclusionAnnotation.Builder> ... inclusionAnnotations) {
            this.inclusionAnnotations(Stream.of(inclusionAnnotations).map(c -> (DatapointInclusionAnnotation)((DatapointInclusionAnnotation.Builder)DatapointInclusionAnnotation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutDataQualityStatisticAnnotationRequest build() {
            return new BatchPutDataQualityStatisticAnnotationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutDataQualityStatisticAnnotationRequest> {
        public Builder inclusionAnnotations(Collection<DatapointInclusionAnnotation> var1);

        public Builder inclusionAnnotations(DatapointInclusionAnnotation ... var1);

        public Builder inclusionAnnotations(Consumer<DatapointInclusionAnnotation.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

