/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how Amazon CloudWatch data should be encrypted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchEncryption.Builder, CloudWatchEncryption> {
    private static final SdkField<String> CLOUD_WATCH_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchEncryptionMode").getter(getter(CloudWatchEncryption::cloudWatchEncryptionModeAsString))
            .setter(setter(Builder::cloudWatchEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEncryptionMode").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(CloudWatchEncryption::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_ENCRYPTION_MODE_FIELD, KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CloudWatchEncryptionMode", CLOUD_WATCH_ENCRYPTION_MODE_FIELD);
                    put("KmsKeyArn", KMS_KEY_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String cloudWatchEncryptionMode;

    private final String kmsKeyArn;

    private CloudWatchEncryption(BuilderImpl builder) {
        this.cloudWatchEncryptionMode = builder.cloudWatchEncryptionMode;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The encryption mode to use for CloudWatch data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cloudWatchEncryptionMode} will return {@link CloudWatchEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #cloudWatchEncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode to use for CloudWatch data.
     * @see CloudWatchEncryptionMode
     */
    public final CloudWatchEncryptionMode cloudWatchEncryptionMode() {
        return CloudWatchEncryptionMode.fromValue(cloudWatchEncryptionMode);
    }

    /**
     * <p>
     * The encryption mode to use for CloudWatch data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cloudWatchEncryptionMode} will return {@link CloudWatchEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #cloudWatchEncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode to use for CloudWatch data.
     * @see CloudWatchEncryptionMode
     */
    public final String cloudWatchEncryptionModeAsString() {
        return cloudWatchEncryptionMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchEncryption)) {
            return false;
        }
        CloudWatchEncryption other = (CloudWatchEncryption) obj;
        return Objects.equals(cloudWatchEncryptionModeAsString(), other.cloudWatchEncryptionModeAsString())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchEncryption").add("CloudWatchEncryptionMode", cloudWatchEncryptionModeAsString())
                .add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchEncryptionMode":
            return Optional.ofNullable(clazz.cast(cloudWatchEncryptionModeAsString()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchEncryption, T> g) {
        return obj -> g.apply((CloudWatchEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchEncryption> {
        /**
         * <p>
         * The encryption mode to use for CloudWatch data.
         * </p>
         * 
         * @param cloudWatchEncryptionMode
         *        The encryption mode to use for CloudWatch data.
         * @see CloudWatchEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchEncryptionMode
         */
        Builder cloudWatchEncryptionMode(String cloudWatchEncryptionMode);

        /**
         * <p>
         * The encryption mode to use for CloudWatch data.
         * </p>
         * 
         * @param cloudWatchEncryptionMode
         *        The encryption mode to use for CloudWatch data.
         * @see CloudWatchEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchEncryptionMode
         */
        Builder cloudWatchEncryptionMode(CloudWatchEncryptionMode cloudWatchEncryptionMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchEncryptionMode;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchEncryption model) {
            cloudWatchEncryptionMode(model.cloudWatchEncryptionMode);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getCloudWatchEncryptionMode() {
            return cloudWatchEncryptionMode;
        }

        public final void setCloudWatchEncryptionMode(String cloudWatchEncryptionMode) {
            this.cloudWatchEncryptionMode = cloudWatchEncryptionMode;
        }

        @Override
        public final Builder cloudWatchEncryptionMode(String cloudWatchEncryptionMode) {
            this.cloudWatchEncryptionMode = cloudWatchEncryptionMode;
            return this;
        }

        @Override
        public final Builder cloudWatchEncryptionMode(CloudWatchEncryptionMode cloudWatchEncryptionMode) {
            this.cloudWatchEncryptionMode(cloudWatchEncryptionMode == null ? null : cloudWatchEncryptionMode.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public CloudWatchEncryption build() {
            return new CloudWatchEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
