/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a directional edge in a directed acyclic graph (DAG).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeGenEdge implements SdkPojo, Serializable, ToCopyableBuilder<CodeGenEdge.Builder, CodeGenEdge> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(CodeGenEdge::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(CodeGenEdge::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> TARGET_PARAMETER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetParameter").getter(getter(CodeGenEdge::targetParameter)).setter(setter(Builder::targetParameter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGET_FIELD,
            TARGET_PARAMETER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Source", SOURCE_FIELD);
                    put("Target", TARGET_FIELD);
                    put("TargetParameter", TARGET_PARAMETER_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String target;

    private final String targetParameter;

    private CodeGenEdge(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.targetParameter = builder.targetParameter;
    }

    /**
     * <p>
     * The ID of the node at which the edge starts.
     * </p>
     * 
     * @return The ID of the node at which the edge starts.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The ID of the node at which the edge ends.
     * </p>
     * 
     * @return The ID of the node at which the edge ends.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The target of the edge.
     * </p>
     * 
     * @return The target of the edge.
     */
    public final String targetParameter() {
        return targetParameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(targetParameter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeGenEdge)) {
            return false;
        }
        CodeGenEdge other = (CodeGenEdge) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(target(), other.target())
                && Objects.equals(targetParameter(), other.targetParameter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeGenEdge").add("Source", source()).add("Target", target())
                .add("TargetParameter", targetParameter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "TargetParameter":
            return Optional.ofNullable(clazz.cast(targetParameter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CodeGenEdge, T> g) {
        return obj -> g.apply((CodeGenEdge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeGenEdge> {
        /**
         * <p>
         * The ID of the node at which the edge starts.
         * </p>
         * 
         * @param source
         *        The ID of the node at which the edge starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The ID of the node at which the edge ends.
         * </p>
         * 
         * @param target
         *        The ID of the node at which the edge ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The target of the edge.
         * </p>
         * 
         * @param targetParameter
         *        The target of the edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetParameter(String targetParameter);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String target;

        private String targetParameter;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeGenEdge model) {
            source(model.source);
            target(model.target);
            targetParameter(model.targetParameter);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getTargetParameter() {
            return targetParameter;
        }

        public final void setTargetParameter(String targetParameter) {
            this.targetParameter = targetParameter;
        }

        @Override
        public final Builder targetParameter(String targetParameter) {
            this.targetParameter = targetParameter;
            return this;
        }

        @Override
        public CodeGenEdge build() {
            return new CodeGenEdge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
