/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the generated column-level statistics for a table or partition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnStatistics.Builder, ColumnStatistics> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(ColumnStatistics::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<String> COLUMN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnType").getter(getter(ColumnStatistics::columnType)).setter(setter(Builder::columnType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnType").build()).build();

    private static final SdkField<Instant> ANALYZED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AnalyzedTime").getter(getter(ColumnStatistics::analyzedTime)).setter(setter(Builder::analyzedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzedTime").build()).build();

    private static final SdkField<ColumnStatisticsData> STATISTICS_DATA_FIELD = SdkField
            .<ColumnStatisticsData> builder(MarshallingType.SDK_POJO).memberName("StatisticsData")
            .getter(getter(ColumnStatistics::statisticsData)).setter(setter(Builder::statisticsData))
            .constructor(ColumnStatisticsData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticsData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            COLUMN_TYPE_FIELD, ANALYZED_TIME_FIELD, STATISTICS_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ColumnName", COLUMN_NAME_FIELD);
                    put("ColumnType", COLUMN_TYPE_FIELD);
                    put("AnalyzedTime", ANALYZED_TIME_FIELD);
                    put("StatisticsData", STATISTICS_DATA_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String columnType;

    private final Instant analyzedTime;

    private final ColumnStatisticsData statisticsData;

    private ColumnStatistics(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnType = builder.columnType;
        this.analyzedTime = builder.analyzedTime;
        this.statisticsData = builder.statisticsData;
    }

    /**
     * <p>
     * Name of column which statistics belong to.
     * </p>
     * 
     * @return Name of column which statistics belong to.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The data type of the column.
     * </p>
     * 
     * @return The data type of the column.
     */
    public final String columnType() {
        return columnType;
    }

    /**
     * <p>
     * The timestamp of when column statistics were generated.
     * </p>
     * 
     * @return The timestamp of when column statistics were generated.
     */
    public final Instant analyzedTime() {
        return analyzedTime;
    }

    /**
     * <p>
     * A <code>ColumnStatisticData</code> object that contains the statistics data values.
     * </p>
     * 
     * @return A <code>ColumnStatisticData</code> object that contains the statistics data values.
     */
    public final ColumnStatisticsData statisticsData() {
        return statisticsData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(columnType());
        hashCode = 31 * hashCode + Objects.hashCode(analyzedTime());
        hashCode = 31 * hashCode + Objects.hashCode(statisticsData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatistics)) {
            return false;
        }
        ColumnStatistics other = (ColumnStatistics) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(columnType(), other.columnType())
                && Objects.equals(analyzedTime(), other.analyzedTime())
                && Objects.equals(statisticsData(), other.statisticsData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnStatistics").add("ColumnName", columnName()).add("ColumnType", columnType())
                .add("AnalyzedTime", analyzedTime()).add("StatisticsData", statisticsData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "ColumnType":
            return Optional.ofNullable(clazz.cast(columnType()));
        case "AnalyzedTime":
            return Optional.ofNullable(clazz.cast(analyzedTime()));
        case "StatisticsData":
            return Optional.ofNullable(clazz.cast(statisticsData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ColumnStatistics, T> g) {
        return obj -> g.apply((ColumnStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnStatistics> {
        /**
         * <p>
         * Name of column which statistics belong to.
         * </p>
         * 
         * @param columnName
         *        Name of column which statistics belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The data type of the column.
         * </p>
         * 
         * @param columnType
         *        The data type of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnType(String columnType);

        /**
         * <p>
         * The timestamp of when column statistics were generated.
         * </p>
         * 
         * @param analyzedTime
         *        The timestamp of when column statistics were generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzedTime(Instant analyzedTime);

        /**
         * <p>
         * A <code>ColumnStatisticData</code> object that contains the statistics data values.
         * </p>
         * 
         * @param statisticsData
         *        A <code>ColumnStatisticData</code> object that contains the statistics data values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsData(ColumnStatisticsData statisticsData);

        /**
         * <p>
         * A <code>ColumnStatisticData</code> object that contains the statistics data values.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnStatisticsData.Builder} avoiding
         * the need to create one manually via {@link ColumnStatisticsData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnStatisticsData.Builder#build()} is called immediately and
         * its result is passed to {@link #statisticsData(ColumnStatisticsData)}.
         * 
         * @param statisticsData
         *        a consumer that will call methods on {@link ColumnStatisticsData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statisticsData(ColumnStatisticsData)
         */
        default Builder statisticsData(Consumer<ColumnStatisticsData.Builder> statisticsData) {
            return statisticsData(ColumnStatisticsData.builder().applyMutation(statisticsData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String columnType;

        private Instant analyzedTime;

        private ColumnStatisticsData statisticsData;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnStatistics model) {
            columnName(model.columnName);
            columnType(model.columnType);
            analyzedTime(model.analyzedTime);
            statisticsData(model.statisticsData);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getColumnType() {
            return columnType;
        }

        public final void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        @Override
        public final Builder columnType(String columnType) {
            this.columnType = columnType;
            return this;
        }

        public final Instant getAnalyzedTime() {
            return analyzedTime;
        }

        public final void setAnalyzedTime(Instant analyzedTime) {
            this.analyzedTime = analyzedTime;
        }

        @Override
        public final Builder analyzedTime(Instant analyzedTime) {
            this.analyzedTime = analyzedTime;
            return this;
        }

        public final ColumnStatisticsData.Builder getStatisticsData() {
            return statisticsData != null ? statisticsData.toBuilder() : null;
        }

        public final void setStatisticsData(ColumnStatisticsData.BuilderImpl statisticsData) {
            this.statisticsData = statisticsData != null ? statisticsData.build() : null;
        }

        @Override
        public final Builder statisticsData(ColumnStatisticsData statisticsData) {
            this.statisticsData = statisticsData;
            return this;
        }

        @Override
        public ColumnStatistics build() {
            return new ColumnStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
