/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a Delta data store to crawl one or more Delta tables.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeltaTarget implements SdkPojo, Serializable, ToCopyableBuilder<DeltaTarget.Builder, DeltaTarget> {
    private static final SdkField<List<String>> DELTA_TABLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeltaTables")
            .getter(getter(DeltaTarget::deltaTables))
            .setter(setter(Builder::deltaTables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeltaTables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(DeltaTarget::connectionName)).setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<Boolean> WRITE_MANIFEST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WriteManifest").getter(getter(DeltaTarget::writeManifest)).setter(setter(Builder::writeManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteManifest").build()).build();

    private static final SdkField<Boolean> CREATE_NATIVE_DELTA_TABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CreateNativeDeltaTable").getter(getter(DeltaTarget::createNativeDeltaTable))
            .setter(setter(Builder::createNativeDeltaTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateNativeDeltaTable").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELTA_TABLES_FIELD,
            CONNECTION_NAME_FIELD, WRITE_MANIFEST_FIELD, CREATE_NATIVE_DELTA_TABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DeltaTables", DELTA_TABLES_FIELD);
                    put("ConnectionName", CONNECTION_NAME_FIELD);
                    put("WriteManifest", WRITE_MANIFEST_FIELD);
                    put("CreateNativeDeltaTable", CREATE_NATIVE_DELTA_TABLE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> deltaTables;

    private final String connectionName;

    private final Boolean writeManifest;

    private final Boolean createNativeDeltaTable;

    private DeltaTarget(BuilderImpl builder) {
        this.deltaTables = builder.deltaTables;
        this.connectionName = builder.connectionName;
        this.writeManifest = builder.writeManifest;
        this.createNativeDeltaTable = builder.createNativeDeltaTable;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeltaTables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeltaTables() {
        return deltaTables != null && !(deltaTables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the Amazon S3 paths to the Delta tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeltaTables} method.
     * </p>
     * 
     * @return A list of the Amazon S3 paths to the Delta tables.
     */
    public final List<String> deltaTables() {
        return deltaTables;
    }

    /**
     * <p>
     * The name of the connection to use to connect to the Delta table target.
     * </p>
     * 
     * @return The name of the connection to use to connect to the Delta table target.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * Specifies whether to write the manifest files to the Delta table path.
     * </p>
     * 
     * @return Specifies whether to write the manifest files to the Delta table path.
     */
    public final Boolean writeManifest() {
        return writeManifest;
    }

    /**
     * <p>
     * Specifies whether the crawler will create native tables, to allow integration with query engines that support
     * querying of the Delta transaction log directly.
     * </p>
     * 
     * @return Specifies whether the crawler will create native tables, to allow integration with query engines that
     *         support querying of the Delta transaction log directly.
     */
    public final Boolean createNativeDeltaTable() {
        return createNativeDeltaTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDeltaTables() ? deltaTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(writeManifest());
        hashCode = 31 * hashCode + Objects.hashCode(createNativeDeltaTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeltaTarget)) {
            return false;
        }
        DeltaTarget other = (DeltaTarget) obj;
        return hasDeltaTables() == other.hasDeltaTables() && Objects.equals(deltaTables(), other.deltaTables())
                && Objects.equals(connectionName(), other.connectionName())
                && Objects.equals(writeManifest(), other.writeManifest())
                && Objects.equals(createNativeDeltaTable(), other.createNativeDeltaTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeltaTarget").add("DeltaTables", hasDeltaTables() ? deltaTables() : null)
                .add("ConnectionName", connectionName()).add("WriteManifest", writeManifest())
                .add("CreateNativeDeltaTable", createNativeDeltaTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeltaTables":
            return Optional.ofNullable(clazz.cast(deltaTables()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "WriteManifest":
            return Optional.ofNullable(clazz.cast(writeManifest()));
        case "CreateNativeDeltaTable":
            return Optional.ofNullable(clazz.cast(createNativeDeltaTable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeltaTarget, T> g) {
        return obj -> g.apply((DeltaTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeltaTarget> {
        /**
         * <p>
         * A list of the Amazon S3 paths to the Delta tables.
         * </p>
         * 
         * @param deltaTables
         *        A list of the Amazon S3 paths to the Delta tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deltaTables(Collection<String> deltaTables);

        /**
         * <p>
         * A list of the Amazon S3 paths to the Delta tables.
         * </p>
         * 
         * @param deltaTables
         *        A list of the Amazon S3 paths to the Delta tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deltaTables(String... deltaTables);

        /**
         * <p>
         * The name of the connection to use to connect to the Delta table target.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection to use to connect to the Delta table target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * Specifies whether to write the manifest files to the Delta table path.
         * </p>
         * 
         * @param writeManifest
         *        Specifies whether to write the manifest files to the Delta table path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeManifest(Boolean writeManifest);

        /**
         * <p>
         * Specifies whether the crawler will create native tables, to allow integration with query engines that support
         * querying of the Delta transaction log directly.
         * </p>
         * 
         * @param createNativeDeltaTable
         *        Specifies whether the crawler will create native tables, to allow integration with query engines that
         *        support querying of the Delta transaction log directly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createNativeDeltaTable(Boolean createNativeDeltaTable);
    }

    static final class BuilderImpl implements Builder {
        private List<String> deltaTables = DefaultSdkAutoConstructList.getInstance();

        private String connectionName;

        private Boolean writeManifest;

        private Boolean createNativeDeltaTable;

        private BuilderImpl() {
        }

        private BuilderImpl(DeltaTarget model) {
            deltaTables(model.deltaTables);
            connectionName(model.connectionName);
            writeManifest(model.writeManifest);
            createNativeDeltaTable(model.createNativeDeltaTable);
        }

        public final Collection<String> getDeltaTables() {
            if (deltaTables instanceof SdkAutoConstructList) {
                return null;
            }
            return deltaTables;
        }

        public final void setDeltaTables(Collection<String> deltaTables) {
            this.deltaTables = PathListCopier.copy(deltaTables);
        }

        @Override
        public final Builder deltaTables(Collection<String> deltaTables) {
            this.deltaTables = PathListCopier.copy(deltaTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deltaTables(String... deltaTables) {
            deltaTables(Arrays.asList(deltaTables));
            return this;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final Boolean getWriteManifest() {
            return writeManifest;
        }

        public final void setWriteManifest(Boolean writeManifest) {
            this.writeManifest = writeManifest;
        }

        @Override
        public final Builder writeManifest(Boolean writeManifest) {
            this.writeManifest = writeManifest;
            return this;
        }

        public final Boolean getCreateNativeDeltaTable() {
            return createNativeDeltaTable;
        }

        public final void setCreateNativeDeltaTable(Boolean createNativeDeltaTable) {
            this.createNativeDeltaTable = createNativeDeltaTable;
        }

        @Override
        public final Builder createNativeDeltaTable(Boolean createNativeDeltaTable) {
            this.createNativeDeltaTable = createNativeDeltaTable;
            return this;
        }

        @Override
        public DeltaTarget build() {
            return new DeltaTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
