/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetColumnStatisticsTaskRunsResponse extends GlueResponse implements
        ToCopyableBuilder<GetColumnStatisticsTaskRunsResponse.Builder, GetColumnStatisticsTaskRunsResponse> {
    private static final SdkField<List<ColumnStatisticsTaskRun>> COLUMN_STATISTICS_TASK_RUNS_FIELD = SdkField
            .<List<ColumnStatisticsTaskRun>> builder(MarshallingType.LIST)
            .memberName("ColumnStatisticsTaskRuns")
            .getter(getter(GetColumnStatisticsTaskRunsResponse::columnStatisticsTaskRuns))
            .setter(setter(Builder::columnStatisticsTaskRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnStatisticsTaskRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnStatisticsTaskRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetColumnStatisticsTaskRunsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLUMN_STATISTICS_TASK_RUNS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ColumnStatisticsTaskRuns", COLUMN_STATISTICS_TASK_RUNS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<ColumnStatisticsTaskRun> columnStatisticsTaskRuns;

    private final String nextToken;

    private GetColumnStatisticsTaskRunsResponse(BuilderImpl builder) {
        super(builder);
        this.columnStatisticsTaskRuns = builder.columnStatisticsTaskRuns;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnStatisticsTaskRuns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasColumnStatisticsTaskRuns() {
        return columnStatisticsTaskRuns != null && !(columnStatisticsTaskRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of column statistics task runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnStatisticsTaskRuns} method.
     * </p>
     * 
     * @return A list of column statistics task runs.
     */
    public final List<ColumnStatisticsTaskRun> columnStatisticsTaskRuns() {
        return columnStatisticsTaskRuns;
    }

    /**
     * <p>
     * A continuation token, if not all task runs have yet been returned.
     * </p>
     * 
     * @return A continuation token, if not all task runs have yet been returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnStatisticsTaskRuns() ? columnStatisticsTaskRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetColumnStatisticsTaskRunsResponse)) {
            return false;
        }
        GetColumnStatisticsTaskRunsResponse other = (GetColumnStatisticsTaskRunsResponse) obj;
        return hasColumnStatisticsTaskRuns() == other.hasColumnStatisticsTaskRuns()
                && Objects.equals(columnStatisticsTaskRuns(), other.columnStatisticsTaskRuns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetColumnStatisticsTaskRunsResponse")
                .add("ColumnStatisticsTaskRuns", hasColumnStatisticsTaskRuns() ? columnStatisticsTaskRuns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnStatisticsTaskRuns":
            return Optional.ofNullable(clazz.cast(columnStatisticsTaskRuns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetColumnStatisticsTaskRunsResponse, T> g) {
        return obj -> g.apply((GetColumnStatisticsTaskRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetColumnStatisticsTaskRunsResponse> {
        /**
         * <p>
         * A list of column statistics task runs.
         * </p>
         * 
         * @param columnStatisticsTaskRuns
         *        A list of column statistics task runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsTaskRuns(Collection<ColumnStatisticsTaskRun> columnStatisticsTaskRuns);

        /**
         * <p>
         * A list of column statistics task runs.
         * </p>
         * 
         * @param columnStatisticsTaskRuns
         *        A list of column statistics task runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsTaskRuns(ColumnStatisticsTaskRun... columnStatisticsTaskRuns);

        /**
         * <p>
         * A list of column statistics task runs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.ColumnStatisticsTaskRun.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.glue.model.ColumnStatisticsTaskRun#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.ColumnStatisticsTaskRun.Builder#build()} is called
         * immediately and its result is passed to {@link #columnStatisticsTaskRuns(List<ColumnStatisticsTaskRun>)}.
         * 
         * @param columnStatisticsTaskRuns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.ColumnStatisticsTaskRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnStatisticsTaskRuns(java.util.Collection<ColumnStatisticsTaskRun>)
         */
        Builder columnStatisticsTaskRuns(Consumer<ColumnStatisticsTaskRun.Builder>... columnStatisticsTaskRuns);

        /**
         * <p>
         * A continuation token, if not all task runs have yet been returned.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if not all task runs have yet been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<ColumnStatisticsTaskRun> columnStatisticsTaskRuns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetColumnStatisticsTaskRunsResponse model) {
            super(model);
            columnStatisticsTaskRuns(model.columnStatisticsTaskRuns);
            nextToken(model.nextToken);
        }

        public final List<ColumnStatisticsTaskRun.Builder> getColumnStatisticsTaskRuns() {
            List<ColumnStatisticsTaskRun.Builder> result = ColumnStatisticsTaskRunsListCopier
                    .copyToBuilder(this.columnStatisticsTaskRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnStatisticsTaskRuns(Collection<ColumnStatisticsTaskRun.BuilderImpl> columnStatisticsTaskRuns) {
            this.columnStatisticsTaskRuns = ColumnStatisticsTaskRunsListCopier.copyFromBuilder(columnStatisticsTaskRuns);
        }

        @Override
        public final Builder columnStatisticsTaskRuns(Collection<ColumnStatisticsTaskRun> columnStatisticsTaskRuns) {
            this.columnStatisticsTaskRuns = ColumnStatisticsTaskRunsListCopier.copy(columnStatisticsTaskRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsTaskRuns(ColumnStatisticsTaskRun... columnStatisticsTaskRuns) {
            columnStatisticsTaskRuns(Arrays.asList(columnStatisticsTaskRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsTaskRuns(Consumer<ColumnStatisticsTaskRun.Builder>... columnStatisticsTaskRuns) {
            columnStatisticsTaskRuns(Stream.of(columnStatisticsTaskRuns)
                    .map(c -> ColumnStatisticsTaskRun.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetColumnStatisticsTaskRunsResponse build() {
            return new GetColumnStatisticsTaskRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
