/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSchemaVersionsDiffRequest extends GlueRequest implements
        ToCopyableBuilder<GetSchemaVersionsDiffRequest.Builder, GetSchemaVersionsDiffRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.<SchemaId> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaId").getter(getter(GetSchemaVersionsDiffRequest::schemaId)).setter(setter(Builder::schemaId))
            .constructor(SchemaId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()).build();

    private static final SdkField<SchemaVersionNumber> FIRST_SCHEMA_VERSION_NUMBER_FIELD = SdkField
            .<SchemaVersionNumber> builder(MarshallingType.SDK_POJO).memberName("FirstSchemaVersionNumber")
            .getter(getter(GetSchemaVersionsDiffRequest::firstSchemaVersionNumber))
            .setter(setter(Builder::firstSchemaVersionNumber)).constructor(SchemaVersionNumber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSchemaVersionNumber").build())
            .build();

    private static final SdkField<SchemaVersionNumber> SECOND_SCHEMA_VERSION_NUMBER_FIELD = SdkField
            .<SchemaVersionNumber> builder(MarshallingType.SDK_POJO).memberName("SecondSchemaVersionNumber")
            .getter(getter(GetSchemaVersionsDiffRequest::secondSchemaVersionNumber))
            .setter(setter(Builder::secondSchemaVersionNumber)).constructor(SchemaVersionNumber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondSchemaVersionNumber").build())
            .build();

    private static final SdkField<String> SCHEMA_DIFF_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaDiffType").getter(getter(GetSchemaVersionsDiffRequest::schemaDiffTypeAsString))
            .setter(setter(Builder::schemaDiffType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDiffType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD,
            FIRST_SCHEMA_VERSION_NUMBER_FIELD, SECOND_SCHEMA_VERSION_NUMBER_FIELD, SCHEMA_DIFF_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SchemaId", SCHEMA_ID_FIELD);
                    put("FirstSchemaVersionNumber", FIRST_SCHEMA_VERSION_NUMBER_FIELD);
                    put("SecondSchemaVersionNumber", SECOND_SCHEMA_VERSION_NUMBER_FIELD);
                    put("SchemaDiffType", SCHEMA_DIFF_TYPE_FIELD);
                }
            });

    private final SchemaId schemaId;

    private final SchemaVersionNumber firstSchemaVersionNumber;

    private final SchemaVersionNumber secondSchemaVersionNumber;

    private final String schemaDiffType;

    private GetSchemaVersionsDiffRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.firstSchemaVersionNumber = builder.firstSchemaVersionNumber;
        this.secondSchemaVersionNumber = builder.secondSchemaVersionNumber;
        this.schemaDiffType = builder.schemaDiffType;
    }

    /**
     * <p>
     * This is a wrapper structure to contain schema identity fields. The structure contains:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or
     * <code>SchemaName</code> has to be provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be
     * provided.
     * </p>
     * </li>
     * </ul>
     * 
     * @return This is a wrapper structure to contain schema identity fields. The structure contains:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or
     *         <code>SchemaName</code> has to be provided.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has
     *         to be provided.
     *         </p>
     *         </li>
     */
    public final SchemaId schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * The first of the two schema versions to be compared.
     * </p>
     * 
     * @return The first of the two schema versions to be compared.
     */
    public final SchemaVersionNumber firstSchemaVersionNumber() {
        return firstSchemaVersionNumber;
    }

    /**
     * <p>
     * The second of the two schema versions to be compared.
     * </p>
     * 
     * @return The second of the two schema versions to be compared.
     */
    public final SchemaVersionNumber secondSchemaVersionNumber() {
        return secondSchemaVersionNumber;
    }

    /**
     * <p>
     * Refers to <code>SYNTAX_DIFF</code>, which is the currently supported diff type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaDiffType}
     * will return {@link SchemaDiffType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #schemaDiffTypeAsString}.
     * </p>
     * 
     * @return Refers to <code>SYNTAX_DIFF</code>, which is the currently supported diff type.
     * @see SchemaDiffType
     */
    public final SchemaDiffType schemaDiffType() {
        return SchemaDiffType.fromValue(schemaDiffType);
    }

    /**
     * <p>
     * Refers to <code>SYNTAX_DIFF</code>, which is the currently supported diff type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaDiffType}
     * will return {@link SchemaDiffType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #schemaDiffTypeAsString}.
     * </p>
     * 
     * @return Refers to <code>SYNTAX_DIFF</code>, which is the currently supported diff type.
     * @see SchemaDiffType
     */
    public final String schemaDiffTypeAsString() {
        return schemaDiffType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(firstSchemaVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(secondSchemaVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDiffTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaVersionsDiffRequest)) {
            return false;
        }
        GetSchemaVersionsDiffRequest other = (GetSchemaVersionsDiffRequest) obj;
        return Objects.equals(schemaId(), other.schemaId())
                && Objects.equals(firstSchemaVersionNumber(), other.firstSchemaVersionNumber())
                && Objects.equals(secondSchemaVersionNumber(), other.secondSchemaVersionNumber())
                && Objects.equals(schemaDiffTypeAsString(), other.schemaDiffTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSchemaVersionsDiffRequest").add("SchemaId", schemaId())
                .add("FirstSchemaVersionNumber", firstSchemaVersionNumber())
                .add("SecondSchemaVersionNumber", secondSchemaVersionNumber()).add("SchemaDiffType", schemaDiffTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "FirstSchemaVersionNumber":
            return Optional.ofNullable(clazz.cast(firstSchemaVersionNumber()));
        case "SecondSchemaVersionNumber":
            return Optional.ofNullable(clazz.cast(secondSchemaVersionNumber()));
        case "SchemaDiffType":
            return Optional.ofNullable(clazz.cast(schemaDiffTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaVersionsDiffRequest, T> g) {
        return obj -> g.apply((GetSchemaVersionsDiffRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSchemaVersionsDiffRequest> {
        /**
         * <p>
         * This is a wrapper structure to contain schema identity fields. The structure contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or
         * <code>SchemaName</code> has to be provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to
         * be provided.
         * </p>
         * </li>
         * </ul>
         * 
         * @param schemaId
         *        This is a wrapper structure to contain schema identity fields. The structure contains:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or
         *        <code>SchemaName</code> has to be provided.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code>
         *        has to be provided.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(SchemaId schemaId);

        /**
         * <p>
         * This is a wrapper structure to contain schema identity fields. The structure contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or
         * <code>SchemaName</code> has to be provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to
         * be provided.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link SchemaId.Builder} avoiding the need to
         * create one manually via {@link SchemaId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaId.Builder#build()} is called immediately and its result is
         * passed to {@link #schemaId(SchemaId)}.
         * 
         * @param schemaId
         *        a consumer that will call methods on {@link SchemaId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaId(SchemaId)
         */
        default Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return schemaId(SchemaId.builder().applyMutation(schemaId).build());
        }

        /**
         * <p>
         * The first of the two schema versions to be compared.
         * </p>
         * 
         * @param firstSchemaVersionNumber
         *        The first of the two schema versions to be compared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSchemaVersionNumber(SchemaVersionNumber firstSchemaVersionNumber);

        /**
         * <p>
         * The first of the two schema versions to be compared.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaVersionNumber.Builder} avoiding the
         * need to create one manually via {@link SchemaVersionNumber#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaVersionNumber.Builder#build()} is called immediately and
         * its result is passed to {@link #firstSchemaVersionNumber(SchemaVersionNumber)}.
         * 
         * @param firstSchemaVersionNumber
         *        a consumer that will call methods on {@link SchemaVersionNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firstSchemaVersionNumber(SchemaVersionNumber)
         */
        default Builder firstSchemaVersionNumber(Consumer<SchemaVersionNumber.Builder> firstSchemaVersionNumber) {
            return firstSchemaVersionNumber(SchemaVersionNumber.builder().applyMutation(firstSchemaVersionNumber).build());
        }

        /**
         * <p>
         * The second of the two schema versions to be compared.
         * </p>
         * 
         * @param secondSchemaVersionNumber
         *        The second of the two schema versions to be compared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondSchemaVersionNumber(SchemaVersionNumber secondSchemaVersionNumber);

        /**
         * <p>
         * The second of the two schema versions to be compared.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaVersionNumber.Builder} avoiding the
         * need to create one manually via {@link SchemaVersionNumber#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaVersionNumber.Builder#build()} is called immediately and
         * its result is passed to {@link #secondSchemaVersionNumber(SchemaVersionNumber)}.
         * 
         * @param secondSchemaVersionNumber
         *        a consumer that will call methods on {@link SchemaVersionNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondSchemaVersionNumber(SchemaVersionNumber)
         */
        default Builder secondSchemaVersionNumber(Consumer<SchemaVersionNumber.Builder> secondSchemaVersionNumber) {
            return secondSchemaVersionNumber(SchemaVersionNumber.builder().applyMutation(secondSchemaVersionNumber).build());
        }

        /**
         * <p>
         * Refers to <code>SYNTAX_DIFF</code>, which is the currently supported diff type.
         * </p>
         * 
         * @param schemaDiffType
         *        Refers to <code>SYNTAX_DIFF</code>, which is the currently supported diff type.
         * @see SchemaDiffType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaDiffType
         */
        Builder schemaDiffType(String schemaDiffType);

        /**
         * <p>
         * Refers to <code>SYNTAX_DIFF</code>, which is the currently supported diff type.
         * </p>
         * 
         * @param schemaDiffType
         *        Refers to <code>SYNTAX_DIFF</code>, which is the currently supported diff type.
         * @see SchemaDiffType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaDiffType
         */
        Builder schemaDiffType(SchemaDiffType schemaDiffType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private SchemaId schemaId;

        private SchemaVersionNumber firstSchemaVersionNumber;

        private SchemaVersionNumber secondSchemaVersionNumber;

        private String schemaDiffType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaVersionsDiffRequest model) {
            super(model);
            schemaId(model.schemaId);
            firstSchemaVersionNumber(model.firstSchemaVersionNumber);
            secondSchemaVersionNumber(model.secondSchemaVersionNumber);
            schemaDiffType(model.schemaDiffType);
        }

        public final SchemaId.Builder getSchemaId() {
            return schemaId != null ? schemaId.toBuilder() : null;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final SchemaVersionNumber.Builder getFirstSchemaVersionNumber() {
            return firstSchemaVersionNumber != null ? firstSchemaVersionNumber.toBuilder() : null;
        }

        public final void setFirstSchemaVersionNumber(SchemaVersionNumber.BuilderImpl firstSchemaVersionNumber) {
            this.firstSchemaVersionNumber = firstSchemaVersionNumber != null ? firstSchemaVersionNumber.build() : null;
        }

        @Override
        public final Builder firstSchemaVersionNumber(SchemaVersionNumber firstSchemaVersionNumber) {
            this.firstSchemaVersionNumber = firstSchemaVersionNumber;
            return this;
        }

        public final SchemaVersionNumber.Builder getSecondSchemaVersionNumber() {
            return secondSchemaVersionNumber != null ? secondSchemaVersionNumber.toBuilder() : null;
        }

        public final void setSecondSchemaVersionNumber(SchemaVersionNumber.BuilderImpl secondSchemaVersionNumber) {
            this.secondSchemaVersionNumber = secondSchemaVersionNumber != null ? secondSchemaVersionNumber.build() : null;
        }

        @Override
        public final Builder secondSchemaVersionNumber(SchemaVersionNumber secondSchemaVersionNumber) {
            this.secondSchemaVersionNumber = secondSchemaVersionNumber;
            return this;
        }

        public final String getSchemaDiffType() {
            return schemaDiffType;
        }

        public final void setSchemaDiffType(String schemaDiffType) {
            this.schemaDiffType = schemaDiffType;
        }

        @Override
        public final Builder schemaDiffType(String schemaDiffType) {
            this.schemaDiffType = schemaDiffType;
            return this;
        }

        @Override
        public final Builder schemaDiffType(SchemaDiffType schemaDiffType) {
            this.schemaDiffType(schemaDiffType == null ? null : schemaDiffType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSchemaVersionsDiffRequest build() {
            return new GetSchemaVersionsDiffRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
