/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Orphan file deletion metrics for Iceberg for the optimizer run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergOrphanFileDeletionMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergOrphanFileDeletionMetrics.Builder, IcebergOrphanFileDeletionMetrics> {
    private static final SdkField<Long> NUMBER_OF_ORPHAN_FILES_DELETED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfOrphanFilesDeleted")
            .getter(getter(IcebergOrphanFileDeletionMetrics::numberOfOrphanFilesDeleted))
            .setter(setter(Builder::numberOfOrphanFilesDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfOrphanFilesDeleted").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_DPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfDpus").getter(getter(IcebergOrphanFileDeletionMetrics::numberOfDpus))
            .setter(setter(Builder::numberOfDpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDpus").build()).build();

    private static final SdkField<Double> JOB_DURATION_IN_HOUR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("JobDurationInHour").getter(getter(IcebergOrphanFileDeletionMetrics::jobDurationInHour))
            .setter(setter(Builder::jobDurationInHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDurationInHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_ORPHAN_FILES_DELETED_FIELD, NUMBER_OF_DPUS_FIELD, JOB_DURATION_IN_HOUR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NumberOfOrphanFilesDeleted", NUMBER_OF_ORPHAN_FILES_DELETED_FIELD);
                    put("NumberOfDpus", NUMBER_OF_DPUS_FIELD);
                    put("JobDurationInHour", JOB_DURATION_IN_HOUR_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long numberOfOrphanFilesDeleted;

    private final Integer numberOfDpus;

    private final Double jobDurationInHour;

    private IcebergOrphanFileDeletionMetrics(BuilderImpl builder) {
        this.numberOfOrphanFilesDeleted = builder.numberOfOrphanFilesDeleted;
        this.numberOfDpus = builder.numberOfDpus;
        this.jobDurationInHour = builder.jobDurationInHour;
    }

    /**
     * <p>
     * The number of orphan files deleted by the orphan file deletion job run.
     * </p>
     * 
     * @return The number of orphan files deleted by the orphan file deletion job run.
     */
    public final Long numberOfOrphanFilesDeleted() {
        return numberOfOrphanFilesDeleted;
    }

    /**
     * <p>
     * The number of DPU hours consumed by the job.
     * </p>
     * 
     * @return The number of DPU hours consumed by the job.
     */
    public final Integer numberOfDpus() {
        return numberOfDpus;
    }

    /**
     * <p>
     * The duration of the job in hours.
     * </p>
     * 
     * @return The duration of the job in hours.
     */
    public final Double jobDurationInHour() {
        return jobDurationInHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfOrphanFilesDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDpus());
        hashCode = 31 * hashCode + Objects.hashCode(jobDurationInHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergOrphanFileDeletionMetrics)) {
            return false;
        }
        IcebergOrphanFileDeletionMetrics other = (IcebergOrphanFileDeletionMetrics) obj;
        return Objects.equals(numberOfOrphanFilesDeleted(), other.numberOfOrphanFilesDeleted())
                && Objects.equals(numberOfDpus(), other.numberOfDpus())
                && Objects.equals(jobDurationInHour(), other.jobDurationInHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergOrphanFileDeletionMetrics")
                .add("NumberOfOrphanFilesDeleted", numberOfOrphanFilesDeleted()).add("NumberOfDpus", numberOfDpus())
                .add("JobDurationInHour", jobDurationInHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfOrphanFilesDeleted":
            return Optional.ofNullable(clazz.cast(numberOfOrphanFilesDeleted()));
        case "NumberOfDpus":
            return Optional.ofNullable(clazz.cast(numberOfDpus()));
        case "JobDurationInHour":
            return Optional.ofNullable(clazz.cast(jobDurationInHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IcebergOrphanFileDeletionMetrics, T> g) {
        return obj -> g.apply((IcebergOrphanFileDeletionMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergOrphanFileDeletionMetrics> {
        /**
         * <p>
         * The number of orphan files deleted by the orphan file deletion job run.
         * </p>
         * 
         * @param numberOfOrphanFilesDeleted
         *        The number of orphan files deleted by the orphan file deletion job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfOrphanFilesDeleted(Long numberOfOrphanFilesDeleted);

        /**
         * <p>
         * The number of DPU hours consumed by the job.
         * </p>
         * 
         * @param numberOfDpus
         *        The number of DPU hours consumed by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDpus(Integer numberOfDpus);

        /**
         * <p>
         * The duration of the job in hours.
         * </p>
         * 
         * @param jobDurationInHour
         *        The duration of the job in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDurationInHour(Double jobDurationInHour);
    }

    static final class BuilderImpl implements Builder {
        private Long numberOfOrphanFilesDeleted;

        private Integer numberOfDpus;

        private Double jobDurationInHour;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergOrphanFileDeletionMetrics model) {
            numberOfOrphanFilesDeleted(model.numberOfOrphanFilesDeleted);
            numberOfDpus(model.numberOfDpus);
            jobDurationInHour(model.jobDurationInHour);
        }

        public final Long getNumberOfOrphanFilesDeleted() {
            return numberOfOrphanFilesDeleted;
        }

        public final void setNumberOfOrphanFilesDeleted(Long numberOfOrphanFilesDeleted) {
            this.numberOfOrphanFilesDeleted = numberOfOrphanFilesDeleted;
        }

        @Override
        public final Builder numberOfOrphanFilesDeleted(Long numberOfOrphanFilesDeleted) {
            this.numberOfOrphanFilesDeleted = numberOfOrphanFilesDeleted;
            return this;
        }

        public final Integer getNumberOfDpus() {
            return numberOfDpus;
        }

        public final void setNumberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
        }

        @Override
        public final Builder numberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
            return this;
        }

        public final Double getJobDurationInHour() {
            return jobDurationInHour;
        }

        public final void setJobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
        }

        @Override
        public final Builder jobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
            return this;
        }

        @Override
        public IcebergOrphanFileDeletionMetrics build() {
            return new IcebergOrphanFileDeletionMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
