/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a custom null value such as a zeros or other value being used as a null placeholder unique to the dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NullValueField implements SdkPojo, Serializable, ToCopyableBuilder<NullValueField.Builder, NullValueField> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(NullValueField::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Datatype> DATATYPE_FIELD = SdkField.<Datatype> builder(MarshallingType.SDK_POJO)
            .memberName("Datatype").getter(getter(NullValueField::datatype)).setter(setter(Builder::datatype))
            .constructor(Datatype::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datatype").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, DATATYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Value", VALUE_FIELD);
                    put("Datatype", DATATYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String value;

    private final Datatype datatype;

    private NullValueField(BuilderImpl builder) {
        this.value = builder.value;
        this.datatype = builder.datatype;
    }

    /**
     * <p>
     * The value of the null placeholder.
     * </p>
     * 
     * @return The value of the null placeholder.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The datatype of the value.
     * </p>
     * 
     * @return The datatype of the value.
     */
    public final Datatype datatype() {
        return datatype;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(datatype());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NullValueField)) {
            return false;
        }
        NullValueField other = (NullValueField) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(datatype(), other.datatype());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NullValueField").add("Value", value()).add("Datatype", datatype()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Datatype":
            return Optional.ofNullable(clazz.cast(datatype()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NullValueField, T> g) {
        return obj -> g.apply((NullValueField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NullValueField> {
        /**
         * <p>
         * The value of the null placeholder.
         * </p>
         * 
         * @param value
         *        The value of the null placeholder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The datatype of the value.
         * </p>
         * 
         * @param datatype
         *        The datatype of the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datatype(Datatype datatype);

        /**
         * <p>
         * The datatype of the value.
         * </p>
         * This is a convenience method that creates an instance of the {@link Datatype.Builder} avoiding the need to
         * create one manually via {@link Datatype#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Datatype.Builder#build()} is called immediately and its result is
         * passed to {@link #datatype(Datatype)}.
         * 
         * @param datatype
         *        a consumer that will call methods on {@link Datatype.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datatype(Datatype)
         */
        default Builder datatype(Consumer<Datatype.Builder> datatype) {
            return datatype(Datatype.builder().applyMutation(datatype).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private Datatype datatype;

        private BuilderImpl() {
        }

        private BuilderImpl(NullValueField model) {
            value(model.value);
            datatype(model.datatype);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Datatype.Builder getDatatype() {
            return datatype != null ? datatype.toBuilder() : null;
        }

        public final void setDatatype(Datatype.BuilderImpl datatype) {
            this.datatype = datatype != null ? datatype.build() : null;
        }

        @Override
        public final Builder datatype(Datatype datatype) {
            this.datatype = datatype;
            return this;
        }

        @Override
        public NullValueField build() {
            return new NullValueField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
