/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake Formation
 * generated authorization identifier and information from the request's authorization context.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuerySessionContext implements SdkPojo, Serializable,
        ToCopyableBuilder<QuerySessionContext.Builder, QuerySessionContext> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(QuerySessionContext::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<Instant> QUERY_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("QueryStartTime").getter(getter(QuerySessionContext::queryStartTime))
            .setter(setter(Builder::queryStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStartTime").build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(QuerySessionContext::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> QUERY_AUTHORIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryAuthorizationId").getter(getter(QuerySessionContext::queryAuthorizationId))
            .setter(setter(Builder::queryAuthorizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAuthorizationId").build())
            .build();

    private static final SdkField<Map<String, String>> ADDITIONAL_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalContext")
            .getter(getter(QuerySessionContext::additionalContext))
            .setter(setter(Builder::additionalContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalContext").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            QUERY_START_TIME_FIELD, CLUSTER_ID_FIELD, QUERY_AUTHORIZATION_ID_FIELD, ADDITIONAL_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("QueryId", QUERY_ID_FIELD);
                    put("QueryStartTime", QUERY_START_TIME_FIELD);
                    put("ClusterId", CLUSTER_ID_FIELD);
                    put("QueryAuthorizationId", QUERY_AUTHORIZATION_ID_FIELD);
                    put("AdditionalContext", ADDITIONAL_CONTEXT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String queryId;

    private final Instant queryStartTime;

    private final String clusterId;

    private final String queryAuthorizationId;

    private final Map<String, String> additionalContext;

    private QuerySessionContext(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryStartTime = builder.queryStartTime;
        this.clusterId = builder.clusterId;
        this.queryAuthorizationId = builder.queryAuthorizationId;
        this.additionalContext = builder.additionalContext;
    }

    /**
     * <p>
     * A unique identifier generated by the query engine for the query.
     * </p>
     * 
     * @return A unique identifier generated by the query engine for the query.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * A timestamp provided by the query engine for when the query started.
     * </p>
     * 
     * @return A timestamp provided by the query engine for when the query started.
     */
    public final Instant queryStartTime() {
        return queryStartTime;
    }

    /**
     * <p>
     * An identifier string for the consumer cluster.
     * </p>
     * 
     * @return An identifier string for the consumer cluster.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     * </p>
     * 
     * @return A cryptographically generated query identifier generated by Glue or Lake Formation.
     */
    public final String queryAuthorizationId() {
        return queryAuthorizationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalContext property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalContext() {
        return additionalContext != null && !(additionalContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An opaque string-string map passed by the query engine.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalContext} method.
     * </p>
     * 
     * @return An opaque string-string map passed by the query engine.
     */
    public final Map<String, String> additionalContext() {
        return additionalContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(queryStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(queryAuthorizationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalContext() ? additionalContext() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuerySessionContext)) {
            return false;
        }
        QuerySessionContext other = (QuerySessionContext) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(queryStartTime(), other.queryStartTime())
                && Objects.equals(clusterId(), other.clusterId())
                && Objects.equals(queryAuthorizationId(), other.queryAuthorizationId())
                && hasAdditionalContext() == other.hasAdditionalContext()
                && Objects.equals(additionalContext(), other.additionalContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuerySessionContext").add("QueryId", queryId()).add("QueryStartTime", queryStartTime())
                .add("ClusterId", clusterId()).add("QueryAuthorizationId", queryAuthorizationId())
                .add("AdditionalContext", hasAdditionalContext() ? additionalContext() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "QueryStartTime":
            return Optional.ofNullable(clazz.cast(queryStartTime()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "QueryAuthorizationId":
            return Optional.ofNullable(clazz.cast(queryAuthorizationId()));
        case "AdditionalContext":
            return Optional.ofNullable(clazz.cast(additionalContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QuerySessionContext, T> g) {
        return obj -> g.apply((QuerySessionContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuerySessionContext> {
        /**
         * <p>
         * A unique identifier generated by the query engine for the query.
         * </p>
         * 
         * @param queryId
         *        A unique identifier generated by the query engine for the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * A timestamp provided by the query engine for when the query started.
         * </p>
         * 
         * @param queryStartTime
         *        A timestamp provided by the query engine for when the query started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStartTime(Instant queryStartTime);

        /**
         * <p>
         * An identifier string for the consumer cluster.
         * </p>
         * 
         * @param clusterId
         *        An identifier string for the consumer cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * A cryptographically generated query identifier generated by Glue or Lake Formation.
         * </p>
         * 
         * @param queryAuthorizationId
         *        A cryptographically generated query identifier generated by Glue or Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryAuthorizationId(String queryAuthorizationId);

        /**
         * <p>
         * An opaque string-string map passed by the query engine.
         * </p>
         * 
         * @param additionalContext
         *        An opaque string-string map passed by the query engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalContext(Map<String, String> additionalContext);
    }

    static final class BuilderImpl implements Builder {
        private String queryId;

        private Instant queryStartTime;

        private String clusterId;

        private String queryAuthorizationId;

        private Map<String, String> additionalContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuerySessionContext model) {
            queryId(model.queryId);
            queryStartTime(model.queryStartTime);
            clusterId(model.clusterId);
            queryAuthorizationId(model.queryAuthorizationId);
            additionalContext(model.additionalContext);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final Instant getQueryStartTime() {
            return queryStartTime;
        }

        public final void setQueryStartTime(Instant queryStartTime) {
            this.queryStartTime = queryStartTime;
        }

        @Override
        public final Builder queryStartTime(Instant queryStartTime) {
            this.queryStartTime = queryStartTime;
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getQueryAuthorizationId() {
            return queryAuthorizationId;
        }

        public final void setQueryAuthorizationId(String queryAuthorizationId) {
            this.queryAuthorizationId = queryAuthorizationId;
        }

        @Override
        public final Builder queryAuthorizationId(String queryAuthorizationId) {
            this.queryAuthorizationId = queryAuthorizationId;
            return this;
        }

        public final Map<String, String> getAdditionalContext() {
            if (additionalContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalContext;
        }

        public final void setAdditionalContext(Map<String, String> additionalContext) {
            this.additionalContext = AdditionalContextMapCopier.copy(additionalContext);
        }

        @Override
        public final Builder additionalContext(Map<String, String> additionalContext) {
            this.additionalContext = AdditionalContextMapCopier.copy(additionalContext);
            return this;
        }

        @Override
        public QuerySessionContext build() {
            return new QuerySessionContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
