/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Amazon Redshift data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftSource implements SdkPojo, Serializable, ToCopyableBuilder<RedshiftSource.Builder, RedshiftSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RedshiftSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(RedshiftSource::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(RedshiftSource::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> REDSHIFT_TMP_DIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedshiftTmpDir").getter(getter(RedshiftSource::redshiftTmpDir)).setter(setter(Builder::redshiftTmpDir))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftTmpDir").build()).build();

    private static final SdkField<String> TMP_DIR_IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TmpDirIAMRole").getter(getter(RedshiftSource::tmpDirIAMRole)).setter(setter(Builder::tmpDirIAMRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TmpDirIAMRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATABASE_FIELD,
            TABLE_FIELD, REDSHIFT_TMP_DIR_FIELD, TMP_DIR_IAM_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Database", DATABASE_FIELD);
                    put("Table", TABLE_FIELD);
                    put("RedshiftTmpDir", REDSHIFT_TMP_DIR_FIELD);
                    put("TmpDirIAMRole", TMP_DIR_IAM_ROLE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String database;

    private final String table;

    private final String redshiftTmpDir;

    private final String tmpDirIAMRole;

    private RedshiftSource(BuilderImpl builder) {
        this.name = builder.name;
        this.database = builder.database;
        this.table = builder.table;
        this.redshiftTmpDir = builder.redshiftTmpDir;
        this.tmpDirIAMRole = builder.tmpDirIAMRole;
    }

    /**
     * <p>
     * The name of the Amazon Redshift data store.
     * </p>
     * 
     * @return The name of the Amazon Redshift data store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The database to read from.
     * </p>
     * 
     * @return The database to read from.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The database table to read from.
     * </p>
     * 
     * @return The database table to read from.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * The Amazon S3 path where temporary data can be staged when copying out of the database.
     * </p>
     * 
     * @return The Amazon S3 path where temporary data can be staged when copying out of the database.
     */
    public final String redshiftTmpDir() {
        return redshiftTmpDir;
    }

    /**
     * <p>
     * The IAM role with permissions.
     * </p>
     * 
     * @return The IAM role with permissions.
     */
    public final String tmpDirIAMRole() {
        return tmpDirIAMRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftTmpDir());
        hashCode = 31 * hashCode + Objects.hashCode(tmpDirIAMRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftSource)) {
            return false;
        }
        RedshiftSource other = (RedshiftSource) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(database(), other.database())
                && Objects.equals(table(), other.table()) && Objects.equals(redshiftTmpDir(), other.redshiftTmpDir())
                && Objects.equals(tmpDirIAMRole(), other.tmpDirIAMRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftSource").add("Name", name()).add("Database", database()).add("Table", table())
                .add("RedshiftTmpDir", redshiftTmpDir()).add("TmpDirIAMRole", tmpDirIAMRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "RedshiftTmpDir":
            return Optional.ofNullable(clazz.cast(redshiftTmpDir()));
        case "TmpDirIAMRole":
            return Optional.ofNullable(clazz.cast(tmpDirIAMRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftSource, T> g) {
        return obj -> g.apply((RedshiftSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftSource> {
        /**
         * <p>
         * The name of the Amazon Redshift data store.
         * </p>
         * 
         * @param name
         *        The name of the Amazon Redshift data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The database to read from.
         * </p>
         * 
         * @param database
         *        The database to read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The database table to read from.
         * </p>
         * 
         * @param table
         *        The database table to read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * The Amazon S3 path where temporary data can be staged when copying out of the database.
         * </p>
         * 
         * @param redshiftTmpDir
         *        The Amazon S3 path where temporary data can be staged when copying out of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftTmpDir(String redshiftTmpDir);

        /**
         * <p>
         * The IAM role with permissions.
         * </p>
         * 
         * @param tmpDirIAMRole
         *        The IAM role with permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tmpDirIAMRole(String tmpDirIAMRole);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String database;

        private String table;

        private String redshiftTmpDir;

        private String tmpDirIAMRole;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftSource model) {
            name(model.name);
            database(model.database);
            table(model.table);
            redshiftTmpDir(model.redshiftTmpDir);
            tmpDirIAMRole(model.tmpDirIAMRole);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getRedshiftTmpDir() {
            return redshiftTmpDir;
        }

        public final void setRedshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
        }

        @Override
        public final Builder redshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
            return this;
        }

        public final String getTmpDirIAMRole() {
            return tmpDirIAMRole;
        }

        public final void setTmpDirIAMRole(String tmpDirIAMRole) {
            this.tmpDirIAMRole = tmpDirIAMRole;
        }

        @Override
        public final Builder tmpDirIAMRole(String tmpDirIAMRole) {
            this.tmpDirIAMRole = tmpDirIAMRole;
            return this;
        }

        @Override
        public RedshiftSource build() {
            return new RedshiftSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
