/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a target that uses Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftTarget implements SdkPojo, Serializable, ToCopyableBuilder<RedshiftTarget.Builder, RedshiftTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RedshiftTarget::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(RedshiftTarget::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(RedshiftTarget::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(RedshiftTarget::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> REDSHIFT_TMP_DIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedshiftTmpDir").getter(getter(RedshiftTarget::redshiftTmpDir)).setter(setter(Builder::redshiftTmpDir))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftTmpDir").build()).build();

    private static final SdkField<String> TMP_DIR_IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TmpDirIAMRole").getter(getter(RedshiftTarget::tmpDirIAMRole)).setter(setter(Builder::tmpDirIAMRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TmpDirIAMRole").build()).build();

    private static final SdkField<UpsertRedshiftTargetOptions> UPSERT_REDSHIFT_OPTIONS_FIELD = SdkField
            .<UpsertRedshiftTargetOptions> builder(MarshallingType.SDK_POJO).memberName("UpsertRedshiftOptions")
            .getter(getter(RedshiftTarget::upsertRedshiftOptions)).setter(setter(Builder::upsertRedshiftOptions))
            .constructor(UpsertRedshiftTargetOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpsertRedshiftOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            DATABASE_FIELD, TABLE_FIELD, REDSHIFT_TMP_DIR_FIELD, TMP_DIR_IAM_ROLE_FIELD, UPSERT_REDSHIFT_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Inputs", INPUTS_FIELD);
                    put("Database", DATABASE_FIELD);
                    put("Table", TABLE_FIELD);
                    put("RedshiftTmpDir", REDSHIFT_TMP_DIR_FIELD);
                    put("TmpDirIAMRole", TMP_DIR_IAM_ROLE_FIELD);
                    put("UpsertRedshiftOptions", UPSERT_REDSHIFT_OPTIONS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String database;

    private final String table;

    private final String redshiftTmpDir;

    private final String tmpDirIAMRole;

    private final UpsertRedshiftTargetOptions upsertRedshiftOptions;

    private RedshiftTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.database = builder.database;
        this.table = builder.table;
        this.redshiftTmpDir = builder.redshiftTmpDir;
        this.tmpDirIAMRole = builder.tmpDirIAMRole;
        this.upsertRedshiftOptions = builder.upsertRedshiftOptions;
    }

    /**
     * <p>
     * The name of the data target.
     * </p>
     * 
     * @return The name of the data target.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The nodes that are inputs to the data target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The nodes that are inputs to the data target.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * The name of the database to write to.
     * </p>
     * 
     * @return The name of the database to write to.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The name of the table in the database to write to.
     * </p>
     * 
     * @return The name of the table in the database to write to.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * The Amazon S3 path where temporary data can be staged when copying out of the database.
     * </p>
     * 
     * @return The Amazon S3 path where temporary data can be staged when copying out of the database.
     */
    public final String redshiftTmpDir() {
        return redshiftTmpDir;
    }

    /**
     * <p>
     * The IAM role with permissions.
     * </p>
     * 
     * @return The IAM role with permissions.
     */
    public final String tmpDirIAMRole() {
        return tmpDirIAMRole;
    }

    /**
     * <p>
     * The set of options to configure an upsert operation when writing to a Redshift target.
     * </p>
     * 
     * @return The set of options to configure an upsert operation when writing to a Redshift target.
     */
    public final UpsertRedshiftTargetOptions upsertRedshiftOptions() {
        return upsertRedshiftOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftTmpDir());
        hashCode = 31 * hashCode + Objects.hashCode(tmpDirIAMRole());
        hashCode = 31 * hashCode + Objects.hashCode(upsertRedshiftOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftTarget)) {
            return false;
        }
        RedshiftTarget other = (RedshiftTarget) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(database(), other.database())
                && Objects.equals(table(), other.table()) && Objects.equals(redshiftTmpDir(), other.redshiftTmpDir())
                && Objects.equals(tmpDirIAMRole(), other.tmpDirIAMRole())
                && Objects.equals(upsertRedshiftOptions(), other.upsertRedshiftOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftTarget").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("Database", database()).add("Table", table()).add("RedshiftTmpDir", redshiftTmpDir())
                .add("TmpDirIAMRole", tmpDirIAMRole()).add("UpsertRedshiftOptions", upsertRedshiftOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "RedshiftTmpDir":
            return Optional.ofNullable(clazz.cast(redshiftTmpDir()));
        case "TmpDirIAMRole":
            return Optional.ofNullable(clazz.cast(tmpDirIAMRole()));
        case "UpsertRedshiftOptions":
            return Optional.ofNullable(clazz.cast(upsertRedshiftOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftTarget, T> g) {
        return obj -> g.apply((RedshiftTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftTarget> {
        /**
         * <p>
         * The name of the data target.
         * </p>
         * 
         * @param name
         *        The name of the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The nodes that are inputs to the data target.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The nodes that are inputs to the data target.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * The name of the database to write to.
         * </p>
         * 
         * @param database
         *        The name of the database to write to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The name of the table in the database to write to.
         * </p>
         * 
         * @param table
         *        The name of the table in the database to write to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * The Amazon S3 path where temporary data can be staged when copying out of the database.
         * </p>
         * 
         * @param redshiftTmpDir
         *        The Amazon S3 path where temporary data can be staged when copying out of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftTmpDir(String redshiftTmpDir);

        /**
         * <p>
         * The IAM role with permissions.
         * </p>
         * 
         * @param tmpDirIAMRole
         *        The IAM role with permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tmpDirIAMRole(String tmpDirIAMRole);

        /**
         * <p>
         * The set of options to configure an upsert operation when writing to a Redshift target.
         * </p>
         * 
         * @param upsertRedshiftOptions
         *        The set of options to configure an upsert operation when writing to a Redshift target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upsertRedshiftOptions(UpsertRedshiftTargetOptions upsertRedshiftOptions);

        /**
         * <p>
         * The set of options to configure an upsert operation when writing to a Redshift target.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpsertRedshiftTargetOptions.Builder}
         * avoiding the need to create one manually via {@link UpsertRedshiftTargetOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpsertRedshiftTargetOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #upsertRedshiftOptions(UpsertRedshiftTargetOptions)}.
         * 
         * @param upsertRedshiftOptions
         *        a consumer that will call methods on {@link UpsertRedshiftTargetOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upsertRedshiftOptions(UpsertRedshiftTargetOptions)
         */
        default Builder upsertRedshiftOptions(Consumer<UpsertRedshiftTargetOptions.Builder> upsertRedshiftOptions) {
            return upsertRedshiftOptions(UpsertRedshiftTargetOptions.builder().applyMutation(upsertRedshiftOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String database;

        private String table;

        private String redshiftTmpDir;

        private String tmpDirIAMRole;

        private UpsertRedshiftTargetOptions upsertRedshiftOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftTarget model) {
            name(model.name);
            inputs(model.inputs);
            database(model.database);
            table(model.table);
            redshiftTmpDir(model.redshiftTmpDir);
            tmpDirIAMRole(model.tmpDirIAMRole);
            upsertRedshiftOptions(model.upsertRedshiftOptions);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getRedshiftTmpDir() {
            return redshiftTmpDir;
        }

        public final void setRedshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
        }

        @Override
        public final Builder redshiftTmpDir(String redshiftTmpDir) {
            this.redshiftTmpDir = redshiftTmpDir;
            return this;
        }

        public final String getTmpDirIAMRole() {
            return tmpDirIAMRole;
        }

        public final void setTmpDirIAMRole(String tmpDirIAMRole) {
            this.tmpDirIAMRole = tmpDirIAMRole;
        }

        @Override
        public final Builder tmpDirIAMRole(String tmpDirIAMRole) {
            this.tmpDirIAMRole = tmpDirIAMRole;
            return this;
        }

        public final UpsertRedshiftTargetOptions.Builder getUpsertRedshiftOptions() {
            return upsertRedshiftOptions != null ? upsertRedshiftOptions.toBuilder() : null;
        }

        public final void setUpsertRedshiftOptions(UpsertRedshiftTargetOptions.BuilderImpl upsertRedshiftOptions) {
            this.upsertRedshiftOptions = upsertRedshiftOptions != null ? upsertRedshiftOptions.build() : null;
        }

        @Override
        public final Builder upsertRedshiftOptions(UpsertRedshiftTargetOptions upsertRedshiftOptions) {
            this.upsertRedshiftOptions = upsertRedshiftOptions;
            return this;
        }

        @Override
        public RedshiftTarget build() {
            return new RedshiftTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
