/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterSchemaVersionResponse extends GlueResponse implements
        ToCopyableBuilder<RegisterSchemaVersionResponse.Builder, RegisterSchemaVersionResponse> {
    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersionId").getter(getter(RegisterSchemaVersionResponse::schemaVersionId))
            .setter(setter(Builder::schemaVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(RegisterSchemaVersionResponse::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RegisterSchemaVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_ID_FIELD,
            VERSION_NUMBER_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SchemaVersionId", SCHEMA_VERSION_ID_FIELD);
                    put("VersionNumber", VERSION_NUMBER_FIELD);
                    put("Status", STATUS_FIELD);
                }
            });

    private final String schemaVersionId;

    private final Long versionNumber;

    private final String status;

    private RegisterSchemaVersionResponse(BuilderImpl builder) {
        super(builder);
        this.schemaVersionId = builder.schemaVersionId;
        this.versionNumber = builder.versionNumber;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique ID that represents the version of this schema.
     * </p>
     * 
     * @return The unique ID that represents the version of this schema.
     */
    public final String schemaVersionId() {
        return schemaVersionId;
    }

    /**
     * <p>
     * The version of this schema (for sync flow only, in case this is the first version).
     * </p>
     * 
     * @return The version of this schema (for sync flow only, in case this is the first version).
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The status of the schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchemaVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the schema version.
     * @see SchemaVersionStatus
     */
    public final SchemaVersionStatus status() {
        return SchemaVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchemaVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the schema version.
     * @see SchemaVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterSchemaVersionResponse)) {
            return false;
        }
        RegisterSchemaVersionResponse other = (RegisterSchemaVersionResponse) obj;
        return Objects.equals(schemaVersionId(), other.schemaVersionId())
                && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterSchemaVersionResponse").add("SchemaVersionId", schemaVersionId())
                .add("VersionNumber", versionNumber()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaVersionId":
            return Optional.ofNullable(clazz.cast(schemaVersionId()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegisterSchemaVersionResponse, T> g) {
        return obj -> g.apply((RegisterSchemaVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterSchemaVersionResponse> {
        /**
         * <p>
         * The unique ID that represents the version of this schema.
         * </p>
         * 
         * @param schemaVersionId
         *        The unique ID that represents the version of this schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionId(String schemaVersionId);

        /**
         * <p>
         * The version of this schema (for sync flow only, in case this is the first version).
         * </p>
         * 
         * @param versionNumber
         *        The version of this schema (for sync flow only, in case this is the first version).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The status of the schema version.
         * </p>
         * 
         * @param status
         *        The status of the schema version.
         * @see SchemaVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the schema version.
         * </p>
         * 
         * @param status
         *        The status of the schema version.
         * @see SchemaVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionStatus
         */
        Builder status(SchemaVersionStatus status);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String schemaVersionId;

        private Long versionNumber;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterSchemaVersionResponse model) {
            super(model);
            schemaVersionId(model.schemaVersionId);
            versionNumber(model.versionNumber);
            status(model.status);
        }

        public final String getSchemaVersionId() {
            return schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchemaVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RegisterSchemaVersionResponse build() {
            return new RegisterSchemaVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
