/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The statistic model result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatisticModelResult implements SdkPojo, Serializable,
        ToCopyableBuilder<StatisticModelResult.Builder, StatisticModelResult> {
    private static final SdkField<Double> LOWER_BOUND_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LowerBound").getter(getter(StatisticModelResult::lowerBound)).setter(setter(Builder::lowerBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerBound").build()).build();

    private static final SdkField<Double> UPPER_BOUND_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UpperBound").getter(getter(StatisticModelResult::upperBound)).setter(setter(Builder::upperBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperBound").build()).build();

    private static final SdkField<Double> PREDICTED_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("PredictedValue").getter(getter(StatisticModelResult::predictedValue))
            .setter(setter(Builder::predictedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictedValue").build()).build();

    private static final SdkField<Double> ACTUAL_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ActualValue").getter(getter(StatisticModelResult::actualValue)).setter(setter(Builder::actualValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualValue").build()).build();

    private static final SdkField<Instant> DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Date")
            .getter(getter(StatisticModelResult::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()).build();

    private static final SdkField<String> INCLUSION_ANNOTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InclusionAnnotation").getter(getter(StatisticModelResult::inclusionAnnotationAsString))
            .setter(setter(Builder::inclusionAnnotation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOWER_BOUND_FIELD,
            UPPER_BOUND_FIELD, PREDICTED_VALUE_FIELD, ACTUAL_VALUE_FIELD, DATE_FIELD, INCLUSION_ANNOTATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LowerBound", LOWER_BOUND_FIELD);
                    put("UpperBound", UPPER_BOUND_FIELD);
                    put("PredictedValue", PREDICTED_VALUE_FIELD);
                    put("ActualValue", ACTUAL_VALUE_FIELD);
                    put("Date", DATE_FIELD);
                    put("InclusionAnnotation", INCLUSION_ANNOTATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Double lowerBound;

    private final Double upperBound;

    private final Double predictedValue;

    private final Double actualValue;

    private final Instant date;

    private final String inclusionAnnotation;

    private StatisticModelResult(BuilderImpl builder) {
        this.lowerBound = builder.lowerBound;
        this.upperBound = builder.upperBound;
        this.predictedValue = builder.predictedValue;
        this.actualValue = builder.actualValue;
        this.date = builder.date;
        this.inclusionAnnotation = builder.inclusionAnnotation;
    }

    /**
     * <p>
     * The lower bound.
     * </p>
     * 
     * @return The lower bound.
     */
    public final Double lowerBound() {
        return lowerBound;
    }

    /**
     * <p>
     * The upper bound.
     * </p>
     * 
     * @return The upper bound.
     */
    public final Double upperBound() {
        return upperBound;
    }

    /**
     * <p>
     * The predicted value.
     * </p>
     * 
     * @return The predicted value.
     */
    public final Double predictedValue() {
        return predictedValue;
    }

    /**
     * <p>
     * The actual value.
     * </p>
     * 
     * @return The actual value.
     */
    public final Double actualValue() {
        return actualValue;
    }

    /**
     * <p>
     * The date.
     * </p>
     * 
     * @return The date.
     */
    public final Instant date() {
        return date;
    }

    /**
     * <p>
     * The inclusion annotation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inclusionAnnotation} will return {@link InclusionAnnotationValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inclusionAnnotationAsString}.
     * </p>
     * 
     * @return The inclusion annotation.
     * @see InclusionAnnotationValue
     */
    public final InclusionAnnotationValue inclusionAnnotation() {
        return InclusionAnnotationValue.fromValue(inclusionAnnotation);
    }

    /**
     * <p>
     * The inclusion annotation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inclusionAnnotation} will return {@link InclusionAnnotationValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inclusionAnnotationAsString}.
     * </p>
     * 
     * @return The inclusion annotation.
     * @see InclusionAnnotationValue
     */
    public final String inclusionAnnotationAsString() {
        return inclusionAnnotation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(upperBound());
        hashCode = 31 * hashCode + Objects.hashCode(predictedValue());
        hashCode = 31 * hashCode + Objects.hashCode(actualValue());
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(inclusionAnnotationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticModelResult)) {
            return false;
        }
        StatisticModelResult other = (StatisticModelResult) obj;
        return Objects.equals(lowerBound(), other.lowerBound()) && Objects.equals(upperBound(), other.upperBound())
                && Objects.equals(predictedValue(), other.predictedValue()) && Objects.equals(actualValue(), other.actualValue())
                && Objects.equals(date(), other.date())
                && Objects.equals(inclusionAnnotationAsString(), other.inclusionAnnotationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatisticModelResult").add("LowerBound", lowerBound()).add("UpperBound", upperBound())
                .add("PredictedValue", predictedValue()).add("ActualValue", actualValue()).add("Date", date())
                .add("InclusionAnnotation", inclusionAnnotationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LowerBound":
            return Optional.ofNullable(clazz.cast(lowerBound()));
        case "UpperBound":
            return Optional.ofNullable(clazz.cast(upperBound()));
        case "PredictedValue":
            return Optional.ofNullable(clazz.cast(predictedValue()));
        case "ActualValue":
            return Optional.ofNullable(clazz.cast(actualValue()));
        case "Date":
            return Optional.ofNullable(clazz.cast(date()));
        case "InclusionAnnotation":
            return Optional.ofNullable(clazz.cast(inclusionAnnotationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StatisticModelResult, T> g) {
        return obj -> g.apply((StatisticModelResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatisticModelResult> {
        /**
         * <p>
         * The lower bound.
         * </p>
         * 
         * @param lowerBound
         *        The lower bound.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowerBound(Double lowerBound);

        /**
         * <p>
         * The upper bound.
         * </p>
         * 
         * @param upperBound
         *        The upper bound.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperBound(Double upperBound);

        /**
         * <p>
         * The predicted value.
         * </p>
         * 
         * @param predictedValue
         *        The predicted value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictedValue(Double predictedValue);

        /**
         * <p>
         * The actual value.
         * </p>
         * 
         * @param actualValue
         *        The actual value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualValue(Double actualValue);

        /**
         * <p>
         * The date.
         * </p>
         * 
         * @param date
         *        The date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        /**
         * <p>
         * The inclusion annotation.
         * </p>
         * 
         * @param inclusionAnnotation
         *        The inclusion annotation.
         * @see InclusionAnnotationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InclusionAnnotationValue
         */
        Builder inclusionAnnotation(String inclusionAnnotation);

        /**
         * <p>
         * The inclusion annotation.
         * </p>
         * 
         * @param inclusionAnnotation
         *        The inclusion annotation.
         * @see InclusionAnnotationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InclusionAnnotationValue
         */
        Builder inclusionAnnotation(InclusionAnnotationValue inclusionAnnotation);
    }

    static final class BuilderImpl implements Builder {
        private Double lowerBound;

        private Double upperBound;

        private Double predictedValue;

        private Double actualValue;

        private Instant date;

        private String inclusionAnnotation;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticModelResult model) {
            lowerBound(model.lowerBound);
            upperBound(model.upperBound);
            predictedValue(model.predictedValue);
            actualValue(model.actualValue);
            date(model.date);
            inclusionAnnotation(model.inclusionAnnotation);
        }

        public final Double getLowerBound() {
            return lowerBound;
        }

        public final void setLowerBound(Double lowerBound) {
            this.lowerBound = lowerBound;
        }

        @Override
        public final Builder lowerBound(Double lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        public final Double getUpperBound() {
            return upperBound;
        }

        public final void setUpperBound(Double upperBound) {
            this.upperBound = upperBound;
        }

        @Override
        public final Builder upperBound(Double upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        public final Double getPredictedValue() {
            return predictedValue;
        }

        public final void setPredictedValue(Double predictedValue) {
            this.predictedValue = predictedValue;
        }

        @Override
        public final Builder predictedValue(Double predictedValue) {
            this.predictedValue = predictedValue;
            return this;
        }

        public final Double getActualValue() {
            return actualValue;
        }

        public final void setActualValue(Double actualValue) {
            this.actualValue = actualValue;
        }

        @Override
        public final Builder actualValue(Double actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public final Instant getDate() {
            return date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final String getInclusionAnnotation() {
            return inclusionAnnotation;
        }

        public final void setInclusionAnnotation(String inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
        }

        @Override
        public final Builder inclusionAnnotation(String inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
            return this;
        }

        @Override
        public final Builder inclusionAnnotation(InclusionAnnotationValue inclusionAnnotation) {
            this.inclusionAnnotation(inclusionAnnotation == null ? null : inclusionAnnotation.toString());
            return this;
        }

        @Override
        public StatisticModelResult build() {
            return new StatisticModelResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
