/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestConnectionRequest extends GlueRequest implements
        ToCopyableBuilder<TestConnectionRequest.Builder, TestConnectionRequest> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(TestConnectionRequest::connectionName))
            .setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<TestConnectionInput> TEST_CONNECTION_INPUT_FIELD = SdkField
            .<TestConnectionInput> builder(MarshallingType.SDK_POJO).memberName("TestConnectionInput")
            .getter(getter(TestConnectionRequest::testConnectionInput)).setter(setter(Builder::testConnectionInput))
            .constructor(TestConnectionInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestConnectionInput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD,
            TEST_CONNECTION_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ConnectionName", CONNECTION_NAME_FIELD);
                    put("TestConnectionInput", TEST_CONNECTION_INPUT_FIELD);
                }
            });

    private final String connectionName;

    private final TestConnectionInput testConnectionInput;

    private TestConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.connectionName = builder.connectionName;
        this.testConnectionInput = builder.testConnectionInput;
    }

    /**
     * <p>
     * Optional. The name of the connection to test. If only name is provided, the operation will get the connection and
     * use that for testing.
     * </p>
     * 
     * @return Optional. The name of the connection to test. If only name is provided, the operation will get the
     *         connection and use that for testing.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * A structure that is used to specify testing a connection to a service.
     * </p>
     * 
     * @return A structure that is used to specify testing a connection to a service.
     */
    public final TestConnectionInput testConnectionInput() {
        return testConnectionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(testConnectionInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConnectionRequest)) {
            return false;
        }
        TestConnectionRequest other = (TestConnectionRequest) obj;
        return Objects.equals(connectionName(), other.connectionName())
                && Objects.equals(testConnectionInput(), other.testConnectionInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestConnectionRequest").add("ConnectionName", connectionName())
                .add("TestConnectionInput", testConnectionInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "TestConnectionInput":
            return Optional.ofNullable(clazz.cast(testConnectionInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestConnectionRequest, T> g) {
        return obj -> g.apply((TestConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestConnectionRequest> {
        /**
         * <p>
         * Optional. The name of the connection to test. If only name is provided, the operation will get the connection
         * and use that for testing.
         * </p>
         * 
         * @param connectionName
         *        Optional. The name of the connection to test. If only name is provided, the operation will get the
         *        connection and use that for testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * A structure that is used to specify testing a connection to a service.
         * </p>
         * 
         * @param testConnectionInput
         *        A structure that is used to specify testing a connection to a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConnectionInput(TestConnectionInput testConnectionInput);

        /**
         * <p>
         * A structure that is used to specify testing a connection to a service.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestConnectionInput.Builder} avoiding the
         * need to create one manually via {@link TestConnectionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestConnectionInput.Builder#build()} is called immediately and
         * its result is passed to {@link #testConnectionInput(TestConnectionInput)}.
         * 
         * @param testConnectionInput
         *        a consumer that will call methods on {@link TestConnectionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testConnectionInput(TestConnectionInput)
         */
        default Builder testConnectionInput(Consumer<TestConnectionInput.Builder> testConnectionInput) {
            return testConnectionInput(TestConnectionInput.builder().applyMutation(testConnectionInput).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String connectionName;

        private TestConnectionInput testConnectionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(TestConnectionRequest model) {
            super(model);
            connectionName(model.connectionName);
            testConnectionInput(model.testConnectionInput);
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final TestConnectionInput.Builder getTestConnectionInput() {
            return testConnectionInput != null ? testConnectionInput.toBuilder() : null;
        }

        public final void setTestConnectionInput(TestConnectionInput.BuilderImpl testConnectionInput) {
            this.testConnectionInput = testConnectionInput != null ? testConnectionInput.build() : null;
        }

        @Override
        public final Builder testConnectionInput(TestConnectionInput testConnectionInput) {
            this.testConnectionInput = testConnectionInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestConnectionRequest build() {
            return new TestConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
