/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.StatisticSummary;
import software.amazon.awssdk.services.glue.model.StatisticSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataQualityStatisticsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListDataQualityStatisticsResponse> {
    private static final SdkField<List<StatisticSummary>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statistics").getter(ListDataQualityStatisticsResponse.getter(ListDataQualityStatisticsResponse::statistics)).setter(ListDataQualityStatisticsResponse.setter(Builder::statistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatisticSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataQualityStatisticsResponse.getter(ListDataQualityStatisticsResponse::nextToken)).setter(ListDataQualityStatisticsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTICS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Statistics", STATISTICS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<StatisticSummary> statistics;
    private final String nextToken;

    private ListDataQualityStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.statistics = builder.statistics;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public final List<StatisticSummary> statistics() {
        return this.statistics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatistics() ? this.statistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataQualityStatisticsResponse)) {
            return false;
        }
        ListDataQualityStatisticsResponse other = (ListDataQualityStatisticsResponse)((Object)obj);
        return this.hasStatistics() == other.hasStatistics() && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataQualityStatisticsResponse").add("Statistics", this.hasStatistics() ? this.statistics() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDataQualityStatisticsResponse, T> g) {
        return obj -> g.apply((ListDataQualityStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<StatisticSummary> statistics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataQualityStatisticsResponse model) {
            super(model);
            this.statistics(model.statistics);
            this.nextToken(model.nextToken);
        }

        public final List<StatisticSummary.Builder> getStatistics() {
            List<StatisticSummary.Builder> result = StatisticSummaryListCopier.copyToBuilder(this.statistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatistics(Collection<StatisticSummary.BuilderImpl> statistics) {
            this.statistics = StatisticSummaryListCopier.copyFromBuilder(statistics);
        }

        @Override
        public final Builder statistics(Collection<StatisticSummary> statistics) {
            this.statistics = StatisticSummaryListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(StatisticSummary ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Consumer<StatisticSummary.Builder> ... statistics) {
            this.statistics(Stream.of(statistics).map(c -> (StatisticSummary)((StatisticSummary.Builder)StatisticSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataQualityStatisticsResponse build() {
            return new ListDataQualityStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataQualityStatisticsResponse> {
        public Builder statistics(Collection<StatisticSummary> var1);

        public Builder statistics(StatisticSummary ... var1);

        public Builder statistics(Consumer<StatisticSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

