/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the authentication configuration in the CreateConnection request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationConfigurationInput.Builder, AuthenticationConfigurationInput> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(AuthenticationConfigurationInput::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<OAuth2PropertiesInput> O_AUTH2_PROPERTIES_FIELD = SdkField
            .<OAuth2PropertiesInput> builder(MarshallingType.SDK_POJO).memberName("OAuth2Properties")
            .getter(getter(AuthenticationConfigurationInput::oAuth2Properties)).setter(setter(Builder::oAuth2Properties))
            .constructor(OAuth2PropertiesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2Properties").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(AuthenticationConfigurationInput::secretArn))
            .setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(AuthenticationConfigurationInput::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<BasicAuthenticationCredentials> BASIC_AUTHENTICATION_CREDENTIALS_FIELD = SdkField
            .<BasicAuthenticationCredentials> builder(MarshallingType.SDK_POJO)
            .memberName("BasicAuthenticationCredentials")
            .getter(getter(AuthenticationConfigurationInput::basicAuthenticationCredentials))
            .setter(setter(Builder::basicAuthenticationCredentials))
            .constructor(BasicAuthenticationCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthenticationCredentials")
                    .build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_AUTHENTICATION_CREDENTIALS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomAuthenticationCredentials")
            .getter(getter(AuthenticationConfigurationInput::customAuthenticationCredentials))
            .setter(setter(Builder::customAuthenticationCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAuthenticationCredentials")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            O_AUTH2_PROPERTIES_FIELD, SECRET_ARN_FIELD, KMS_KEY_ARN_FIELD, BASIC_AUTHENTICATION_CREDENTIALS_FIELD,
            CUSTOM_AUTHENTICATION_CREDENTIALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
                    put("OAuth2Properties", O_AUTH2_PROPERTIES_FIELD);
                    put("SecretArn", SECRET_ARN_FIELD);
                    put("KmsKeyArn", KMS_KEY_ARN_FIELD);
                    put("BasicAuthenticationCredentials", BASIC_AUTHENTICATION_CREDENTIALS_FIELD);
                    put("CustomAuthenticationCredentials", CUSTOM_AUTHENTICATION_CREDENTIALS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String authenticationType;

    private final OAuth2PropertiesInput oAuth2Properties;

    private final String secretArn;

    private final String kmsKeyArn;

    private final BasicAuthenticationCredentials basicAuthenticationCredentials;

    private final Map<String, String> customAuthenticationCredentials;

    private AuthenticationConfigurationInput(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.oAuth2Properties = builder.oAuth2Properties;
        this.secretArn = builder.secretArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.basicAuthenticationCredentials = builder.basicAuthenticationCredentials;
        this.customAuthenticationCredentials = builder.customAuthenticationCredentials;
    }

    /**
     * <p>
     * A structure containing the authentication configuration in the CreateConnection request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return A structure containing the authentication configuration in the CreateConnection request.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * A structure containing the authentication configuration in the CreateConnection request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return A structure containing the authentication configuration in the CreateConnection request.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The properties for OAuth2 authentication in the CreateConnection request.
     * </p>
     * 
     * @return The properties for OAuth2 authentication in the CreateConnection request.
     */
    public final OAuth2PropertiesInput oAuth2Properties() {
        return oAuth2Properties;
    }

    /**
     * <p>
     * The secret manager ARN to store credentials in the CreateConnection request.
     * </p>
     * 
     * @return The secret manager ARN to store credentials in the CreateConnection request.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The ARN of the KMS key used to encrypt the connection. Only taken an as input in the request and stored in the
     * Secret Manager.
     * </p>
     * 
     * @return The ARN of the KMS key used to encrypt the connection. Only taken an as input in the request and stored
     *         in the Secret Manager.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The credentials used when the authentication type is basic authentication.
     * </p>
     * 
     * @return The credentials used when the authentication type is basic authentication.
     */
    public final BasicAuthenticationCredentials basicAuthenticationCredentials() {
        return basicAuthenticationCredentials;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAuthenticationCredentials
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCustomAuthenticationCredentials() {
        return customAuthenticationCredentials != null && !(customAuthenticationCredentials instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The credentials used when the authentication type is custom authentication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAuthenticationCredentials}
     * method.
     * </p>
     * 
     * @return The credentials used when the authentication type is custom authentication.
     */
    public final Map<String, String> customAuthenticationCredentials() {
        return customAuthenticationCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2Properties());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthenticationCredentials());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCustomAuthenticationCredentials() ? customAuthenticationCredentials() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfigurationInput)) {
            return false;
        }
        AuthenticationConfigurationInput other = (AuthenticationConfigurationInput) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(oAuth2Properties(), other.oAuth2Properties()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(basicAuthenticationCredentials(), other.basicAuthenticationCredentials())
                && hasCustomAuthenticationCredentials() == other.hasCustomAuthenticationCredentials()
                && Objects.equals(customAuthenticationCredentials(), other.customAuthenticationCredentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AuthenticationConfigurationInput")
                .add("AuthenticationType", authenticationTypeAsString())
                .add("OAuth2Properties", oAuth2Properties())
                .add("SecretArn", secretArn())
                .add("KmsKeyArn", kmsKeyArn())
                .add("BasicAuthenticationCredentials", basicAuthenticationCredentials())
                .add("CustomAuthenticationCredentials",
                        customAuthenticationCredentials() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "OAuth2Properties":
            return Optional.ofNullable(clazz.cast(oAuth2Properties()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "BasicAuthenticationCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthenticationCredentials()));
        case "CustomAuthenticationCredentials":
            return Optional.ofNullable(clazz.cast(customAuthenticationCredentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfigurationInput, T> g) {
        return obj -> g.apply((AuthenticationConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationConfigurationInput> {
        /**
         * <p>
         * A structure containing the authentication configuration in the CreateConnection request.
         * </p>
         * 
         * @param authenticationType
         *        A structure containing the authentication configuration in the CreateConnection request.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * A structure containing the authentication configuration in the CreateConnection request.
         * </p>
         * 
         * @param authenticationType
         *        A structure containing the authentication configuration in the CreateConnection request.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The properties for OAuth2 authentication in the CreateConnection request.
         * </p>
         * 
         * @param oAuth2Properties
         *        The properties for OAuth2 authentication in the CreateConnection request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth2Properties(OAuth2PropertiesInput oAuth2Properties);

        /**
         * <p>
         * The properties for OAuth2 authentication in the CreateConnection request.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuth2PropertiesInput.Builder} avoiding
         * the need to create one manually via {@link OAuth2PropertiesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuth2PropertiesInput.Builder#build()} is called immediately and
         * its result is passed to {@link #oAuth2Properties(OAuth2PropertiesInput)}.
         * 
         * @param oAuth2Properties
         *        a consumer that will call methods on {@link OAuth2PropertiesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuth2Properties(OAuth2PropertiesInput)
         */
        default Builder oAuth2Properties(Consumer<OAuth2PropertiesInput.Builder> oAuth2Properties) {
            return oAuth2Properties(OAuth2PropertiesInput.builder().applyMutation(oAuth2Properties).build());
        }

        /**
         * <p>
         * The secret manager ARN to store credentials in the CreateConnection request.
         * </p>
         * 
         * @param secretArn
         *        The secret manager ARN to store credentials in the CreateConnection request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The ARN of the KMS key used to encrypt the connection. Only taken an as input in the request and stored in
         * the Secret Manager.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key used to encrypt the connection. Only taken an as input in the request and
         *        stored in the Secret Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The credentials used when the authentication type is basic authentication.
         * </p>
         * 
         * @param basicAuthenticationCredentials
         *        The credentials used when the authentication type is basic authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthenticationCredentials(BasicAuthenticationCredentials basicAuthenticationCredentials);

        /**
         * <p>
         * The credentials used when the authentication type is basic authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link BasicAuthenticationCredentials.Builder}
         * avoiding the need to create one manually via {@link BasicAuthenticationCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BasicAuthenticationCredentials.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #basicAuthenticationCredentials(BasicAuthenticationCredentials)}.
         * 
         * @param basicAuthenticationCredentials
         *        a consumer that will call methods on {@link BasicAuthenticationCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #basicAuthenticationCredentials(BasicAuthenticationCredentials)
         */
        default Builder basicAuthenticationCredentials(
                Consumer<BasicAuthenticationCredentials.Builder> basicAuthenticationCredentials) {
            return basicAuthenticationCredentials(BasicAuthenticationCredentials.builder()
                    .applyMutation(basicAuthenticationCredentials).build());
        }

        /**
         * <p>
         * The credentials used when the authentication type is custom authentication.
         * </p>
         * 
         * @param customAuthenticationCredentials
         *        The credentials used when the authentication type is custom authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAuthenticationCredentials(Map<String, String> customAuthenticationCredentials);
    }

    static final class BuilderImpl implements Builder {
        private String authenticationType;

        private OAuth2PropertiesInput oAuth2Properties;

        private String secretArn;

        private String kmsKeyArn;

        private BasicAuthenticationCredentials basicAuthenticationCredentials;

        private Map<String, String> customAuthenticationCredentials = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfigurationInput model) {
            authenticationType(model.authenticationType);
            oAuth2Properties(model.oAuth2Properties);
            secretArn(model.secretArn);
            kmsKeyArn(model.kmsKeyArn);
            basicAuthenticationCredentials(model.basicAuthenticationCredentials);
            customAuthenticationCredentials(model.customAuthenticationCredentials);
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final OAuth2PropertiesInput.Builder getOAuth2Properties() {
            return oAuth2Properties != null ? oAuth2Properties.toBuilder() : null;
        }

        public final void setOAuth2Properties(OAuth2PropertiesInput.BuilderImpl oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties != null ? oAuth2Properties.build() : null;
        }

        @Override
        public final Builder oAuth2Properties(OAuth2PropertiesInput oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final BasicAuthenticationCredentials.Builder getBasicAuthenticationCredentials() {
            return basicAuthenticationCredentials != null ? basicAuthenticationCredentials.toBuilder() : null;
        }

        public final void setBasicAuthenticationCredentials(
                BasicAuthenticationCredentials.BuilderImpl basicAuthenticationCredentials) {
            this.basicAuthenticationCredentials = basicAuthenticationCredentials != null ? basicAuthenticationCredentials.build()
                    : null;
        }

        @Override
        public final Builder basicAuthenticationCredentials(BasicAuthenticationCredentials basicAuthenticationCredentials) {
            this.basicAuthenticationCredentials = basicAuthenticationCredentials;
            return this;
        }

        public final Map<String, String> getCustomAuthenticationCredentials() {
            if (customAuthenticationCredentials instanceof SdkAutoConstructMap) {
                return null;
            }
            return customAuthenticationCredentials;
        }

        public final void setCustomAuthenticationCredentials(Map<String, String> customAuthenticationCredentials) {
            this.customAuthenticationCredentials = CredentialMapCopier.copy(customAuthenticationCredentials);
        }

        @Override
        public final Builder customAuthenticationCredentials(Map<String, String> customAuthenticationCredentials) {
            this.customAuthenticationCredentials = CredentialMapCopier.copy(customAuthenticationCredentials);
            return this;
        }

        @Override
        public AuthenticationConfigurationInput build() {
            return new AuthenticationConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
