/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a <code>grok</code> classifier for <code>CreateClassifier</code> to create.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGrokClassifierRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateGrokClassifierRequest.Builder, CreateGrokClassifierRequest> {
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Classification").getter(getter(CreateGrokClassifierRequest::classification))
            .setter(setter(Builder::classification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateGrokClassifierRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> GROK_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrokPattern").getter(getter(CreateGrokClassifierRequest::grokPattern))
            .setter(setter(Builder::grokPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrokPattern").build()).build();

    private static final SdkField<String> CUSTOM_PATTERNS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomPatterns").getter(getter(CreateGrokClassifierRequest::customPatterns))
            .setter(setter(Builder::customPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPatterns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFICATION_FIELD,
            NAME_FIELD, GROK_PATTERN_FIELD, CUSTOM_PATTERNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Classification", CLASSIFICATION_FIELD);
                    put("Name", NAME_FIELD);
                    put("GrokPattern", GROK_PATTERN_FIELD);
                    put("CustomPatterns", CUSTOM_PATTERNS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String classification;

    private final String name;

    private final String grokPattern;

    private final String customPatterns;

    private CreateGrokClassifierRequest(BuilderImpl builder) {
        this.classification = builder.classification;
        this.name = builder.name;
        this.grokPattern = builder.grokPattern;
        this.customPatterns = builder.customPatterns;
    }

    /**
     * <p>
     * An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, Amazon
     * CloudWatch Logs, and so on.
     * </p>
     * 
     * @return An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs,
     *         Amazon CloudWatch Logs, and so on.
     */
    public final String classification() {
        return classification;
    }

    /**
     * <p>
     * The name of the new classifier.
     * </p>
     * 
     * @return The name of the new classifier.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The grok pattern used by this classifier.
     * </p>
     * 
     * @return The grok pattern used by this classifier.
     */
    public final String grokPattern() {
        return grokPattern;
    }

    /**
     * <p>
     * Optional custom grok patterns used by this classifier.
     * </p>
     * 
     * @return Optional custom grok patterns used by this classifier.
     */
    public final String customPatterns() {
        return customPatterns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(classification());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(grokPattern());
        hashCode = 31 * hashCode + Objects.hashCode(customPatterns());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrokClassifierRequest)) {
            return false;
        }
        CreateGrokClassifierRequest other = (CreateGrokClassifierRequest) obj;
        return Objects.equals(classification(), other.classification()) && Objects.equals(name(), other.name())
                && Objects.equals(grokPattern(), other.grokPattern()) && Objects.equals(customPatterns(), other.customPatterns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGrokClassifierRequest").add("Classification", classification()).add("Name", name())
                .add("GrokPattern", grokPattern()).add("CustomPatterns", customPatterns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Classification":
            return Optional.ofNullable(clazz.cast(classification()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "GrokPattern":
            return Optional.ofNullable(clazz.cast(grokPattern()));
        case "CustomPatterns":
            return Optional.ofNullable(clazz.cast(customPatterns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGrokClassifierRequest, T> g) {
        return obj -> g.apply((CreateGrokClassifierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateGrokClassifierRequest> {
        /**
         * <p>
         * An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, Amazon
         * CloudWatch Logs, and so on.
         * </p>
         * 
         * @param classification
         *        An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs,
         *        Amazon CloudWatch Logs, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classification(String classification);

        /**
         * <p>
         * The name of the new classifier.
         * </p>
         * 
         * @param name
         *        The name of the new classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The grok pattern used by this classifier.
         * </p>
         * 
         * @param grokPattern
         *        The grok pattern used by this classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grokPattern(String grokPattern);

        /**
         * <p>
         * Optional custom grok patterns used by this classifier.
         * </p>
         * 
         * @param customPatterns
         *        Optional custom grok patterns used by this classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPatterns(String customPatterns);
    }

    static final class BuilderImpl implements Builder {
        private String classification;

        private String name;

        private String grokPattern;

        private String customPatterns;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrokClassifierRequest model) {
            classification(model.classification);
            name(model.name);
            grokPattern(model.grokPattern);
            customPatterns(model.customPatterns);
        }

        public final String getClassification() {
            return classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getGrokPattern() {
            return grokPattern;
        }

        public final void setGrokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
        }

        @Override
        public final Builder grokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
            return this;
        }

        public final String getCustomPatterns() {
            return customPatterns;
        }

        public final void setCustomPatterns(String customPatterns) {
            this.customPatterns = customPatterns;
        }

        @Override
        public final Builder customPatterns(String customPatterns) {
            this.customPatterns = customPatterns;
            return this;
        }

        @Override
        public CreateGrokClassifierRequest build() {
            return new CreateGrokClassifierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
