/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A run attempt for a column statistics task run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionAttempt implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionAttempt.Builder, ExecutionAttempt> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ExecutionAttempt::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> COLUMN_STATISTICS_TASK_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnStatisticsTaskRunId").getter(getter(ExecutionAttempt::columnStatisticsTaskRunId))
            .setter(setter(Builder::columnStatisticsTaskRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskRunId").build())
            .build();

    private static final SdkField<Instant> EXECUTION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExecutionTimestamp").getter(getter(ExecutionAttempt::executionTimestamp))
            .setter(setter(Builder::executionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimestamp").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(ExecutionAttempt::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            COLUMN_STATISTICS_TASK_RUN_ID_FIELD, EXECUTION_TIMESTAMP_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Status", STATUS_FIELD);
                    put("ColumnStatisticsTaskRunId", COLUMN_STATISTICS_TASK_RUN_ID_FIELD);
                    put("ExecutionTimestamp", EXECUTION_TIMESTAMP_FIELD);
                    put("ErrorMessage", ERROR_MESSAGE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String columnStatisticsTaskRunId;

    private final Instant executionTimestamp;

    private final String errorMessage;

    private ExecutionAttempt(BuilderImpl builder) {
        this.status = builder.status;
        this.columnStatisticsTaskRunId = builder.columnStatisticsTaskRunId;
        this.executionTimestamp = builder.executionTimestamp;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The status of the last column statistics task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the last column statistics task run.
     * @see ExecutionStatus
     */
    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the last column statistics task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the last column statistics task run.
     * @see ExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A task run ID for the last column statistics task run.
     * </p>
     * 
     * @return A task run ID for the last column statistics task run.
     */
    public final String columnStatisticsTaskRunId() {
        return columnStatisticsTaskRunId;
    }

    /**
     * <p>
     * A timestamp when the last column statistics task run occurred.
     * </p>
     * 
     * @return A timestamp when the last column statistics task run occurred.
     */
    public final Instant executionTimestamp() {
        return executionTimestamp;
    }

    /**
     * <p>
     * An error message associated with the last column statistics task run.
     * </p>
     * 
     * @return An error message associated with the last column statistics task run.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(columnStatisticsTaskRunId());
        hashCode = 31 * hashCode + Objects.hashCode(executionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionAttempt)) {
            return false;
        }
        ExecutionAttempt other = (ExecutionAttempt) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(columnStatisticsTaskRunId(), other.columnStatisticsTaskRunId())
                && Objects.equals(executionTimestamp(), other.executionTimestamp())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionAttempt").add("Status", statusAsString())
                .add("ColumnStatisticsTaskRunId", columnStatisticsTaskRunId()).add("ExecutionTimestamp", executionTimestamp())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ColumnStatisticsTaskRunId":
            return Optional.ofNullable(clazz.cast(columnStatisticsTaskRunId()));
        case "ExecutionTimestamp":
            return Optional.ofNullable(clazz.cast(executionTimestamp()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionAttempt, T> g) {
        return obj -> g.apply((ExecutionAttempt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionAttempt> {
        /**
         * <p>
         * The status of the last column statistics task run.
         * </p>
         * 
         * @param status
         *        The status of the last column statistics task run.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the last column statistics task run.
         * </p>
         * 
         * @param status
         *        The status of the last column statistics task run.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * A task run ID for the last column statistics task run.
         * </p>
         * 
         * @param columnStatisticsTaskRunId
         *        A task run ID for the last column statistics task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsTaskRunId(String columnStatisticsTaskRunId);

        /**
         * <p>
         * A timestamp when the last column statistics task run occurred.
         * </p>
         * 
         * @param executionTimestamp
         *        A timestamp when the last column statistics task run occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimestamp(Instant executionTimestamp);

        /**
         * <p>
         * An error message associated with the last column statistics task run.
         * </p>
         * 
         * @param errorMessage
         *        An error message associated with the last column statistics task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String columnStatisticsTaskRunId;

        private Instant executionTimestamp;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionAttempt model) {
            status(model.status);
            columnStatisticsTaskRunId(model.columnStatisticsTaskRunId);
            executionTimestamp(model.executionTimestamp);
            errorMessage(model.errorMessage);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getColumnStatisticsTaskRunId() {
            return columnStatisticsTaskRunId;
        }

        public final void setColumnStatisticsTaskRunId(String columnStatisticsTaskRunId) {
            this.columnStatisticsTaskRunId = columnStatisticsTaskRunId;
        }

        @Override
        public final Builder columnStatisticsTaskRunId(String columnStatisticsTaskRunId) {
            this.columnStatisticsTaskRunId = columnStatisticsTaskRunId;
            return this;
        }

        public final Instant getExecutionTimestamp() {
            return executionTimestamp;
        }

        public final void setExecutionTimestamp(Instant executionTimestamp) {
            this.executionTimestamp = executionTimestamp;
        }

        @Override
        public final Builder executionTimestamp(Instant executionTimestamp) {
            this.executionTimestamp = executionTimestamp;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public ExecutionAttempt build() {
            return new ExecutionAttempt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
