/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEntityRecordsRequest extends GlueRequest implements
        ToCopyableBuilder<GetEntityRecordsRequest.Builder, GetEntityRecordsRequest> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(GetEntityRecordsRequest::connectionName))
            .setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetEntityRecordsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityName").getter(getter(GetEntityRecordsRequest::entityName)).setter(setter(Builder::entityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetEntityRecordsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> DATA_STORE_API_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataStoreApiVersion").getter(getter(GetEntityRecordsRequest::dataStoreApiVersion))
            .setter(setter(Builder::dataStoreApiVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStoreApiVersion").build())
            .build();

    private static final SdkField<Map<String, String>> CONNECTION_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ConnectionOptions")
            .getter(getter(GetEntityRecordsRequest::connectionOptions))
            .setter(setter(Builder::connectionOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FILTER_PREDICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterPredicate").getter(getter(GetEntityRecordsRequest::filterPredicate))
            .setter(setter(Builder::filterPredicate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterPredicate").build()).build();

    private static final SdkField<Long> LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Limit")
            .getter(getter(GetEntityRecordsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> ORDER_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrderBy").getter(getter(GetEntityRecordsRequest::orderBy)).setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderBy").build()).build();

    private static final SdkField<List<String>> SELECTED_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedFields")
            .getter(getter(GetEntityRecordsRequest::selectedFields))
            .setter(setter(Builder::selectedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD,
            CATALOG_ID_FIELD, ENTITY_NAME_FIELD, NEXT_TOKEN_FIELD, DATA_STORE_API_VERSION_FIELD, CONNECTION_OPTIONS_FIELD,
            FILTER_PREDICATE_FIELD, LIMIT_FIELD, ORDER_BY_FIELD, SELECTED_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ConnectionName", CONNECTION_NAME_FIELD);
                    put("CatalogId", CATALOG_ID_FIELD);
                    put("EntityName", ENTITY_NAME_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("DataStoreApiVersion", DATA_STORE_API_VERSION_FIELD);
                    put("ConnectionOptions", CONNECTION_OPTIONS_FIELD);
                    put("FilterPredicate", FILTER_PREDICATE_FIELD);
                    put("Limit", LIMIT_FIELD);
                    put("OrderBy", ORDER_BY_FIELD);
                    put("SelectedFields", SELECTED_FIELDS_FIELD);
                }
            });

    private final String connectionName;

    private final String catalogId;

    private final String entityName;

    private final String nextToken;

    private final String dataStoreApiVersion;

    private final Map<String, String> connectionOptions;

    private final String filterPredicate;

    private final Long limit;

    private final String orderBy;

    private final List<String> selectedFields;

    private GetEntityRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.connectionName = builder.connectionName;
        this.catalogId = builder.catalogId;
        this.entityName = builder.entityName;
        this.nextToken = builder.nextToken;
        this.dataStoreApiVersion = builder.dataStoreApiVersion;
        this.connectionOptions = builder.connectionOptions;
        this.filterPredicate = builder.filterPredicate;
        this.limit = builder.limit;
        this.orderBy = builder.orderBy;
        this.selectedFields = builder.selectedFields;
    }

    /**
     * <p>
     * The name of the connection that contains the connection type credentials.
     * </p>
     * 
     * @return The name of the connection that contains the connection type credentials.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * The catalog ID of the catalog that contains the connection. This can be null, By default, the Amazon Web Services
     * Account ID is the catalog ID.
     * </p>
     * 
     * @return The catalog ID of the catalog that contains the connection. This can be null, By default, the Amazon Web
     *         Services Account ID is the catalog ID.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * Name of the entity that we want to query the preview data from the given connection type.
     * </p>
     * 
     * @return Name of the entity that we want to query the preview data from the given connection type.
     */
    public final String entityName() {
        return entityName;
    }

    /**
     * <p>
     * A continuation token, included if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, included if this is a continuation call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The API version of the SaaS connector.
     * </p>
     * 
     * @return The API version of the SaaS connector.
     */
    public final String dataStoreApiVersion() {
        return dataStoreApiVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionOptions() {
        return connectionOptions != null && !(connectionOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connector options that are required to query the data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionOptions} method.
     * </p>
     * 
     * @return Connector options that are required to query the data.
     */
    public final Map<String, String> connectionOptions() {
        return connectionOptions;
    }

    /**
     * <p>
     * A filter predicate that you can apply in the query request.
     * </p>
     * 
     * @return A filter predicate that you can apply in the query request.
     */
    public final String filterPredicate() {
        return filterPredicate;
    }

    /**
     * <p>
     * Limits the number of records fetched with the request.
     * </p>
     * 
     * @return Limits the number of records fetched with the request.
     */
    public final Long limit() {
        return limit;
    }

    /**
     * <p>
     * A parameter that orders the response preview data.
     * </p>
     * 
     * @return A parameter that orders the response preview data.
     */
    public final String orderBy() {
        return orderBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedFields() {
        return selectedFields != null && !(selectedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of fields that we want to fetch as part of preview data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedFields} method.
     * </p>
     * 
     * @return List of fields that we want to fetch as part of preview data.
     */
    public final List<String> selectedFields() {
        return selectedFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(entityName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(dataStoreApiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionOptions() ? connectionOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filterPredicate());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(orderBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedFields() ? selectedFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntityRecordsRequest)) {
            return false;
        }
        GetEntityRecordsRequest other = (GetEntityRecordsRequest) obj;
        return Objects.equals(connectionName(), other.connectionName()) && Objects.equals(catalogId(), other.catalogId())
                && Objects.equals(entityName(), other.entityName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(dataStoreApiVersion(), other.dataStoreApiVersion())
                && hasConnectionOptions() == other.hasConnectionOptions()
                && Objects.equals(connectionOptions(), other.connectionOptions())
                && Objects.equals(filterPredicate(), other.filterPredicate()) && Objects.equals(limit(), other.limit())
                && Objects.equals(orderBy(), other.orderBy()) && hasSelectedFields() == other.hasSelectedFields()
                && Objects.equals(selectedFields(), other.selectedFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEntityRecordsRequest").add("ConnectionName", connectionName()).add("CatalogId", catalogId())
                .add("EntityName", entityName()).add("NextToken", nextToken()).add("DataStoreApiVersion", dataStoreApiVersion())
                .add("ConnectionOptions", hasConnectionOptions() ? connectionOptions() : null)
                .add("FilterPredicate", filterPredicate()).add("Limit", limit()).add("OrderBy", orderBy())
                .add("SelectedFields", hasSelectedFields() ? selectedFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "EntityName":
            return Optional.ofNullable(clazz.cast(entityName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DataStoreApiVersion":
            return Optional.ofNullable(clazz.cast(dataStoreApiVersion()));
        case "ConnectionOptions":
            return Optional.ofNullable(clazz.cast(connectionOptions()));
        case "FilterPredicate":
            return Optional.ofNullable(clazz.cast(filterPredicate()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "OrderBy":
            return Optional.ofNullable(clazz.cast(orderBy()));
        case "SelectedFields":
            return Optional.ofNullable(clazz.cast(selectedFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEntityRecordsRequest, T> g) {
        return obj -> g.apply((GetEntityRecordsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetEntityRecordsRequest> {
        /**
         * <p>
         * The name of the connection that contains the connection type credentials.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection that contains the connection type credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The catalog ID of the catalog that contains the connection. This can be null, By default, the Amazon Web
         * Services Account ID is the catalog ID.
         * </p>
         * 
         * @param catalogId
         *        The catalog ID of the catalog that contains the connection. This can be null, By default, the Amazon
         *        Web Services Account ID is the catalog ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * Name of the entity that we want to query the preview data from the given connection type.
         * </p>
         * 
         * @param entityName
         *        Name of the entity that we want to query the preview data from the given connection type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityName(String entityName);

        /**
         * <p>
         * A continuation token, included if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, included if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The API version of the SaaS connector.
         * </p>
         * 
         * @param dataStoreApiVersion
         *        The API version of the SaaS connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStoreApiVersion(String dataStoreApiVersion);

        /**
         * <p>
         * Connector options that are required to query the data.
         * </p>
         * 
         * @param connectionOptions
         *        Connector options that are required to query the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionOptions(Map<String, String> connectionOptions);

        /**
         * <p>
         * A filter predicate that you can apply in the query request.
         * </p>
         * 
         * @param filterPredicate
         *        A filter predicate that you can apply in the query request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPredicate(String filterPredicate);

        /**
         * <p>
         * Limits the number of records fetched with the request.
         * </p>
         * 
         * @param limit
         *        Limits the number of records fetched with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Long limit);

        /**
         * <p>
         * A parameter that orders the response preview data.
         * </p>
         * 
         * @param orderBy
         *        A parameter that orders the response preview data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(String orderBy);

        /**
         * <p>
         * List of fields that we want to fetch as part of preview data.
         * </p>
         * 
         * @param selectedFields
         *        List of fields that we want to fetch as part of preview data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedFields(Collection<String> selectedFields);

        /**
         * <p>
         * List of fields that we want to fetch as part of preview data.
         * </p>
         * 
         * @param selectedFields
         *        List of fields that we want to fetch as part of preview data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedFields(String... selectedFields);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String connectionName;

        private String catalogId;

        private String entityName;

        private String nextToken;

        private String dataStoreApiVersion;

        private Map<String, String> connectionOptions = DefaultSdkAutoConstructMap.getInstance();

        private String filterPredicate;

        private Long limit;

        private String orderBy;

        private List<String> selectedFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntityRecordsRequest model) {
            super(model);
            connectionName(model.connectionName);
            catalogId(model.catalogId);
            entityName(model.entityName);
            nextToken(model.nextToken);
            dataStoreApiVersion(model.dataStoreApiVersion);
            connectionOptions(model.connectionOptions);
            filterPredicate(model.filterPredicate);
            limit(model.limit);
            orderBy(model.orderBy);
            selectedFields(model.selectedFields);
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getEntityName() {
            return entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDataStoreApiVersion() {
            return dataStoreApiVersion;
        }

        public final void setDataStoreApiVersion(String dataStoreApiVersion) {
            this.dataStoreApiVersion = dataStoreApiVersion;
        }

        @Override
        public final Builder dataStoreApiVersion(String dataStoreApiVersion) {
            this.dataStoreApiVersion = dataStoreApiVersion;
            return this;
        }

        public final Map<String, String> getConnectionOptions() {
            if (connectionOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return connectionOptions;
        }

        public final void setConnectionOptions(Map<String, String> connectionOptions) {
            this.connectionOptions = ConnectionOptionsCopier.copy(connectionOptions);
        }

        @Override
        public final Builder connectionOptions(Map<String, String> connectionOptions) {
            this.connectionOptions = ConnectionOptionsCopier.copy(connectionOptions);
            return this;
        }

        public final String getFilterPredicate() {
            return filterPredicate;
        }

        public final void setFilterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
        }

        @Override
        public final Builder filterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
            return this;
        }

        public final Long getLimit() {
            return limit;
        }

        public final void setLimit(Long limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public final String getOrderBy() {
            return orderBy;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Collection<String> getSelectedFields() {
            if (selectedFields instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedFields;
        }

        public final void setSelectedFields(Collection<String> selectedFields) {
            this.selectedFields = SelectedFieldsCopier.copy(selectedFields);
        }

        @Override
        public final Builder selectedFields(Collection<String> selectedFields) {
            this.selectedFields = SelectedFieldsCopier.copy(selectedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFields(String... selectedFields) {
            selectedFields(Arrays.asList(selectedFields));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEntityRecordsRequest build() {
            return new GetEntityRecordsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
