/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListColumnStatisticsTaskRunsResponse extends GlueResponse implements
        ToCopyableBuilder<ListColumnStatisticsTaskRunsResponse.Builder, ListColumnStatisticsTaskRunsResponse> {
    private static final SdkField<List<String>> COLUMN_STATISTICS_TASK_RUN_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ColumnStatisticsTaskRunIds")
            .getter(getter(ListColumnStatisticsTaskRunsResponse::columnStatisticsTaskRunIds))
            .setter(setter(Builder::columnStatisticsTaskRunIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskRunIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListColumnStatisticsTaskRunsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLUMN_STATISTICS_TASK_RUN_IDS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ColumnStatisticsTaskRunIds", COLUMN_STATISTICS_TASK_RUN_IDS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<String> columnStatisticsTaskRunIds;

    private final String nextToken;

    private ListColumnStatisticsTaskRunsResponse(BuilderImpl builder) {
        super(builder);
        this.columnStatisticsTaskRunIds = builder.columnStatisticsTaskRunIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnStatisticsTaskRunIds property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasColumnStatisticsTaskRunIds() {
        return columnStatisticsTaskRunIds != null && !(columnStatisticsTaskRunIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of column statistics task run IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnStatisticsTaskRunIds} method.
     * </p>
     * 
     * @return A list of column statistics task run IDs.
     */
    public final List<String> columnStatisticsTaskRunIds() {
        return columnStatisticsTaskRunIds;
    }

    /**
     * <p>
     * A continuation token, if not all task run IDs have yet been returned.
     * </p>
     * 
     * @return A continuation token, if not all task run IDs have yet been returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnStatisticsTaskRunIds() ? columnStatisticsTaskRunIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListColumnStatisticsTaskRunsResponse)) {
            return false;
        }
        ListColumnStatisticsTaskRunsResponse other = (ListColumnStatisticsTaskRunsResponse) obj;
        return hasColumnStatisticsTaskRunIds() == other.hasColumnStatisticsTaskRunIds()
                && Objects.equals(columnStatisticsTaskRunIds(), other.columnStatisticsTaskRunIds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListColumnStatisticsTaskRunsResponse")
                .add("ColumnStatisticsTaskRunIds", hasColumnStatisticsTaskRunIds() ? columnStatisticsTaskRunIds() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnStatisticsTaskRunIds":
            return Optional.ofNullable(clazz.cast(columnStatisticsTaskRunIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListColumnStatisticsTaskRunsResponse, T> g) {
        return obj -> g.apply((ListColumnStatisticsTaskRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListColumnStatisticsTaskRunsResponse> {
        /**
         * <p>
         * A list of column statistics task run IDs.
         * </p>
         * 
         * @param columnStatisticsTaskRunIds
         *        A list of column statistics task run IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsTaskRunIds(Collection<String> columnStatisticsTaskRunIds);

        /**
         * <p>
         * A list of column statistics task run IDs.
         * </p>
         * 
         * @param columnStatisticsTaskRunIds
         *        A list of column statistics task run IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsTaskRunIds(String... columnStatisticsTaskRunIds);

        /**
         * <p>
         * A continuation token, if not all task run IDs have yet been returned.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if not all task run IDs have yet been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<String> columnStatisticsTaskRunIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListColumnStatisticsTaskRunsResponse model) {
            super(model);
            columnStatisticsTaskRunIds(model.columnStatisticsTaskRunIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getColumnStatisticsTaskRunIds() {
            if (columnStatisticsTaskRunIds instanceof SdkAutoConstructList) {
                return null;
            }
            return columnStatisticsTaskRunIds;
        }

        public final void setColumnStatisticsTaskRunIds(Collection<String> columnStatisticsTaskRunIds) {
            this.columnStatisticsTaskRunIds = ColumnStatisticsTaskRunIdListCopier.copy(columnStatisticsTaskRunIds);
        }

        @Override
        public final Builder columnStatisticsTaskRunIds(Collection<String> columnStatisticsTaskRunIds) {
            this.columnStatisticsTaskRunIds = ColumnStatisticsTaskRunIdListCopier.copy(columnStatisticsTaskRunIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsTaskRunIds(String... columnStatisticsTaskRunIds) {
            columnStatisticsTaskRunIds(Arrays.asList(columnStatisticsTaskRunIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListColumnStatisticsTaskRunsResponse build() {
            return new ListColumnStatisticsTaskRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
