/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the job and session values that an admin configures in an Glue usage profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfileConfiguration.Builder, ProfileConfiguration> {
    private static final SdkField<Map<String, ConfigurationObject>> SESSION_CONFIGURATION_FIELD = SdkField
            .<Map<String, ConfigurationObject>> builder(MarshallingType.MAP)
            .memberName("SessionConfiguration")
            .getter(getter(ProfileConfiguration::sessionConfiguration))
            .setter(setter(Builder::sessionConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ConfigurationObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ConfigurationObject>> JOB_CONFIGURATION_FIELD = SdkField
            .<Map<String, ConfigurationObject>> builder(MarshallingType.MAP)
            .memberName("JobConfiguration")
            .getter(getter(ProfileConfiguration::jobConfiguration))
            .setter(setter(Builder::jobConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ConfigurationObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_CONFIGURATION_FIELD,
            JOB_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SessionConfiguration", SESSION_CONFIGURATION_FIELD);
                    put("JobConfiguration", JOB_CONFIGURATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Map<String, ConfigurationObject> sessionConfiguration;

    private final Map<String, ConfigurationObject> jobConfiguration;

    private ProfileConfiguration(BuilderImpl builder) {
        this.sessionConfiguration = builder.sessionConfiguration;
        this.jobConfiguration = builder.jobConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionConfiguration() {
        return sessionConfiguration != null && !(sessionConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map of configuration parameters for Glue sessions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionConfiguration} method.
     * </p>
     * 
     * @return A key-value map of configuration parameters for Glue sessions.
     */
    public final Map<String, ConfigurationObject> sessionConfiguration() {
        return sessionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobConfiguration property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJobConfiguration() {
        return jobConfiguration != null && !(jobConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map of configuration parameters for Glue jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobConfiguration} method.
     * </p>
     * 
     * @return A key-value map of configuration parameters for Glue jobs.
     */
    public final Map<String, ConfigurationObject> jobConfiguration() {
        return jobConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionConfiguration() ? sessionConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasJobConfiguration() ? jobConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileConfiguration)) {
            return false;
        }
        ProfileConfiguration other = (ProfileConfiguration) obj;
        return hasSessionConfiguration() == other.hasSessionConfiguration()
                && Objects.equals(sessionConfiguration(), other.sessionConfiguration())
                && hasJobConfiguration() == other.hasJobConfiguration()
                && Objects.equals(jobConfiguration(), other.jobConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileConfiguration")
                .add("SessionConfiguration", hasSessionConfiguration() ? sessionConfiguration() : null)
                .add("JobConfiguration", hasJobConfiguration() ? jobConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionConfiguration":
            return Optional.ofNullable(clazz.cast(sessionConfiguration()));
        case "JobConfiguration":
            return Optional.ofNullable(clazz.cast(jobConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProfileConfiguration, T> g) {
        return obj -> g.apply((ProfileConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileConfiguration> {
        /**
         * <p>
         * A key-value map of configuration parameters for Glue sessions.
         * </p>
         * 
         * @param sessionConfiguration
         *        A key-value map of configuration parameters for Glue sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionConfiguration(Map<String, ConfigurationObject> sessionConfiguration);

        /**
         * <p>
         * A key-value map of configuration parameters for Glue jobs.
         * </p>
         * 
         * @param jobConfiguration
         *        A key-value map of configuration parameters for Glue jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobConfiguration(Map<String, ConfigurationObject> jobConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, ConfigurationObject> sessionConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ConfigurationObject> jobConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileConfiguration model) {
            sessionConfiguration(model.sessionConfiguration);
            jobConfiguration(model.jobConfiguration);
        }

        public final Map<String, ConfigurationObject.Builder> getSessionConfiguration() {
            Map<String, ConfigurationObject.Builder> result = ConfigurationMapCopier.copyToBuilder(this.sessionConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSessionConfiguration(Map<String, ConfigurationObject.BuilderImpl> sessionConfiguration) {
            this.sessionConfiguration = ConfigurationMapCopier.copyFromBuilder(sessionConfiguration);
        }

        @Override
        public final Builder sessionConfiguration(Map<String, ConfigurationObject> sessionConfiguration) {
            this.sessionConfiguration = ConfigurationMapCopier.copy(sessionConfiguration);
            return this;
        }

        public final Map<String, ConfigurationObject.Builder> getJobConfiguration() {
            Map<String, ConfigurationObject.Builder> result = ConfigurationMapCopier.copyToBuilder(this.jobConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setJobConfiguration(Map<String, ConfigurationObject.BuilderImpl> jobConfiguration) {
            this.jobConfiguration = ConfigurationMapCopier.copyFromBuilder(jobConfiguration);
        }

        @Override
        public final Builder jobConfiguration(Map<String, ConfigurationObject> jobConfiguration) {
            this.jobConfiguration = ConfigurationMapCopier.copy(jobConfiguration);
            return this;
        }

        @Override
        public ProfileConfiguration build() {
            return new ProfileConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
