/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for a source control configuration for a job, allowing synchronization of job artifacts to or from a
 * remote repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceControlDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceControlDetails.Builder, SourceControlDetails> {
    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Provider").getter(getter(SourceControlDetails::providerAsString)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Repository").getter(getter(SourceControlDetails::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Repository").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(SourceControlDetails::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Branch")
            .getter(getter(SourceControlDetails::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()).build();

    private static final SdkField<String> FOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Folder")
            .getter(getter(SourceControlDetails::folder)).setter(setter(Builder::folder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folder").build()).build();

    private static final SdkField<String> LAST_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastCommitId").getter(getter(SourceControlDetails::lastCommitId)).setter(setter(Builder::lastCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCommitId").build()).build();

    private static final SdkField<String> AUTH_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthStrategy").getter(getter(SourceControlDetails::authStrategyAsString))
            .setter(setter(Builder::authStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthStrategy").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthToken").getter(getter(SourceControlDetails::authToken)).setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_FIELD,
            REPOSITORY_FIELD, OWNER_FIELD, BRANCH_FIELD, FOLDER_FIELD, LAST_COMMIT_ID_FIELD, AUTH_STRATEGY_FIELD,
            AUTH_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Provider", PROVIDER_FIELD);
                    put("Repository", REPOSITORY_FIELD);
                    put("Owner", OWNER_FIELD);
                    put("Branch", BRANCH_FIELD);
                    put("Folder", FOLDER_FIELD);
                    put("LastCommitId", LAST_COMMIT_ID_FIELD);
                    put("AuthStrategy", AUTH_STRATEGY_FIELD);
                    put("AuthToken", AUTH_TOKEN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String provider;

    private final String repository;

    private final String owner;

    private final String branch;

    private final String folder;

    private final String lastCommitId;

    private final String authStrategy;

    private final String authToken;

    private SourceControlDetails(BuilderImpl builder) {
        this.provider = builder.provider;
        this.repository = builder.repository;
        this.owner = builder.owner;
        this.branch = builder.branch;
        this.folder = builder.folder;
        this.lastCommitId = builder.lastCommitId;
        this.authStrategy = builder.authStrategy;
        this.authToken = builder.authToken;
    }

    /**
     * <p>
     * The provider for the remote repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link SourceControlProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerAsString}.
     * </p>
     * 
     * @return The provider for the remote repository.
     * @see SourceControlProvider
     */
    public final SourceControlProvider provider() {
        return SourceControlProvider.fromValue(provider);
    }

    /**
     * <p>
     * The provider for the remote repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link SourceControlProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerAsString}.
     * </p>
     * 
     * @return The provider for the remote repository.
     * @see SourceControlProvider
     */
    public final String providerAsString() {
        return provider;
    }

    /**
     * <p>
     * The name of the remote repository that contains the job artifacts.
     * </p>
     * 
     * @return The name of the remote repository that contains the job artifacts.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * The owner of the remote repository that contains the job artifacts.
     * </p>
     * 
     * @return The owner of the remote repository that contains the job artifacts.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * An optional branch in the remote repository.
     * </p>
     * 
     * @return An optional branch in the remote repository.
     */
    public final String branch() {
        return branch;
    }

    /**
     * <p>
     * An optional folder in the remote repository.
     * </p>
     * 
     * @return An optional folder in the remote repository.
     */
    public final String folder() {
        return folder;
    }

    /**
     * <p>
     * The last commit ID for a commit in the remote repository.
     * </p>
     * 
     * @return The last commit ID for a commit in the remote repository.
     */
    public final String lastCommitId() {
        return lastCommitId;
    }

    /**
     * <p>
     * The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets Manager,
     * or a personal access token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authStrategy} will
     * return {@link SourceControlAuthStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authStrategyAsString}.
     * </p>
     * 
     * @return The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
     *         Manager, or a personal access token.
     * @see SourceControlAuthStrategy
     */
    public final SourceControlAuthStrategy authStrategy() {
        return SourceControlAuthStrategy.fromValue(authStrategy);
    }

    /**
     * <p>
     * The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets Manager,
     * or a personal access token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authStrategy} will
     * return {@link SourceControlAuthStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authStrategyAsString}.
     * </p>
     * 
     * @return The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
     *         Manager, or a personal access token.
     * @see SourceControlAuthStrategy
     */
    public final String authStrategyAsString() {
        return authStrategy;
    }

    /**
     * <p>
     * The value of an authorization token.
     * </p>
     * 
     * @return The value of an authorization token.
     */
    public final String authToken() {
        return authToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(folder());
        hashCode = 31 * hashCode + Objects.hashCode(lastCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(authStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceControlDetails)) {
            return false;
        }
        SourceControlDetails other = (SourceControlDetails) obj;
        return Objects.equals(providerAsString(), other.providerAsString()) && Objects.equals(repository(), other.repository())
                && Objects.equals(owner(), other.owner()) && Objects.equals(branch(), other.branch())
                && Objects.equals(folder(), other.folder()) && Objects.equals(lastCommitId(), other.lastCommitId())
                && Objects.equals(authStrategyAsString(), other.authStrategyAsString())
                && Objects.equals(authToken(), other.authToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceControlDetails").add("Provider", providerAsString()).add("Repository", repository())
                .add("Owner", owner()).add("Branch", branch()).add("Folder", folder()).add("LastCommitId", lastCommitId())
                .add("AuthStrategy", authStrategyAsString()).add("AuthToken", authToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        case "Repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "Folder":
            return Optional.ofNullable(clazz.cast(folder()));
        case "LastCommitId":
            return Optional.ofNullable(clazz.cast(lastCommitId()));
        case "AuthStrategy":
            return Optional.ofNullable(clazz.cast(authStrategyAsString()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SourceControlDetails, T> g) {
        return obj -> g.apply((SourceControlDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceControlDetails> {
        /**
         * <p>
         * The provider for the remote repository.
         * </p>
         * 
         * @param provider
         *        The provider for the remote repository.
         * @see SourceControlProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceControlProvider
         */
        Builder provider(String provider);

        /**
         * <p>
         * The provider for the remote repository.
         * </p>
         * 
         * @param provider
         *        The provider for the remote repository.
         * @see SourceControlProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceControlProvider
         */
        Builder provider(SourceControlProvider provider);

        /**
         * <p>
         * The name of the remote repository that contains the job artifacts.
         * </p>
         * 
         * @param repository
         *        The name of the remote repository that contains the job artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The owner of the remote repository that contains the job artifacts.
         * </p>
         * 
         * @param owner
         *        The owner of the remote repository that contains the job artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * An optional branch in the remote repository.
         * </p>
         * 
         * @param branch
         *        An optional branch in the remote repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * An optional folder in the remote repository.
         * </p>
         * 
         * @param folder
         *        An optional folder in the remote repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folder(String folder);

        /**
         * <p>
         * The last commit ID for a commit in the remote repository.
         * </p>
         * 
         * @param lastCommitId
         *        The last commit ID for a commit in the remote repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastCommitId(String lastCommitId);

        /**
         * <p>
         * The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
         * Manager, or a personal access token.
         * </p>
         * 
         * @param authStrategy
         *        The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
         *        Manager, or a personal access token.
         * @see SourceControlAuthStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceControlAuthStrategy
         */
        Builder authStrategy(String authStrategy);

        /**
         * <p>
         * The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
         * Manager, or a personal access token.
         * </p>
         * 
         * @param authStrategy
         *        The type of authentication, which can be an authentication token stored in Amazon Web Services Secrets
         *        Manager, or a personal access token.
         * @see SourceControlAuthStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceControlAuthStrategy
         */
        Builder authStrategy(SourceControlAuthStrategy authStrategy);

        /**
         * <p>
         * The value of an authorization token.
         * </p>
         * 
         * @param authToken
         *        The value of an authorization token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);
    }

    static final class BuilderImpl implements Builder {
        private String provider;

        private String repository;

        private String owner;

        private String branch;

        private String folder;

        private String lastCommitId;

        private String authStrategy;

        private String authToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceControlDetails model) {
            provider(model.provider);
            repository(model.repository);
            owner(model.owner);
            branch(model.branch);
            folder(model.folder);
            lastCommitId(model.lastCommitId);
            authStrategy(model.authStrategy);
            authToken(model.authToken);
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(SourceControlProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getRepository() {
            return repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getBranch() {
            return branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getFolder() {
            return folder;
        }

        public final void setFolder(String folder) {
            this.folder = folder;
        }

        @Override
        public final Builder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public final String getLastCommitId() {
            return lastCommitId;
        }

        public final void setLastCommitId(String lastCommitId) {
            this.lastCommitId = lastCommitId;
        }

        @Override
        public final Builder lastCommitId(String lastCommitId) {
            this.lastCommitId = lastCommitId;
            return this;
        }

        public final String getAuthStrategy() {
            return authStrategy;
        }

        public final void setAuthStrategy(String authStrategy) {
            this.authStrategy = authStrategy;
        }

        @Override
        public final Builder authStrategy(String authStrategy) {
            this.authStrategy = authStrategy;
            return this;
        }

        @Override
        public final Builder authStrategy(SourceControlAuthStrategy authStrategy) {
            this.authStrategy(authStrategy == null ? null : authStrategy.toString());
            return this;
        }

        public final String getAuthToken() {
            return authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        @Override
        public SourceControlDetails build() {
            return new SourceControlDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
