/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can
 * access user data encrypted in Amazon S3 using KMS.
 * </p>
 * <p>
 * Additionally, imported labels and trained transforms can now be encrypted using a customer provided KMS key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformEncryption.Builder, TransformEncryption> {
    private static final SdkField<MLUserDataEncryption> ML_USER_DATA_ENCRYPTION_FIELD = SdkField
            .<MLUserDataEncryption> builder(MarshallingType.SDK_POJO).memberName("MlUserDataEncryption")
            .getter(getter(TransformEncryption::mlUserDataEncryption)).setter(setter(Builder::mlUserDataEncryption))
            .constructor(MLUserDataEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlUserDataEncryption").build())
            .build();

    private static final SdkField<String> TASK_RUN_SECURITY_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TaskRunSecurityConfigurationName")
            .getter(getter(TransformEncryption::taskRunSecurityConfigurationName))
            .setter(setter(Builder::taskRunSecurityConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRunSecurityConfigurationName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_USER_DATA_ENCRYPTION_FIELD,
            TASK_RUN_SECURITY_CONFIGURATION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MlUserDataEncryption", ML_USER_DATA_ENCRYPTION_FIELD);
                    put("TaskRunSecurityConfigurationName", TASK_RUN_SECURITY_CONFIGURATION_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final MLUserDataEncryption mlUserDataEncryption;

    private final String taskRunSecurityConfigurationName;

    private TransformEncryption(BuilderImpl builder) {
        this.mlUserDataEncryption = builder.mlUserDataEncryption;
        this.taskRunSecurityConfigurationName = builder.taskRunSecurityConfigurationName;
    }

    /**
     * <p>
     * An <code>MLUserDataEncryption</code> object containing the encryption mode and customer-provided KMS key ID.
     * </p>
     * 
     * @return An <code>MLUserDataEncryption</code> object containing the encryption mode and customer-provided KMS key
     *         ID.
     */
    public final MLUserDataEncryption mlUserDataEncryption() {
        return mlUserDataEncryption;
    }

    /**
     * <p>
     * The name of the security configuration.
     * </p>
     * 
     * @return The name of the security configuration.
     */
    public final String taskRunSecurityConfigurationName() {
        return taskRunSecurityConfigurationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mlUserDataEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(taskRunSecurityConfigurationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformEncryption)) {
            return false;
        }
        TransformEncryption other = (TransformEncryption) obj;
        return Objects.equals(mlUserDataEncryption(), other.mlUserDataEncryption())
                && Objects.equals(taskRunSecurityConfigurationName(), other.taskRunSecurityConfigurationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformEncryption").add("MlUserDataEncryption", mlUserDataEncryption())
                .add("TaskRunSecurityConfigurationName", taskRunSecurityConfigurationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MlUserDataEncryption":
            return Optional.ofNullable(clazz.cast(mlUserDataEncryption()));
        case "TaskRunSecurityConfigurationName":
            return Optional.ofNullable(clazz.cast(taskRunSecurityConfigurationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransformEncryption, T> g) {
        return obj -> g.apply((TransformEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformEncryption> {
        /**
         * <p>
         * An <code>MLUserDataEncryption</code> object containing the encryption mode and customer-provided KMS key ID.
         * </p>
         * 
         * @param mlUserDataEncryption
         *        An <code>MLUserDataEncryption</code> object containing the encryption mode and customer-provided KMS
         *        key ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlUserDataEncryption(MLUserDataEncryption mlUserDataEncryption);

        /**
         * <p>
         * An <code>MLUserDataEncryption</code> object containing the encryption mode and customer-provided KMS key ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link MLUserDataEncryption.Builder} avoiding
         * the need to create one manually via {@link MLUserDataEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MLUserDataEncryption.Builder#build()} is called immediately and
         * its result is passed to {@link #mlUserDataEncryption(MLUserDataEncryption)}.
         * 
         * @param mlUserDataEncryption
         *        a consumer that will call methods on {@link MLUserDataEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mlUserDataEncryption(MLUserDataEncryption)
         */
        default Builder mlUserDataEncryption(Consumer<MLUserDataEncryption.Builder> mlUserDataEncryption) {
            return mlUserDataEncryption(MLUserDataEncryption.builder().applyMutation(mlUserDataEncryption).build());
        }

        /**
         * <p>
         * The name of the security configuration.
         * </p>
         * 
         * @param taskRunSecurityConfigurationName
         *        The name of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunSecurityConfigurationName(String taskRunSecurityConfigurationName);
    }

    static final class BuilderImpl implements Builder {
        private MLUserDataEncryption mlUserDataEncryption;

        private String taskRunSecurityConfigurationName;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformEncryption model) {
            mlUserDataEncryption(model.mlUserDataEncryption);
            taskRunSecurityConfigurationName(model.taskRunSecurityConfigurationName);
        }

        public final MLUserDataEncryption.Builder getMlUserDataEncryption() {
            return mlUserDataEncryption != null ? mlUserDataEncryption.toBuilder() : null;
        }

        public final void setMlUserDataEncryption(MLUserDataEncryption.BuilderImpl mlUserDataEncryption) {
            this.mlUserDataEncryption = mlUserDataEncryption != null ? mlUserDataEncryption.build() : null;
        }

        @Override
        public final Builder mlUserDataEncryption(MLUserDataEncryption mlUserDataEncryption) {
            this.mlUserDataEncryption = mlUserDataEncryption;
            return this;
        }

        public final String getTaskRunSecurityConfigurationName() {
            return taskRunSecurityConfigurationName;
        }

        public final void setTaskRunSecurityConfigurationName(String taskRunSecurityConfigurationName) {
            this.taskRunSecurityConfigurationName = taskRunSecurityConfigurationName;
        }

        @Override
        public final Builder taskRunSecurityConfigurationName(String taskRunSecurityConfigurationName) {
            this.taskRunSecurityConfigurationName = taskRunSecurityConfigurationName;
            return this;
        }

        @Override
        public TransformEncryption build() {
            return new TransformEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
