/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIntegrationResourcePropertyRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateIntegrationResourcePropertyRequest.Builder, UpdateIntegrationResourcePropertyRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(UpdateIntegrationResourcePropertyRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<SourceProcessingProperties> SOURCE_PROCESSING_PROPERTIES_FIELD = SdkField
            .<SourceProcessingProperties> builder(MarshallingType.SDK_POJO)
            .memberName("SourceProcessingProperties")
            .getter(getter(UpdateIntegrationResourcePropertyRequest::sourceProcessingProperties))
            .setter(setter(Builder::sourceProcessingProperties))
            .constructor(SourceProcessingProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProcessingProperties").build())
            .build();

    private static final SdkField<TargetProcessingProperties> TARGET_PROCESSING_PROPERTIES_FIELD = SdkField
            .<TargetProcessingProperties> builder(MarshallingType.SDK_POJO)
            .memberName("TargetProcessingProperties")
            .getter(getter(UpdateIntegrationResourcePropertyRequest::targetProcessingProperties))
            .setter(setter(Builder::targetProcessingProperties))
            .constructor(TargetProcessingProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetProcessingProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            SOURCE_PROCESSING_PROPERTIES_FIELD, TARGET_PROCESSING_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ResourceArn", RESOURCE_ARN_FIELD);
                    put("SourceProcessingProperties", SOURCE_PROCESSING_PROPERTIES_FIELD);
                    put("TargetProcessingProperties", TARGET_PROCESSING_PROPERTIES_FIELD);
                }
            });

    private final String resourceArn;

    private final SourceProcessingProperties sourceProcessingProperties;

    private final TargetProcessingProperties targetProcessingProperties;

    private UpdateIntegrationResourcePropertyRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.sourceProcessingProperties = builder.sourceProcessingProperties;
        this.targetProcessingProperties = builder.targetProcessingProperties;
    }

    /**
     * <p>
     * The connection ARN of the source, or the database ARN of the target.
     * </p>
     * 
     * @return The connection ARN of the source, or the database ARN of the target.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The resource properties associated with the integration source.
     * </p>
     * 
     * @return The resource properties associated with the integration source.
     */
    public final SourceProcessingProperties sourceProcessingProperties() {
        return sourceProcessingProperties;
    }

    /**
     * <p>
     * The resource properties associated with the integration target.
     * </p>
     * 
     * @return The resource properties associated with the integration target.
     */
    public final TargetProcessingProperties targetProcessingProperties() {
        return targetProcessingProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceProcessingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(targetProcessingProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationResourcePropertyRequest)) {
            return false;
        }
        UpdateIntegrationResourcePropertyRequest other = (UpdateIntegrationResourcePropertyRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(sourceProcessingProperties(), other.sourceProcessingProperties())
                && Objects.equals(targetProcessingProperties(), other.targetProcessingProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIntegrationResourcePropertyRequest").add("ResourceArn", resourceArn())
                .add("SourceProcessingProperties", sourceProcessingProperties())
                .add("TargetProcessingProperties", targetProcessingProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "SourceProcessingProperties":
            return Optional.ofNullable(clazz.cast(sourceProcessingProperties()));
        case "TargetProcessingProperties":
            return Optional.ofNullable(clazz.cast(targetProcessingProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntegrationResourcePropertyRequest, T> g) {
        return obj -> g.apply((UpdateIntegrationResourcePropertyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIntegrationResourcePropertyRequest> {
        /**
         * <p>
         * The connection ARN of the source, or the database ARN of the target.
         * </p>
         * 
         * @param resourceArn
         *        The connection ARN of the source, or the database ARN of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The resource properties associated with the integration source.
         * </p>
         * 
         * @param sourceProcessingProperties
         *        The resource properties associated with the integration source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProcessingProperties(SourceProcessingProperties sourceProcessingProperties);

        /**
         * <p>
         * The resource properties associated with the integration source.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceProcessingProperties.Builder}
         * avoiding the need to create one manually via {@link SourceProcessingProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceProcessingProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceProcessingProperties(SourceProcessingProperties)}.
         * 
         * @param sourceProcessingProperties
         *        a consumer that will call methods on {@link SourceProcessingProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceProcessingProperties(SourceProcessingProperties)
         */
        default Builder sourceProcessingProperties(Consumer<SourceProcessingProperties.Builder> sourceProcessingProperties) {
            return sourceProcessingProperties(SourceProcessingProperties.builder().applyMutation(sourceProcessingProperties)
                    .build());
        }

        /**
         * <p>
         * The resource properties associated with the integration target.
         * </p>
         * 
         * @param targetProcessingProperties
         *        The resource properties associated with the integration target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetProcessingProperties(TargetProcessingProperties targetProcessingProperties);

        /**
         * <p>
         * The resource properties associated with the integration target.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetProcessingProperties.Builder}
         * avoiding the need to create one manually via {@link TargetProcessingProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetProcessingProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #targetProcessingProperties(TargetProcessingProperties)}.
         * 
         * @param targetProcessingProperties
         *        a consumer that will call methods on {@link TargetProcessingProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetProcessingProperties(TargetProcessingProperties)
         */
        default Builder targetProcessingProperties(Consumer<TargetProcessingProperties.Builder> targetProcessingProperties) {
            return targetProcessingProperties(TargetProcessingProperties.builder().applyMutation(targetProcessingProperties)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private SourceProcessingProperties sourceProcessingProperties;

        private TargetProcessingProperties targetProcessingProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntegrationResourcePropertyRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            sourceProcessingProperties(model.sourceProcessingProperties);
            targetProcessingProperties(model.targetProcessingProperties);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final SourceProcessingProperties.Builder getSourceProcessingProperties() {
            return sourceProcessingProperties != null ? sourceProcessingProperties.toBuilder() : null;
        }

        public final void setSourceProcessingProperties(SourceProcessingProperties.BuilderImpl sourceProcessingProperties) {
            this.sourceProcessingProperties = sourceProcessingProperties != null ? sourceProcessingProperties.build() : null;
        }

        @Override
        public final Builder sourceProcessingProperties(SourceProcessingProperties sourceProcessingProperties) {
            this.sourceProcessingProperties = sourceProcessingProperties;
            return this;
        }

        public final TargetProcessingProperties.Builder getTargetProcessingProperties() {
            return targetProcessingProperties != null ? targetProcessingProperties.toBuilder() : null;
        }

        public final void setTargetProcessingProperties(TargetProcessingProperties.BuilderImpl targetProcessingProperties) {
            this.targetProcessingProperties = targetProcessingProperties != null ? targetProcessingProperties.build() : null;
        }

        @Override
        public final Builder targetProcessingProperties(TargetProcessingProperties targetProcessingProperties) {
            this.targetProcessingProperties = targetProcessingProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIntegrationResourcePropertyRequest build() {
            return new UpdateIntegrationResourcePropertyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
