/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.CustomPropertiesCopier;
import software.amazon.awssdk.services.glue.model.FieldDataType;
import software.amazon.awssdk.services.glue.model.FieldFilterOperator;
import software.amazon.awssdk.services.glue.model.FieldFilterOperatorsListCopier;
import software.amazon.awssdk.services.glue.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Field
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Field> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldName").getter(Field.getter(Field::fieldName)).setter(Field.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(Field.getter(Field::label)).setter(Field.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Field.getter(Field::description)).setter(Field.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldType").getter(Field.getter(Field::fieldTypeAsString)).setter(Field.setter(Builder::fieldType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldType").build()}).build();
    private static final SdkField<Boolean> IS_PRIMARY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPrimaryKey").getter(Field.getter(Field::isPrimaryKey)).setter(Field.setter(Builder::isPrimaryKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPrimaryKey").build()}).build();
    private static final SdkField<Boolean> IS_NULLABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsNullable").getter(Field.getter(Field::isNullable)).setter(Field.setter(Builder::isNullable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNullable").build()}).build();
    private static final SdkField<Boolean> IS_RETRIEVABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsRetrievable").getter(Field.getter(Field::isRetrievable)).setter(Field.setter(Builder::isRetrievable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRetrievable").build()}).build();
    private static final SdkField<Boolean> IS_FILTERABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsFilterable").getter(Field.getter(Field::isFilterable)).setter(Field.setter(Builder::isFilterable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsFilterable").build()}).build();
    private static final SdkField<Boolean> IS_PARTITIONABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPartitionable").getter(Field.getter(Field::isPartitionable)).setter(Field.setter(Builder::isPartitionable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartitionable").build()}).build();
    private static final SdkField<Boolean> IS_CREATEABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsCreateable").getter(Field.getter(Field::isCreateable)).setter(Field.setter(Builder::isCreateable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsCreateable").build()}).build();
    private static final SdkField<Boolean> IS_UPDATEABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsUpdateable").getter(Field.getter(Field::isUpdateable)).setter(Field.setter(Builder::isUpdateable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsUpdateable").build()}).build();
    private static final SdkField<Boolean> IS_UPSERTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsUpsertable").getter(Field.getter(Field::isUpsertable)).setter(Field.setter(Builder::isUpsertable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsUpsertable").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_ON_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefaultOnCreate").getter(Field.getter(Field::isDefaultOnCreate)).setter(Field.setter(Builder::isDefaultOnCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultOnCreate").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedValues").getter(Field.getter(Field::supportedValues)).setter(Field.setter(Builder::supportedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_FILTER_OPERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedFilterOperators").getter(Field.getter(Field::supportedFilterOperatorsAsStrings)).setter(Field.setter(Builder::supportedFilterOperatorsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedFilterOperators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PARENT_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentField").getter(Field.getter(Field::parentField)).setter(Field.setter(Builder::parentField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentField").build()}).build();
    private static final SdkField<String> NATIVE_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NativeDataType").getter(Field.getter(Field::nativeDataType)).setter(Field.setter(Builder::nativeDataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NativeDataType").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomProperties").getter(Field.getter(Field::customProperties)).setter(Field.setter(Builder::customProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, LABEL_FIELD, DESCRIPTION_FIELD, FIELD_TYPE_FIELD, IS_PRIMARY_KEY_FIELD, IS_NULLABLE_FIELD, IS_RETRIEVABLE_FIELD, IS_FILTERABLE_FIELD, IS_PARTITIONABLE_FIELD, IS_CREATEABLE_FIELD, IS_UPDATEABLE_FIELD, IS_UPSERTABLE_FIELD, IS_DEFAULT_ON_CREATE_FIELD, SUPPORTED_VALUES_FIELD, SUPPORTED_FILTER_OPERATORS_FIELD, PARENT_FIELD_FIELD, NATIVE_DATA_TYPE_FIELD, CUSTOM_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FieldName", FIELD_NAME_FIELD);
            this.put("Label", LABEL_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("FieldType", FIELD_TYPE_FIELD);
            this.put("IsPrimaryKey", IS_PRIMARY_KEY_FIELD);
            this.put("IsNullable", IS_NULLABLE_FIELD);
            this.put("IsRetrievable", IS_RETRIEVABLE_FIELD);
            this.put("IsFilterable", IS_FILTERABLE_FIELD);
            this.put("IsPartitionable", IS_PARTITIONABLE_FIELD);
            this.put("IsCreateable", IS_CREATEABLE_FIELD);
            this.put("IsUpdateable", IS_UPDATEABLE_FIELD);
            this.put("IsUpsertable", IS_UPSERTABLE_FIELD);
            this.put("IsDefaultOnCreate", IS_DEFAULT_ON_CREATE_FIELD);
            this.put("SupportedValues", SUPPORTED_VALUES_FIELD);
            this.put("SupportedFilterOperators", SUPPORTED_FILTER_OPERATORS_FIELD);
            this.put("ParentField", PARENT_FIELD_FIELD);
            this.put("NativeDataType", NATIVE_DATA_TYPE_FIELD);
            this.put("CustomProperties", CUSTOM_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final String label;
    private final String description;
    private final String fieldType;
    private final Boolean isPrimaryKey;
    private final Boolean isNullable;
    private final Boolean isRetrievable;
    private final Boolean isFilterable;
    private final Boolean isPartitionable;
    private final Boolean isCreateable;
    private final Boolean isUpdateable;
    private final Boolean isUpsertable;
    private final Boolean isDefaultOnCreate;
    private final List<String> supportedValues;
    private final List<String> supportedFilterOperators;
    private final String parentField;
    private final String nativeDataType;
    private final Map<String, String> customProperties;

    private Field(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.label = builder.label;
        this.description = builder.description;
        this.fieldType = builder.fieldType;
        this.isPrimaryKey = builder.isPrimaryKey;
        this.isNullable = builder.isNullable;
        this.isRetrievable = builder.isRetrievable;
        this.isFilterable = builder.isFilterable;
        this.isPartitionable = builder.isPartitionable;
        this.isCreateable = builder.isCreateable;
        this.isUpdateable = builder.isUpdateable;
        this.isUpsertable = builder.isUpsertable;
        this.isDefaultOnCreate = builder.isDefaultOnCreate;
        this.supportedValues = builder.supportedValues;
        this.supportedFilterOperators = builder.supportedFilterOperators;
        this.parentField = builder.parentField;
        this.nativeDataType = builder.nativeDataType;
        this.customProperties = builder.customProperties;
    }

    public final String fieldName() {
        return this.fieldName;
    }

    public final String label() {
        return this.label;
    }

    public final String description() {
        return this.description;
    }

    public final FieldDataType fieldType() {
        return FieldDataType.fromValue(this.fieldType);
    }

    public final String fieldTypeAsString() {
        return this.fieldType;
    }

    public final Boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public final Boolean isNullable() {
        return this.isNullable;
    }

    public final Boolean isRetrievable() {
        return this.isRetrievable;
    }

    public final Boolean isFilterable() {
        return this.isFilterable;
    }

    public final Boolean isPartitionable() {
        return this.isPartitionable;
    }

    public final Boolean isCreateable() {
        return this.isCreateable;
    }

    public final Boolean isUpdateable() {
        return this.isUpdateable;
    }

    public final Boolean isUpsertable() {
        return this.isUpsertable;
    }

    public final Boolean isDefaultOnCreate() {
        return this.isDefaultOnCreate;
    }

    public final boolean hasSupportedValues() {
        return this.supportedValues != null && !(this.supportedValues instanceof SdkAutoConstructList);
    }

    public final List<String> supportedValues() {
        return this.supportedValues;
    }

    public final List<FieldFilterOperator> supportedFilterOperators() {
        return FieldFilterOperatorsListCopier.copyStringToEnum(this.supportedFilterOperators);
    }

    public final boolean hasSupportedFilterOperators() {
        return this.supportedFilterOperators != null && !(this.supportedFilterOperators instanceof SdkAutoConstructList);
    }

    public final List<String> supportedFilterOperatorsAsStrings() {
        return this.supportedFilterOperators;
    }

    public final String parentField() {
        return this.parentField;
    }

    public final String nativeDataType() {
        return this.nativeDataType;
    }

    public final boolean hasCustomProperties() {
        return this.customProperties != null && !(this.customProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customProperties() {
        return this.customProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPrimaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.isNullable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRetrievable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isFilterable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPartitionable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isCreateable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isUpdateable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isUpsertable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultOnCreate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedValues() ? this.supportedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedFilterOperators() ? this.supportedFilterOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parentField());
        hashCode = 31 * hashCode + Objects.hashCode(this.nativeDataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomProperties() ? this.customProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.fieldTypeAsString(), other.fieldTypeAsString()) && Objects.equals(this.isPrimaryKey(), other.isPrimaryKey()) && Objects.equals(this.isNullable(), other.isNullable()) && Objects.equals(this.isRetrievable(), other.isRetrievable()) && Objects.equals(this.isFilterable(), other.isFilterable()) && Objects.equals(this.isPartitionable(), other.isPartitionable()) && Objects.equals(this.isCreateable(), other.isCreateable()) && Objects.equals(this.isUpdateable(), other.isUpdateable()) && Objects.equals(this.isUpsertable(), other.isUpsertable()) && Objects.equals(this.isDefaultOnCreate(), other.isDefaultOnCreate()) && this.hasSupportedValues() == other.hasSupportedValues() && Objects.equals(this.supportedValues(), other.supportedValues()) && this.hasSupportedFilterOperators() == other.hasSupportedFilterOperators() && Objects.equals(this.supportedFilterOperatorsAsStrings(), other.supportedFilterOperatorsAsStrings()) && Objects.equals(this.parentField(), other.parentField()) && Objects.equals(this.nativeDataType(), other.nativeDataType()) && this.hasCustomProperties() == other.hasCustomProperties() && Objects.equals(this.customProperties(), other.customProperties());
    }

    public final String toString() {
        return ToString.builder((String)"Field").add("FieldName", (Object)this.fieldName()).add("Label", (Object)this.label()).add("Description", (Object)this.description()).add("FieldType", (Object)this.fieldTypeAsString()).add("IsPrimaryKey", (Object)this.isPrimaryKey()).add("IsNullable", (Object)this.isNullable()).add("IsRetrievable", (Object)this.isRetrievable()).add("IsFilterable", (Object)this.isFilterable()).add("IsPartitionable", (Object)this.isPartitionable()).add("IsCreateable", (Object)this.isCreateable()).add("IsUpdateable", (Object)this.isUpdateable()).add("IsUpsertable", (Object)this.isUpsertable()).add("IsDefaultOnCreate", (Object)this.isDefaultOnCreate()).add("SupportedValues", this.hasSupportedValues() ? this.supportedValues() : null).add("SupportedFilterOperators", this.hasSupportedFilterOperators() ? this.supportedFilterOperatorsAsStrings() : null).add("ParentField", (Object)this.parentField()).add("NativeDataType", (Object)this.nativeDataType()).add("CustomProperties", this.hasCustomProperties() ? this.customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FieldType": {
                return Optional.ofNullable(clazz.cast(this.fieldTypeAsString()));
            }
            case "IsPrimaryKey": {
                return Optional.ofNullable(clazz.cast(this.isPrimaryKey()));
            }
            case "IsNullable": {
                return Optional.ofNullable(clazz.cast(this.isNullable()));
            }
            case "IsRetrievable": {
                return Optional.ofNullable(clazz.cast(this.isRetrievable()));
            }
            case "IsFilterable": {
                return Optional.ofNullable(clazz.cast(this.isFilterable()));
            }
            case "IsPartitionable": {
                return Optional.ofNullable(clazz.cast(this.isPartitionable()));
            }
            case "IsCreateable": {
                return Optional.ofNullable(clazz.cast(this.isCreateable()));
            }
            case "IsUpdateable": {
                return Optional.ofNullable(clazz.cast(this.isUpdateable()));
            }
            case "IsUpsertable": {
                return Optional.ofNullable(clazz.cast(this.isUpsertable()));
            }
            case "IsDefaultOnCreate": {
                return Optional.ofNullable(clazz.cast(this.isDefaultOnCreate()));
            }
            case "SupportedValues": {
                return Optional.ofNullable(clazz.cast(this.supportedValues()));
            }
            case "SupportedFilterOperators": {
                return Optional.ofNullable(clazz.cast(this.supportedFilterOperatorsAsStrings()));
            }
            case "ParentField": {
                return Optional.ofNullable(clazz.cast(this.parentField()));
            }
            case "NativeDataType": {
                return Optional.ofNullable(clazz.cast(this.nativeDataType()));
            }
            case "CustomProperties": {
                return Optional.ofNullable(clazz.cast(this.customProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Field, T> g) {
        return obj -> g.apply((Field)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private String label;
        private String description;
        private String fieldType;
        private Boolean isPrimaryKey;
        private Boolean isNullable;
        private Boolean isRetrievable;
        private Boolean isFilterable;
        private Boolean isPartitionable;
        private Boolean isCreateable;
        private Boolean isUpdateable;
        private Boolean isUpsertable;
        private Boolean isDefaultOnCreate;
        private List<String> supportedValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedFilterOperators = DefaultSdkAutoConstructList.getInstance();
        private String parentField;
        private String nativeDataType;
        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Field model) {
            this.fieldName(model.fieldName);
            this.label(model.label);
            this.description(model.description);
            this.fieldType(model.fieldType);
            this.isPrimaryKey(model.isPrimaryKey);
            this.isNullable(model.isNullable);
            this.isRetrievable(model.isRetrievable);
            this.isFilterable(model.isFilterable);
            this.isPartitionable(model.isPartitionable);
            this.isCreateable(model.isCreateable);
            this.isUpdateable(model.isUpdateable);
            this.isUpsertable(model.isUpsertable);
            this.isDefaultOnCreate(model.isDefaultOnCreate);
            this.supportedValues(model.supportedValues);
            this.supportedFilterOperatorsWithStrings(model.supportedFilterOperators);
            this.parentField(model.parentField);
            this.nativeDataType(model.nativeDataType);
            this.customProperties(model.customProperties);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFieldType() {
            return this.fieldType;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        @Override
        public final Builder fieldType(FieldDataType fieldType) {
            this.fieldType(fieldType == null ? null : fieldType.toString());
            return this;
        }

        public final Boolean getIsPrimaryKey() {
            return this.isPrimaryKey;
        }

        public final void setIsPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
        }

        @Override
        public final Builder isPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            return this;
        }

        public final Boolean getIsNullable() {
            return this.isNullable;
        }

        public final void setIsNullable(Boolean isNullable) {
            this.isNullable = isNullable;
        }

        @Override
        public final Builder isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public final Boolean getIsRetrievable() {
            return this.isRetrievable;
        }

        public final void setIsRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
        }

        @Override
        public final Builder isRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
            return this;
        }

        public final Boolean getIsFilterable() {
            return this.isFilterable;
        }

        public final void setIsFilterable(Boolean isFilterable) {
            this.isFilterable = isFilterable;
        }

        @Override
        public final Builder isFilterable(Boolean isFilterable) {
            this.isFilterable = isFilterable;
            return this;
        }

        public final Boolean getIsPartitionable() {
            return this.isPartitionable;
        }

        public final void setIsPartitionable(Boolean isPartitionable) {
            this.isPartitionable = isPartitionable;
        }

        @Override
        public final Builder isPartitionable(Boolean isPartitionable) {
            this.isPartitionable = isPartitionable;
            return this;
        }

        public final Boolean getIsCreateable() {
            return this.isCreateable;
        }

        public final void setIsCreateable(Boolean isCreateable) {
            this.isCreateable = isCreateable;
        }

        @Override
        public final Builder isCreateable(Boolean isCreateable) {
            this.isCreateable = isCreateable;
            return this;
        }

        public final Boolean getIsUpdateable() {
            return this.isUpdateable;
        }

        public final void setIsUpdateable(Boolean isUpdateable) {
            this.isUpdateable = isUpdateable;
        }

        @Override
        public final Builder isUpdateable(Boolean isUpdateable) {
            this.isUpdateable = isUpdateable;
            return this;
        }

        public final Boolean getIsUpsertable() {
            return this.isUpsertable;
        }

        public final void setIsUpsertable(Boolean isUpsertable) {
            this.isUpsertable = isUpsertable;
        }

        @Override
        public final Builder isUpsertable(Boolean isUpsertable) {
            this.isUpsertable = isUpsertable;
            return this;
        }

        public final Boolean getIsDefaultOnCreate() {
            return this.isDefaultOnCreate;
        }

        public final void setIsDefaultOnCreate(Boolean isDefaultOnCreate) {
            this.isDefaultOnCreate = isDefaultOnCreate;
        }

        @Override
        public final Builder isDefaultOnCreate(Boolean isDefaultOnCreate) {
            this.isDefaultOnCreate = isDefaultOnCreate;
            return this;
        }

        public final Collection<String> getSupportedValues() {
            if (this.supportedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedValues;
        }

        public final void setSupportedValues(Collection<String> supportedValues) {
            this.supportedValues = ListOfStringCopier.copy(supportedValues);
        }

        @Override
        public final Builder supportedValues(Collection<String> supportedValues) {
            this.supportedValues = ListOfStringCopier.copy(supportedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedValues(String ... supportedValues) {
            this.supportedValues(Arrays.asList(supportedValues));
            return this;
        }

        public final Collection<String> getSupportedFilterOperators() {
            if (this.supportedFilterOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedFilterOperators;
        }

        public final void setSupportedFilterOperators(Collection<String> supportedFilterOperators) {
            this.supportedFilterOperators = FieldFilterOperatorsListCopier.copy(supportedFilterOperators);
        }

        @Override
        public final Builder supportedFilterOperatorsWithStrings(Collection<String> supportedFilterOperators) {
            this.supportedFilterOperators = FieldFilterOperatorsListCopier.copy(supportedFilterOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFilterOperatorsWithStrings(String ... supportedFilterOperators) {
            this.supportedFilterOperatorsWithStrings(Arrays.asList(supportedFilterOperators));
            return this;
        }

        @Override
        public final Builder supportedFilterOperators(Collection<FieldFilterOperator> supportedFilterOperators) {
            this.supportedFilterOperators = FieldFilterOperatorsListCopier.copyEnumToString(supportedFilterOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFilterOperators(FieldFilterOperator ... supportedFilterOperators) {
            this.supportedFilterOperators(Arrays.asList(supportedFilterOperators));
            return this;
        }

        public final String getParentField() {
            return this.parentField;
        }

        public final void setParentField(String parentField) {
            this.parentField = parentField;
        }

        @Override
        public final Builder parentField(String parentField) {
            this.parentField = parentField;
            return this;
        }

        public final String getNativeDataType() {
            return this.nativeDataType;
        }

        public final void setNativeDataType(String nativeDataType) {
            this.nativeDataType = nativeDataType;
        }

        @Override
        public final Builder nativeDataType(String nativeDataType) {
            this.nativeDataType = nativeDataType;
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (this.customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
        }

        @Override
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
            return this;
        }

        public Field build() {
            return new Field(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Field> {
        public Builder fieldName(String var1);

        public Builder label(String var1);

        public Builder description(String var1);

        public Builder fieldType(String var1);

        public Builder fieldType(FieldDataType var1);

        public Builder isPrimaryKey(Boolean var1);

        public Builder isNullable(Boolean var1);

        public Builder isRetrievable(Boolean var1);

        public Builder isFilterable(Boolean var1);

        public Builder isPartitionable(Boolean var1);

        public Builder isCreateable(Boolean var1);

        public Builder isUpdateable(Boolean var1);

        public Builder isUpsertable(Boolean var1);

        public Builder isDefaultOnCreate(Boolean var1);

        public Builder supportedValues(Collection<String> var1);

        public Builder supportedValues(String ... var1);

        public Builder supportedFilterOperatorsWithStrings(Collection<String> var1);

        public Builder supportedFilterOperatorsWithStrings(String ... var1);

        public Builder supportedFilterOperators(Collection<FieldFilterOperator> var1);

        public Builder supportedFilterOperators(FieldFilterOperator ... var1);

        public Builder parentField(String var1);

        public Builder nativeDataType(String var1);

        public Builder customProperties(Map<String, String> var1);
    }
}

