/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.SchemaVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSchemaVersionResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetSchemaVersionResponse> {
    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersionId").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::schemaVersionId)).setter(GetSchemaVersionResponse.setter(Builder::schemaVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()}).build();
    private static final SdkField<String> SCHEMA_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaDefinition").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::schemaDefinition)).setter(GetSchemaVersionResponse.setter(Builder::schemaDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDefinition").build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::dataFormatAsString)).setter(GetSchemaVersionResponse.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaArn").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::schemaArn)).setter(GetSchemaVersionResponse.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::versionNumber)).setter(GetSchemaVersionResponse.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::statusAsString)).setter(GetSchemaVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::createdTime)).setter(GetSchemaVersionResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_ID_FIELD, SCHEMA_DEFINITION_FIELD, DATA_FORMAT_FIELD, SCHEMA_ARN_FIELD, VERSION_NUMBER_FIELD, STATUS_FIELD, CREATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SchemaVersionId", SCHEMA_VERSION_ID_FIELD);
            this.put("SchemaDefinition", SCHEMA_DEFINITION_FIELD);
            this.put("DataFormat", DATA_FORMAT_FIELD);
            this.put("SchemaArn", SCHEMA_ARN_FIELD);
            this.put("VersionNumber", VERSION_NUMBER_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreatedTime", CREATED_TIME_FIELD);
        }
    });
    private final String schemaVersionId;
    private final String schemaDefinition;
    private final String dataFormat;
    private final String schemaArn;
    private final Long versionNumber;
    private final String status;
    private final String createdTime;

    private GetSchemaVersionResponse(BuilderImpl builder) {
        super(builder);
        this.schemaVersionId = builder.schemaVersionId;
        this.schemaDefinition = builder.schemaDefinition;
        this.dataFormat = builder.dataFormat;
        this.schemaArn = builder.schemaArn;
        this.versionNumber = builder.versionNumber;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
    }

    public final String schemaVersionId() {
        return this.schemaVersionId;
    }

    public final String schemaDefinition() {
        return this.schemaDefinition;
    }

    public final DataFormat dataFormat() {
        return DataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public final String schemaArn() {
        return this.schemaArn;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public final SchemaVersionStatus status() {
        return SchemaVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaVersionResponse)) {
            return false;
        }
        GetSchemaVersionResponse other = (GetSchemaVersionResponse)((Object)obj);
        return Objects.equals(this.schemaVersionId(), other.schemaVersionId()) && Objects.equals(this.schemaDefinition(), other.schemaDefinition()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetSchemaVersionResponse").add("SchemaVersionId", (Object)this.schemaVersionId()).add("SchemaDefinition", (Object)this.schemaDefinition()).add("DataFormat", (Object)this.dataFormatAsString()).add("SchemaArn", (Object)this.schemaArn()).add("VersionNumber", (Object)this.versionNumber()).add("Status", (Object)this.statusAsString()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaVersionId": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionId()));
            }
            case "SchemaDefinition": {
                return Optional.ofNullable(clazz.cast(this.schemaDefinition()));
            }
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaVersionResponse, T> g) {
        return obj -> g.apply((GetSchemaVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String schemaVersionId;
        private String schemaDefinition;
        private String dataFormat;
        private String schemaArn;
        private Long versionNumber;
        private String status;
        private String createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaVersionResponse model) {
            super(model);
            this.schemaVersionId(model.schemaVersionId);
            this.schemaDefinition(model.schemaDefinition);
            this.dataFormat(model.dataFormat);
            this.schemaArn(model.schemaArn);
            this.versionNumber(model.versionNumber);
            this.status(model.status);
            this.createdTime(model.createdTime);
        }

        public final String getSchemaVersionId() {
            return this.schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final String getSchemaDefinition() {
            return this.schemaDefinition;
        }

        public final void setSchemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        public final Builder schemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchemaVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Override
        public GetSchemaVersionResponse build() {
            return new GetSchemaVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSchemaVersionResponse> {
        public Builder schemaVersionId(String var1);

        public Builder schemaDefinition(String var1);

        public Builder dataFormat(String var1);

        public Builder dataFormat(DataFormat var1);

        public Builder schemaArn(String var1);

        public Builder versionNumber(Long var1);

        public Builder status(String var1);

        public Builder status(SchemaVersionStatus var1);

        public Builder createdTime(String var1);
    }
}

