/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines column statistics supported for Boolean data columns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BooleanColumnStatisticsData implements SdkPojo, Serializable,
        ToCopyableBuilder<BooleanColumnStatisticsData.Builder, BooleanColumnStatisticsData> {
    private static final SdkField<Long> NUMBER_OF_TRUES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfTrues").getter(getter(BooleanColumnStatisticsData::numberOfTrues))
            .setter(setter(Builder::numberOfTrues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTrues").build()).build();

    private static final SdkField<Long> NUMBER_OF_FALSES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfFalses").getter(getter(BooleanColumnStatisticsData::numberOfFalses))
            .setter(setter(Builder::numberOfFalses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFalses").build()).build();

    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfNulls").getter(getter(BooleanColumnStatisticsData::numberOfNulls))
            .setter(setter(Builder::numberOfNulls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_TRUES_FIELD,
            NUMBER_OF_FALSES_FIELD, NUMBER_OF_NULLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long numberOfTrues;

    private final Long numberOfFalses;

    private final Long numberOfNulls;

    private BooleanColumnStatisticsData(BuilderImpl builder) {
        this.numberOfTrues = builder.numberOfTrues;
        this.numberOfFalses = builder.numberOfFalses;
        this.numberOfNulls = builder.numberOfNulls;
    }

    /**
     * <p>
     * The number of true values in the column.
     * </p>
     * 
     * @return The number of true values in the column.
     */
    public final Long numberOfTrues() {
        return numberOfTrues;
    }

    /**
     * <p>
     * The number of false values in the column.
     * </p>
     * 
     * @return The number of false values in the column.
     */
    public final Long numberOfFalses() {
        return numberOfFalses;
    }

    /**
     * <p>
     * The number of null values in the column.
     * </p>
     * 
     * @return The number of null values in the column.
     */
    public final Long numberOfNulls() {
        return numberOfNulls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTrues());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfFalses());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNulls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanColumnStatisticsData)) {
            return false;
        }
        BooleanColumnStatisticsData other = (BooleanColumnStatisticsData) obj;
        return Objects.equals(numberOfTrues(), other.numberOfTrues()) && Objects.equals(numberOfFalses(), other.numberOfFalses())
                && Objects.equals(numberOfNulls(), other.numberOfNulls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BooleanColumnStatisticsData").add("NumberOfTrues", numberOfTrues())
                .add("NumberOfFalses", numberOfFalses()).add("NumberOfNulls", numberOfNulls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfTrues":
            return Optional.ofNullable(clazz.cast(numberOfTrues()));
        case "NumberOfFalses":
            return Optional.ofNullable(clazz.cast(numberOfFalses()));
        case "NumberOfNulls":
            return Optional.ofNullable(clazz.cast(numberOfNulls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumberOfTrues", NUMBER_OF_TRUES_FIELD);
        map.put("NumberOfFalses", NUMBER_OF_FALSES_FIELD);
        map.put("NumberOfNulls", NUMBER_OF_NULLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BooleanColumnStatisticsData, T> g) {
        return obj -> g.apply((BooleanColumnStatisticsData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BooleanColumnStatisticsData> {
        /**
         * <p>
         * The number of true values in the column.
         * </p>
         * 
         * @param numberOfTrues
         *        The number of true values in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTrues(Long numberOfTrues);

        /**
         * <p>
         * The number of false values in the column.
         * </p>
         * 
         * @param numberOfFalses
         *        The number of false values in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfFalses(Long numberOfFalses);

        /**
         * <p>
         * The number of null values in the column.
         * </p>
         * 
         * @param numberOfNulls
         *        The number of null values in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNulls(Long numberOfNulls);
    }

    static final class BuilderImpl implements Builder {
        private Long numberOfTrues;

        private Long numberOfFalses;

        private Long numberOfNulls;

        private BuilderImpl() {
        }

        private BuilderImpl(BooleanColumnStatisticsData model) {
            numberOfTrues(model.numberOfTrues);
            numberOfFalses(model.numberOfFalses);
            numberOfNulls(model.numberOfNulls);
        }

        public final Long getNumberOfTrues() {
            return numberOfTrues;
        }

        public final void setNumberOfTrues(Long numberOfTrues) {
            this.numberOfTrues = numberOfTrues;
        }

        @Override
        public final Builder numberOfTrues(Long numberOfTrues) {
            this.numberOfTrues = numberOfTrues;
            return this;
        }

        public final Long getNumberOfFalses() {
            return numberOfFalses;
        }

        public final void setNumberOfFalses(Long numberOfFalses) {
            this.numberOfFalses = numberOfFalses;
        }

        @Override
        public final Builder numberOfFalses(Long numberOfFalses) {
            this.numberOfFalses = numberOfFalses;
            return this;
        }

        public final Long getNumberOfNulls() {
            return numberOfNulls;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        @Override
        public BooleanColumnStatisticsData build() {
            return new BooleanColumnStatisticsData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
