/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The set of properties required for the the OAuth2 <code>AUTHORIZATION_CODE</code> grant type workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizationCodeProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthorizationCodeProperties.Builder, AuthorizationCodeProperties> {
    private static final SdkField<String> AUTHORIZATION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationCode").getter(getter(AuthorizationCodeProperties::authorizationCode))
            .setter(setter(Builder::authorizationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCode").build()).build();

    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedirectUri").getter(getter(AuthorizationCodeProperties::redirectUri))
            .setter(setter(Builder::redirectUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_CODE_FIELD,
            REDIRECT_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AuthorizationCode", AUTHORIZATION_CODE_FIELD);
                    put("RedirectUri", REDIRECT_URI_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String authorizationCode;

    private final String redirectUri;

    private AuthorizationCodeProperties(BuilderImpl builder) {
        this.authorizationCode = builder.authorizationCode;
        this.redirectUri = builder.redirectUri;
    }

    /**
     * <p>
     * An authorization code to be used in the third leg of the <code>AUTHORIZATION_CODE</code> grant workflow. This is
     * a single-use code which becomes invalid once exchanged for an access token, thus it is acceptable to have this
     * value as a request parameter.
     * </p>
     * 
     * @return An authorization code to be used in the third leg of the <code>AUTHORIZATION_CODE</code> grant workflow.
     *         This is a single-use code which becomes invalid once exchanged for an access token, thus it is acceptable
     *         to have this value as a request parameter.
     */
    public final String authorizationCode() {
        return authorizationCode;
    }

    /**
     * <p>
     * The redirect URI where the user gets redirected to by authorization server when issuing an authorization code.
     * The URI is subsequently used when the authorization code is exchanged for an access token.
     * </p>
     * 
     * @return The redirect URI where the user gets redirected to by authorization server when issuing an authorization
     *         code. The URI is subsequently used when the authorization code is exchanged for an access token.
     */
    public final String redirectUri() {
        return redirectUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationCode());
        hashCode = 31 * hashCode + Objects.hashCode(redirectUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationCodeProperties)) {
            return false;
        }
        AuthorizationCodeProperties other = (AuthorizationCodeProperties) obj;
        return Objects.equals(authorizationCode(), other.authorizationCode())
                && Objects.equals(redirectUri(), other.redirectUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizationCodeProperties")
                .add("AuthorizationCode", authorizationCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RedirectUri", redirectUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationCode":
            return Optional.ofNullable(clazz.cast(authorizationCode()));
        case "RedirectUri":
            return Optional.ofNullable(clazz.cast(redirectUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationCodeProperties, T> g) {
        return obj -> g.apply((AuthorizationCodeProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizationCodeProperties> {
        /**
         * <p>
         * An authorization code to be used in the third leg of the <code>AUTHORIZATION_CODE</code> grant workflow. This
         * is a single-use code which becomes invalid once exchanged for an access token, thus it is acceptable to have
         * this value as a request parameter.
         * </p>
         * 
         * @param authorizationCode
         *        An authorization code to be used in the third leg of the <code>AUTHORIZATION_CODE</code> grant
         *        workflow. This is a single-use code which becomes invalid once exchanged for an access token, thus it
         *        is acceptable to have this value as a request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationCode(String authorizationCode);

        /**
         * <p>
         * The redirect URI where the user gets redirected to by authorization server when issuing an authorization
         * code. The URI is subsequently used when the authorization code is exchanged for an access token.
         * </p>
         * 
         * @param redirectUri
         *        The redirect URI where the user gets redirected to by authorization server when issuing an
         *        authorization code. The URI is subsequently used when the authorization code is exchanged for an
         *        access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectUri(String redirectUri);
    }

    static final class BuilderImpl implements Builder {
        private String authorizationCode;

        private String redirectUri;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationCodeProperties model) {
            authorizationCode(model.authorizationCode);
            redirectUri(model.redirectUri);
        }

        public final String getAuthorizationCode() {
            return authorizationCode;
        }

        public final void setAuthorizationCode(String authorizationCode) {
            this.authorizationCode = authorizationCode;
        }

        @Override
        public final Builder authorizationCode(String authorizationCode) {
            this.authorizationCode = authorizationCode;
            return this;
        }

        public final String getRedirectUri() {
            return redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        @Override
        public AuthorizationCodeProperties build() {
            return new AuthorizationCodeProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
