/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines column statistics supported for bit sequence data values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BinaryColumnStatisticsData implements SdkPojo, Serializable,
        ToCopyableBuilder<BinaryColumnStatisticsData.Builder, BinaryColumnStatisticsData> {
    private static final SdkField<Long> MAXIMUM_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaximumLength").getter(getter(BinaryColumnStatisticsData::maximumLength))
            .setter(setter(Builder::maximumLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumLength").build()).build();

    private static final SdkField<Double> AVERAGE_LENGTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AverageLength").getter(getter(BinaryColumnStatisticsData::averageLength))
            .setter(setter(Builder::averageLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageLength").build()).build();

    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfNulls").getter(getter(BinaryColumnStatisticsData::numberOfNulls))
            .setter(setter(Builder::numberOfNulls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_LENGTH_FIELD,
            AVERAGE_LENGTH_FIELD, NUMBER_OF_NULLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MaximumLength", MAXIMUM_LENGTH_FIELD);
                    put("AverageLength", AVERAGE_LENGTH_FIELD);
                    put("NumberOfNulls", NUMBER_OF_NULLS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long maximumLength;

    private final Double averageLength;

    private final Long numberOfNulls;

    private BinaryColumnStatisticsData(BuilderImpl builder) {
        this.maximumLength = builder.maximumLength;
        this.averageLength = builder.averageLength;
        this.numberOfNulls = builder.numberOfNulls;
    }

    /**
     * <p>
     * The size of the longest bit sequence in the column.
     * </p>
     * 
     * @return The size of the longest bit sequence in the column.
     */
    public final Long maximumLength() {
        return maximumLength;
    }

    /**
     * <p>
     * The average bit sequence length in the column.
     * </p>
     * 
     * @return The average bit sequence length in the column.
     */
    public final Double averageLength() {
        return averageLength;
    }

    /**
     * <p>
     * The number of null values in the column.
     * </p>
     * 
     * @return The number of null values in the column.
     */
    public final Long numberOfNulls() {
        return numberOfNulls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumLength());
        hashCode = 31 * hashCode + Objects.hashCode(averageLength());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNulls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BinaryColumnStatisticsData)) {
            return false;
        }
        BinaryColumnStatisticsData other = (BinaryColumnStatisticsData) obj;
        return Objects.equals(maximumLength(), other.maximumLength()) && Objects.equals(averageLength(), other.averageLength())
                && Objects.equals(numberOfNulls(), other.numberOfNulls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BinaryColumnStatisticsData").add("MaximumLength", maximumLength())
                .add("AverageLength", averageLength()).add("NumberOfNulls", numberOfNulls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumLength":
            return Optional.ofNullable(clazz.cast(maximumLength()));
        case "AverageLength":
            return Optional.ofNullable(clazz.cast(averageLength()));
        case "NumberOfNulls":
            return Optional.ofNullable(clazz.cast(numberOfNulls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BinaryColumnStatisticsData, T> g) {
        return obj -> g.apply((BinaryColumnStatisticsData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BinaryColumnStatisticsData> {
        /**
         * <p>
         * The size of the longest bit sequence in the column.
         * </p>
         * 
         * @param maximumLength
         *        The size of the longest bit sequence in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumLength(Long maximumLength);

        /**
         * <p>
         * The average bit sequence length in the column.
         * </p>
         * 
         * @param averageLength
         *        The average bit sequence length in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageLength(Double averageLength);

        /**
         * <p>
         * The number of null values in the column.
         * </p>
         * 
         * @param numberOfNulls
         *        The number of null values in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNulls(Long numberOfNulls);
    }

    static final class BuilderImpl implements Builder {
        private Long maximumLength;

        private Double averageLength;

        private Long numberOfNulls;

        private BuilderImpl() {
        }

        private BuilderImpl(BinaryColumnStatisticsData model) {
            maximumLength(model.maximumLength);
            averageLength(model.averageLength);
            numberOfNulls(model.numberOfNulls);
        }

        public final Long getMaximumLength() {
            return maximumLength;
        }

        public final void setMaximumLength(Long maximumLength) {
            this.maximumLength = maximumLength;
        }

        @Override
        public final Builder maximumLength(Long maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public final Double getAverageLength() {
            return averageLength;
        }

        public final void setAverageLength(Double averageLength) {
            this.averageLength = averageLength;
        }

        @Override
        public final Builder averageLength(Double averageLength) {
            this.averageLength = averageLength;
            return this;
        }

        public final Long getNumberOfNulls() {
            return numberOfNulls;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        @Override
        public BinaryColumnStatisticsData build() {
            return new BinaryColumnStatisticsData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
