/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options to configure how your data quality evaluation results are published.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DQResultsPublishingOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DQResultsPublishingOptions.Builder, DQResultsPublishingOptions> {
    private static final SdkField<String> EVALUATION_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationContext").getter(getter(DQResultsPublishingOptions::evaluationContext))
            .setter(setter(Builder::evaluationContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContext").build()).build();

    private static final SdkField<String> RESULTS_S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultsS3Prefix").getter(getter(DQResultsPublishingOptions::resultsS3Prefix))
            .setter(setter(Builder::resultsS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsS3Prefix").build()).build();

    private static final SdkField<Boolean> CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("CloudWatchMetricsEnabled")
            .getter(getter(DQResultsPublishingOptions::cloudWatchMetricsEnabled))
            .setter(setter(Builder::cloudWatchMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetricsEnabled").build())
            .build();

    private static final SdkField<Boolean> RESULTS_PUBLISHING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ResultsPublishingEnabled").getter(getter(DQResultsPublishingOptions::resultsPublishingEnabled))
            .setter(setter(Builder::resultsPublishingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsPublishingEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_CONTEXT_FIELD,
            RESULTS_S3_PREFIX_FIELD, CLOUD_WATCH_METRICS_ENABLED_FIELD, RESULTS_PUBLISHING_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EvaluationContext", EVALUATION_CONTEXT_FIELD);
                    put("ResultsS3Prefix", RESULTS_S3_PREFIX_FIELD);
                    put("CloudWatchMetricsEnabled", CLOUD_WATCH_METRICS_ENABLED_FIELD);
                    put("ResultsPublishingEnabled", RESULTS_PUBLISHING_ENABLED_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String evaluationContext;

    private final String resultsS3Prefix;

    private final Boolean cloudWatchMetricsEnabled;

    private final Boolean resultsPublishingEnabled;

    private DQResultsPublishingOptions(BuilderImpl builder) {
        this.evaluationContext = builder.evaluationContext;
        this.resultsS3Prefix = builder.resultsS3Prefix;
        this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
        this.resultsPublishingEnabled = builder.resultsPublishingEnabled;
    }

    /**
     * <p>
     * The context of the evaluation.
     * </p>
     * 
     * @return The context of the evaluation.
     */
    public final String evaluationContext() {
        return evaluationContext;
    }

    /**
     * <p>
     * The Amazon S3 prefix prepended to the results.
     * </p>
     * 
     * @return The Amazon S3 prefix prepended to the results.
     */
    public final String resultsS3Prefix() {
        return resultsS3Prefix;
    }

    /**
     * <p>
     * Enable metrics for your data quality results.
     * </p>
     * 
     * @return Enable metrics for your data quality results.
     */
    public final Boolean cloudWatchMetricsEnabled() {
        return cloudWatchMetricsEnabled;
    }

    /**
     * <p>
     * Enable publishing for your data quality results.
     * </p>
     * 
     * @return Enable publishing for your data quality results.
     */
    public final Boolean resultsPublishingEnabled() {
        return resultsPublishingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(resultsS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(resultsPublishingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DQResultsPublishingOptions)) {
            return false;
        }
        DQResultsPublishingOptions other = (DQResultsPublishingOptions) obj;
        return Objects.equals(evaluationContext(), other.evaluationContext())
                && Objects.equals(resultsS3Prefix(), other.resultsS3Prefix())
                && Objects.equals(cloudWatchMetricsEnabled(), other.cloudWatchMetricsEnabled())
                && Objects.equals(resultsPublishingEnabled(), other.resultsPublishingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DQResultsPublishingOptions").add("EvaluationContext", evaluationContext())
                .add("ResultsS3Prefix", resultsS3Prefix()).add("CloudWatchMetricsEnabled", cloudWatchMetricsEnabled())
                .add("ResultsPublishingEnabled", resultsPublishingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationContext":
            return Optional.ofNullable(clazz.cast(evaluationContext()));
        case "ResultsS3Prefix":
            return Optional.ofNullable(clazz.cast(resultsS3Prefix()));
        case "CloudWatchMetricsEnabled":
            return Optional.ofNullable(clazz.cast(cloudWatchMetricsEnabled()));
        case "ResultsPublishingEnabled":
            return Optional.ofNullable(clazz.cast(resultsPublishingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DQResultsPublishingOptions, T> g) {
        return obj -> g.apply((DQResultsPublishingOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DQResultsPublishingOptions> {
        /**
         * <p>
         * The context of the evaluation.
         * </p>
         * 
         * @param evaluationContext
         *        The context of the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationContext(String evaluationContext);

        /**
         * <p>
         * The Amazon S3 prefix prepended to the results.
         * </p>
         * 
         * @param resultsS3Prefix
         *        The Amazon S3 prefix prepended to the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsS3Prefix(String resultsS3Prefix);

        /**
         * <p>
         * Enable metrics for your data quality results.
         * </p>
         * 
         * @param cloudWatchMetricsEnabled
         *        Enable metrics for your data quality results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled);

        /**
         * <p>
         * Enable publishing for your data quality results.
         * </p>
         * 
         * @param resultsPublishingEnabled
         *        Enable publishing for your data quality results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsPublishingEnabled(Boolean resultsPublishingEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationContext;

        private String resultsS3Prefix;

        private Boolean cloudWatchMetricsEnabled;

        private Boolean resultsPublishingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DQResultsPublishingOptions model) {
            evaluationContext(model.evaluationContext);
            resultsS3Prefix(model.resultsS3Prefix);
            cloudWatchMetricsEnabled(model.cloudWatchMetricsEnabled);
            resultsPublishingEnabled(model.resultsPublishingEnabled);
        }

        public final String getEvaluationContext() {
            return evaluationContext;
        }

        public final void setEvaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        public final Builder evaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final String getResultsS3Prefix() {
            return resultsS3Prefix;
        }

        public final void setResultsS3Prefix(String resultsS3Prefix) {
            this.resultsS3Prefix = resultsS3Prefix;
        }

        @Override
        public final Builder resultsS3Prefix(String resultsS3Prefix) {
            this.resultsS3Prefix = resultsS3Prefix;
            return this;
        }

        public final Boolean getCloudWatchMetricsEnabled() {
            return cloudWatchMetricsEnabled;
        }

        public final void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        }

        @Override
        public final Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        public final Boolean getResultsPublishingEnabled() {
            return resultsPublishingEnabled;
        }

        public final void setResultsPublishingEnabled(Boolean resultsPublishingEnabled) {
            this.resultsPublishingEnabled = resultsPublishingEnabled;
        }

        @Override
        public final Builder resultsPublishingEnabled(Boolean resultsPublishingEnabled) {
            this.resultsPublishingEnabled = resultsPublishingEnabled;
            return this;
        }

        @Override
        public DQResultsPublishingOptions build() {
            return new DQResultsPublishingOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
