/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional run options you can specify for an evaluation run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityEvaluationRunAdditionalRunOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityEvaluationRunAdditionalRunOptions.Builder, DataQualityEvaluationRunAdditionalRunOptions> {
    private static final SdkField<Boolean> CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("CloudWatchMetricsEnabled")
            .getter(getter(DataQualityEvaluationRunAdditionalRunOptions::cloudWatchMetricsEnabled))
            .setter(setter(Builder::cloudWatchMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetricsEnabled").build())
            .build();

    private static final SdkField<String> RESULTS_S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultsS3Prefix").getter(getter(DataQualityEvaluationRunAdditionalRunOptions::resultsS3Prefix))
            .setter(setter(Builder::resultsS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsS3Prefix").build()).build();

    private static final SdkField<String> COMPOSITE_RULE_EVALUATION_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CompositeRuleEvaluationMethod")
            .getter(getter(DataQualityEvaluationRunAdditionalRunOptions::compositeRuleEvaluationMethodAsString))
            .setter(setter(Builder::compositeRuleEvaluationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeRuleEvaluationMethod")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_METRICS_ENABLED_FIELD, RESULTS_S3_PREFIX_FIELD, COMPOSITE_RULE_EVALUATION_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CloudWatchMetricsEnabled", CLOUD_WATCH_METRICS_ENABLED_FIELD);
                    put("ResultsS3Prefix", RESULTS_S3_PREFIX_FIELD);
                    put("CompositeRuleEvaluationMethod", COMPOSITE_RULE_EVALUATION_METHOD_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean cloudWatchMetricsEnabled;

    private final String resultsS3Prefix;

    private final String compositeRuleEvaluationMethod;

    private DataQualityEvaluationRunAdditionalRunOptions(BuilderImpl builder) {
        this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
        this.resultsS3Prefix = builder.resultsS3Prefix;
        this.compositeRuleEvaluationMethod = builder.compositeRuleEvaluationMethod;
    }

    /**
     * <p>
     * Whether or not to enable CloudWatch metrics.
     * </p>
     * 
     * @return Whether or not to enable CloudWatch metrics.
     */
    public final Boolean cloudWatchMetricsEnabled() {
        return cloudWatchMetricsEnabled;
    }

    /**
     * <p>
     * Prefix for Amazon S3 to store results.
     * </p>
     * 
     * @return Prefix for Amazon S3 to store results.
     */
    public final String resultsS3Prefix() {
        return resultsS3Prefix;
    }

    /**
     * <p>
     * Set the evaluation method for composite rules in the ruleset to ROW/COLUMN
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compositeRuleEvaluationMethod} will return {@link DQCompositeRuleEvaluationMethod#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #compositeRuleEvaluationMethodAsString}.
     * </p>
     * 
     * @return Set the evaluation method for composite rules in the ruleset to ROW/COLUMN
     * @see DQCompositeRuleEvaluationMethod
     */
    public final DQCompositeRuleEvaluationMethod compositeRuleEvaluationMethod() {
        return DQCompositeRuleEvaluationMethod.fromValue(compositeRuleEvaluationMethod);
    }

    /**
     * <p>
     * Set the evaluation method for composite rules in the ruleset to ROW/COLUMN
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compositeRuleEvaluationMethod} will return {@link DQCompositeRuleEvaluationMethod#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #compositeRuleEvaluationMethodAsString}.
     * </p>
     * 
     * @return Set the evaluation method for composite rules in the ruleset to ROW/COLUMN
     * @see DQCompositeRuleEvaluationMethod
     */
    public final String compositeRuleEvaluationMethodAsString() {
        return compositeRuleEvaluationMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(resultsS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(compositeRuleEvaluationMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityEvaluationRunAdditionalRunOptions)) {
            return false;
        }
        DataQualityEvaluationRunAdditionalRunOptions other = (DataQualityEvaluationRunAdditionalRunOptions) obj;
        return Objects.equals(cloudWatchMetricsEnabled(), other.cloudWatchMetricsEnabled())
                && Objects.equals(resultsS3Prefix(), other.resultsS3Prefix())
                && Objects.equals(compositeRuleEvaluationMethodAsString(), other.compositeRuleEvaluationMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityEvaluationRunAdditionalRunOptions")
                .add("CloudWatchMetricsEnabled", cloudWatchMetricsEnabled()).add("ResultsS3Prefix", resultsS3Prefix())
                .add("CompositeRuleEvaluationMethod", compositeRuleEvaluationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchMetricsEnabled":
            return Optional.ofNullable(clazz.cast(cloudWatchMetricsEnabled()));
        case "ResultsS3Prefix":
            return Optional.ofNullable(clazz.cast(resultsS3Prefix()));
        case "CompositeRuleEvaluationMethod":
            return Optional.ofNullable(clazz.cast(compositeRuleEvaluationMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityEvaluationRunAdditionalRunOptions, T> g) {
        return obj -> g.apply((DataQualityEvaluationRunAdditionalRunOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityEvaluationRunAdditionalRunOptions> {
        /**
         * <p>
         * Whether or not to enable CloudWatch metrics.
         * </p>
         * 
         * @param cloudWatchMetricsEnabled
         *        Whether or not to enable CloudWatch metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled);

        /**
         * <p>
         * Prefix for Amazon S3 to store results.
         * </p>
         * 
         * @param resultsS3Prefix
         *        Prefix for Amazon S3 to store results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsS3Prefix(String resultsS3Prefix);

        /**
         * <p>
         * Set the evaluation method for composite rules in the ruleset to ROW/COLUMN
         * </p>
         * 
         * @param compositeRuleEvaluationMethod
         *        Set the evaluation method for composite rules in the ruleset to ROW/COLUMN
         * @see DQCompositeRuleEvaluationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DQCompositeRuleEvaluationMethod
         */
        Builder compositeRuleEvaluationMethod(String compositeRuleEvaluationMethod);

        /**
         * <p>
         * Set the evaluation method for composite rules in the ruleset to ROW/COLUMN
         * </p>
         * 
         * @param compositeRuleEvaluationMethod
         *        Set the evaluation method for composite rules in the ruleset to ROW/COLUMN
         * @see DQCompositeRuleEvaluationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DQCompositeRuleEvaluationMethod
         */
        Builder compositeRuleEvaluationMethod(DQCompositeRuleEvaluationMethod compositeRuleEvaluationMethod);
    }

    static final class BuilderImpl implements Builder {
        private Boolean cloudWatchMetricsEnabled;

        private String resultsS3Prefix;

        private String compositeRuleEvaluationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityEvaluationRunAdditionalRunOptions model) {
            cloudWatchMetricsEnabled(model.cloudWatchMetricsEnabled);
            resultsS3Prefix(model.resultsS3Prefix);
            compositeRuleEvaluationMethod(model.compositeRuleEvaluationMethod);
        }

        public final Boolean getCloudWatchMetricsEnabled() {
            return cloudWatchMetricsEnabled;
        }

        public final void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        }

        @Override
        public final Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        public final String getResultsS3Prefix() {
            return resultsS3Prefix;
        }

        public final void setResultsS3Prefix(String resultsS3Prefix) {
            this.resultsS3Prefix = resultsS3Prefix;
        }

        @Override
        public final Builder resultsS3Prefix(String resultsS3Prefix) {
            this.resultsS3Prefix = resultsS3Prefix;
            return this;
        }

        public final String getCompositeRuleEvaluationMethod() {
            return compositeRuleEvaluationMethod;
        }

        public final void setCompositeRuleEvaluationMethod(String compositeRuleEvaluationMethod) {
            this.compositeRuleEvaluationMethod = compositeRuleEvaluationMethod;
        }

        @Override
        public final Builder compositeRuleEvaluationMethod(String compositeRuleEvaluationMethod) {
            this.compositeRuleEvaluationMethod = compositeRuleEvaluationMethod;
            return this;
        }

        @Override
        public final Builder compositeRuleEvaluationMethod(DQCompositeRuleEvaluationMethod compositeRuleEvaluationMethod) {
            this.compositeRuleEvaluationMethod(compositeRuleEvaluationMethod == null ? null : compositeRuleEvaluationMethod
                    .toString());
            return this;
        }

        @Override
        public DataQualityEvaluationRunAdditionalRunOptions build() {
            return new DataQualityEvaluationRunAdditionalRunOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
