/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure used to create or update a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseInput implements SdkPojo, Serializable, ToCopyableBuilder<DatabaseInput.Builder, DatabaseInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DatabaseInput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DatabaseInput::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(DatabaseInput::locationUri)).setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(DatabaseInput::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<PrincipalPermissions>> CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalPermissions>> builder(MarshallingType.LIST)
            .memberName("CreateTableDefaultPermissions")
            .getter(getter(DatabaseInput::createTableDefaultPermissions))
            .setter(setter(Builder::createTableDefaultPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTableDefaultPermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalPermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalPermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DatabaseIdentifier> TARGET_DATABASE_FIELD = SdkField
            .<DatabaseIdentifier> builder(MarshallingType.SDK_POJO).memberName("TargetDatabase")
            .getter(getter(DatabaseInput::targetDatabase)).setter(setter(Builder::targetDatabase))
            .constructor(DatabaseIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDatabase").build()).build();

    private static final SdkField<FederatedDatabase> FEDERATED_DATABASE_FIELD = SdkField
            .<FederatedDatabase> builder(MarshallingType.SDK_POJO).memberName("FederatedDatabase")
            .getter(getter(DatabaseInput::federatedDatabase)).setter(setter(Builder::federatedDatabase))
            .constructor(FederatedDatabase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederatedDatabase").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            LOCATION_URI_FIELD, PARAMETERS_FIELD, CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD, TARGET_DATABASE_FIELD,
            FEDERATED_DATABASE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("LocationUri", LOCATION_URI_FIELD);
                    put("Parameters", PARAMETERS_FIELD);
                    put("CreateTableDefaultPermissions", CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD);
                    put("TargetDatabase", TARGET_DATABASE_FIELD);
                    put("FederatedDatabase", FEDERATED_DATABASE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String locationUri;

    private final Map<String, String> parameters;

    private final List<PrincipalPermissions> createTableDefaultPermissions;

    private final DatabaseIdentifier targetDatabase;

    private final FederatedDatabase federatedDatabase;

    private DatabaseInput(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.locationUri = builder.locationUri;
        this.parameters = builder.parameters;
        this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
        this.targetDatabase = builder.targetDatabase;
        this.federatedDatabase = builder.federatedDatabase;
    }

    /**
     * <p>
     * The name of the database. For Hive compatibility, this is folded to lowercase when it is stored.
     * </p>
     * 
     * @return The name of the database. For Hive compatibility, this is folded to lowercase when it is stored.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the database.
     * </p>
     * 
     * @return A description of the database.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The location of the database (for example, an HDFS path).
     * </p>
     * 
     * @return The location of the database (for example, an HDFS path).
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * These key-value pairs define parameters and properties of the database.
     * </p>
     * <p>
     * These key-value pairs define parameters and properties of the database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return These key-value pairs define parameters and properties of the database.</p>
     *         <p>
     *         These key-value pairs define parameters and properties of the database.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreateTableDefaultPermissions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCreateTableDefaultPermissions() {
        return createTableDefaultPermissions != null && !(createTableDefaultPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Creates a set of default permissions on the table for principals. Used by Lake Formation. Not used in the normal
     * course of Glue operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreateTableDefaultPermissions} method.
     * </p>
     * 
     * @return Creates a set of default permissions on the table for principals. Used by Lake Formation. Not used in the
     *         normal course of Glue operations.
     */
    public final List<PrincipalPermissions> createTableDefaultPermissions() {
        return createTableDefaultPermissions;
    }

    /**
     * <p>
     * A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.
     * </p>
     * 
     * @return A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.
     */
    public final DatabaseIdentifier targetDatabase() {
        return targetDatabase;
    }

    /**
     * <p>
     * A <code>FederatedDatabase</code> structure that references an entity outside the Glue Data Catalog.
     * </p>
     * 
     * @return A <code>FederatedDatabase</code> structure that references an entity outside the Glue Data Catalog.
     */
    public final FederatedDatabase federatedDatabase() {
        return federatedDatabase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCreateTableDefaultPermissions() ? createTableDefaultPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(federatedDatabase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseInput)) {
            return false;
        }
        DatabaseInput other = (DatabaseInput) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(locationUri(), other.locationUri()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters())
                && hasCreateTableDefaultPermissions() == other.hasCreateTableDefaultPermissions()
                && Objects.equals(createTableDefaultPermissions(), other.createTableDefaultPermissions())
                && Objects.equals(targetDatabase(), other.targetDatabase())
                && Objects.equals(federatedDatabase(), other.federatedDatabase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DatabaseInput")
                .add("Name", name())
                .add("Description", description())
                .add("LocationUri", locationUri())
                .add("Parameters", hasParameters() ? parameters() : null)
                .add("CreateTableDefaultPermissions", hasCreateTableDefaultPermissions() ? createTableDefaultPermissions() : null)
                .add("TargetDatabase", targetDatabase()).add("FederatedDatabase", federatedDatabase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "CreateTableDefaultPermissions":
            return Optional.ofNullable(clazz.cast(createTableDefaultPermissions()));
        case "TargetDatabase":
            return Optional.ofNullable(clazz.cast(targetDatabase()));
        case "FederatedDatabase":
            return Optional.ofNullable(clazz.cast(federatedDatabase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseInput, T> g) {
        return obj -> g.apply((DatabaseInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseInput> {
        /**
         * <p>
         * The name of the database. For Hive compatibility, this is folded to lowercase when it is stored.
         * </p>
         * 
         * @param name
         *        The name of the database. For Hive compatibility, this is folded to lowercase when it is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the database.
         * </p>
         * 
         * @param description
         *        A description of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The location of the database (for example, an HDFS path).
         * </p>
         * 
         * @param locationUri
         *        The location of the database (for example, an HDFS path).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * These key-value pairs define parameters and properties of the database.
         * </p>
         * <p>
         * These key-value pairs define parameters and properties of the database.
         * </p>
         * 
         * @param parameters
         *        These key-value pairs define parameters and properties of the database.</p>
         *        <p>
         *        These key-value pairs define parameters and properties of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * Creates a set of default permissions on the table for principals. Used by Lake Formation. Not used in the
         * normal course of Glue operations.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        Creates a set of default permissions on the table for principals. Used by Lake Formation. Not used in
         *        the normal course of Glue operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions);

        /**
         * <p>
         * Creates a set of default permissions on the table for principals. Used by Lake Formation. Not used in the
         * normal course of Glue operations.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        Creates a set of default permissions on the table for principals. Used by Lake Formation. Not used in
         *        the normal course of Glue operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions);

        /**
         * <p>
         * Creates a set of default permissions on the table for principals. Used by Lake Formation. Not used in the
         * normal course of Glue operations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions.Builder#build()} is called immediately
         * and its result is passed to {@link #createTableDefaultPermissions(List<PrincipalPermissions>)}.
         * 
         * @param createTableDefaultPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.PrincipalPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createTableDefaultPermissions(java.util.Collection<PrincipalPermissions>)
         */
        Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions);

        /**
         * <p>
         * A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.
         * </p>
         * 
         * @param targetDatabase
         *        A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabase(DatabaseIdentifier targetDatabase);

        /**
         * <p>
         * A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatabaseIdentifier.Builder} avoiding the
         * need to create one manually via {@link DatabaseIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabaseIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #targetDatabase(DatabaseIdentifier)}.
         * 
         * @param targetDatabase
         *        a consumer that will call methods on {@link DatabaseIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetDatabase(DatabaseIdentifier)
         */
        default Builder targetDatabase(Consumer<DatabaseIdentifier.Builder> targetDatabase) {
            return targetDatabase(DatabaseIdentifier.builder().applyMutation(targetDatabase).build());
        }

        /**
         * <p>
         * A <code>FederatedDatabase</code> structure that references an entity outside the Glue Data Catalog.
         * </p>
         * 
         * @param federatedDatabase
         *        A <code>FederatedDatabase</code> structure that references an entity outside the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federatedDatabase(FederatedDatabase federatedDatabase);

        /**
         * <p>
         * A <code>FederatedDatabase</code> structure that references an entity outside the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link FederatedDatabase.Builder} avoiding the
         * need to create one manually via {@link FederatedDatabase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FederatedDatabase.Builder#build()} is called immediately and its
         * result is passed to {@link #federatedDatabase(FederatedDatabase)}.
         * 
         * @param federatedDatabase
         *        a consumer that will call methods on {@link FederatedDatabase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #federatedDatabase(FederatedDatabase)
         */
        default Builder federatedDatabase(Consumer<FederatedDatabase.Builder> federatedDatabase) {
            return federatedDatabase(FederatedDatabase.builder().applyMutation(federatedDatabase).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String locationUri;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private List<PrincipalPermissions> createTableDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private DatabaseIdentifier targetDatabase;

        private FederatedDatabase federatedDatabase;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseInput model) {
            name(model.name);
            description(model.description);
            locationUri(model.locationUri);
            parameters(model.parameters);
            createTableDefaultPermissions(model.createTableDefaultPermissions);
            targetDatabase(model.targetDatabase);
            federatedDatabase(model.federatedDatabase);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateTableDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier
                    .copyToBuilder(this.createTableDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateTableDefaultPermissions(
                Collection<PrincipalPermissions.BuilderImpl> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createTableDefaultPermissions);
        }

        @Override
        public final Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copy(createTableDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions) {
            createTableDefaultPermissions(Arrays.asList(createTableDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(
                Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions) {
            createTableDefaultPermissions(Stream.of(createTableDefaultPermissions)
                    .map(c -> PrincipalPermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DatabaseIdentifier.Builder getTargetDatabase() {
            return targetDatabase != null ? targetDatabase.toBuilder() : null;
        }

        public final void setTargetDatabase(DatabaseIdentifier.BuilderImpl targetDatabase) {
            this.targetDatabase = targetDatabase != null ? targetDatabase.build() : null;
        }

        @Override
        public final Builder targetDatabase(DatabaseIdentifier targetDatabase) {
            this.targetDatabase = targetDatabase;
            return this;
        }

        public final FederatedDatabase.Builder getFederatedDatabase() {
            return federatedDatabase != null ? federatedDatabase.toBuilder() : null;
        }

        public final void setFederatedDatabase(FederatedDatabase.BuilderImpl federatedDatabase) {
            this.federatedDatabase = federatedDatabase != null ? federatedDatabase.build() : null;
        }

        @Override
        public final Builder federatedDatabase(FederatedDatabase federatedDatabase) {
            this.federatedDatabase = federatedDatabase;
            return this;
        }

        @Override
        public DatabaseInput build() {
            return new DatabaseInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
