/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataQualityStatisticAnnotationsResponse extends GlueResponse implements
        ToCopyableBuilder<ListDataQualityStatisticAnnotationsResponse.Builder, ListDataQualityStatisticAnnotationsResponse> {
    private static final SdkField<List<StatisticAnnotation>> ANNOTATIONS_FIELD = SdkField
            .<List<StatisticAnnotation>> builder(MarshallingType.LIST)
            .memberName("Annotations")
            .getter(getter(ListDataQualityStatisticAnnotationsResponse::annotations))
            .setter(setter(Builder::annotations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatisticAnnotation> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatisticAnnotation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDataQualityStatisticAnnotationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Annotations", ANNOTATIONS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<StatisticAnnotation> annotations;

    private final String nextToken;

    private ListDataQualityStatisticAnnotationsResponse(BuilderImpl builder) {
        super(builder);
        this.annotations = builder.annotations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Annotations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnnotations() {
        return annotations != null && !(annotations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>StatisticAnnotation</code> applied to the Statistic
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnnotations} method.
     * </p>
     * 
     * @return A list of <code>StatisticAnnotation</code> applied to the Statistic
     */
    public final List<StatisticAnnotation> annotations() {
        return annotations;
    }

    /**
     * <p>
     * A pagination token to retrieve the next set of results.
     * </p>
     * 
     * @return A pagination token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnnotations() ? annotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataQualityStatisticAnnotationsResponse)) {
            return false;
        }
        ListDataQualityStatisticAnnotationsResponse other = (ListDataQualityStatisticAnnotationsResponse) obj;
        return hasAnnotations() == other.hasAnnotations() && Objects.equals(annotations(), other.annotations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataQualityStatisticAnnotationsResponse")
                .add("Annotations", hasAnnotations() ? annotations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Annotations":
            return Optional.ofNullable(clazz.cast(annotations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDataQualityStatisticAnnotationsResponse, T> g) {
        return obj -> g.apply((ListDataQualityStatisticAnnotationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataQualityStatisticAnnotationsResponse> {
        /**
         * <p>
         * A list of <code>StatisticAnnotation</code> applied to the Statistic
         * </p>
         * 
         * @param annotations
         *        A list of <code>StatisticAnnotation</code> applied to the Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(Collection<StatisticAnnotation> annotations);

        /**
         * <p>
         * A list of <code>StatisticAnnotation</code> applied to the Statistic
         * </p>
         * 
         * @param annotations
         *        A list of <code>StatisticAnnotation</code> applied to the Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(StatisticAnnotation... annotations);

        /**
         * <p>
         * A list of <code>StatisticAnnotation</code> applied to the Statistic
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.StatisticAnnotation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.StatisticAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.StatisticAnnotation.Builder#build()} is called immediately
         * and its result is passed to {@link #annotations(List<StatisticAnnotation>)}.
         * 
         * @param annotations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.StatisticAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotations(java.util.Collection<StatisticAnnotation>)
         */
        Builder annotations(Consumer<StatisticAnnotation.Builder>... annotations);

        /**
         * <p>
         * A pagination token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<StatisticAnnotation> annotations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataQualityStatisticAnnotationsResponse model) {
            super(model);
            annotations(model.annotations);
            nextToken(model.nextToken);
        }

        public final List<StatisticAnnotation.Builder> getAnnotations() {
            List<StatisticAnnotation.Builder> result = AnnotationListCopier.copyToBuilder(this.annotations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotations(Collection<StatisticAnnotation.BuilderImpl> annotations) {
            this.annotations = AnnotationListCopier.copyFromBuilder(annotations);
        }

        @Override
        public final Builder annotations(Collection<StatisticAnnotation> annotations) {
            this.annotations = AnnotationListCopier.copy(annotations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(StatisticAnnotation... annotations) {
            annotations(Arrays.asList(annotations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(Consumer<StatisticAnnotation.Builder>... annotations) {
            annotations(Stream.of(annotations).map(c -> StatisticAnnotation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataQualityStatisticAnnotationsResponse build() {
            return new ListDataQualityStatisticAnnotationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
