/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResumeWorkflowRunResponse extends GlueResponse implements
        ToCopyableBuilder<ResumeWorkflowRunResponse.Builder, ResumeWorkflowRunResponse> {
    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(ResumeWorkflowRunResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<List<String>> NODE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NodeIds")
            .getter(getter(ResumeWorkflowRunResponse::nodeIds))
            .setter(setter(Builder::nodeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_ID_FIELD, NODE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("RunId", RUN_ID_FIELD);
                    put("NodeIds", NODE_IDS_FIELD);
                }
            });

    private final String runId;

    private final List<String> nodeIds;

    private ResumeWorkflowRunResponse(BuilderImpl builder) {
        super(builder);
        this.runId = builder.runId;
        this.nodeIds = builder.nodeIds;
    }

    /**
     * <p>
     * The new ID assigned to the resumed workflow run. Each resume of a workflow run will have a new run ID.
     * </p>
     * 
     * @return The new ID assigned to the resumed workflow run. Each resume of a workflow run will have a new run ID.
     */
    public final String runId() {
        return runId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNodeIds() {
        return nodeIds != null && !(nodeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the node IDs for the nodes that were actually restarted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeIds} method.
     * </p>
     * 
     * @return A list of the node IDs for the nodes that were actually restarted.
     */
    public final List<String> nodeIds() {
        return nodeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeIds() ? nodeIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResumeWorkflowRunResponse)) {
            return false;
        }
        ResumeWorkflowRunResponse other = (ResumeWorkflowRunResponse) obj;
        return Objects.equals(runId(), other.runId()) && hasNodeIds() == other.hasNodeIds()
                && Objects.equals(nodeIds(), other.nodeIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResumeWorkflowRunResponse").add("RunId", runId())
                .add("NodeIds", hasNodeIds() ? nodeIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "NodeIds":
            return Optional.ofNullable(clazz.cast(nodeIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResumeWorkflowRunResponse, T> g) {
        return obj -> g.apply((ResumeWorkflowRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ResumeWorkflowRunResponse> {
        /**
         * <p>
         * The new ID assigned to the resumed workflow run. Each resume of a workflow run will have a new run ID.
         * </p>
         * 
         * @param runId
         *        The new ID assigned to the resumed workflow run. Each resume of a workflow run will have a new run ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * A list of the node IDs for the nodes that were actually restarted.
         * </p>
         * 
         * @param nodeIds
         *        A list of the node IDs for the nodes that were actually restarted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIds(Collection<String> nodeIds);

        /**
         * <p>
         * A list of the node IDs for the nodes that were actually restarted.
         * </p>
         * 
         * @param nodeIds
         *        A list of the node IDs for the nodes that were actually restarted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIds(String... nodeIds);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String runId;

        private List<String> nodeIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResumeWorkflowRunResponse model) {
            super(model);
            runId(model.runId);
            nodeIds(model.nodeIds);
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final Collection<String> getNodeIds() {
            if (nodeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return nodeIds;
        }

        public final void setNodeIds(Collection<String> nodeIds) {
            this.nodeIds = NodeIdListCopier.copy(nodeIds);
        }

        @Override
        public final Builder nodeIds(Collection<String> nodeIds) {
            this.nodeIds = NodeIdListCopier.copy(nodeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIds(String... nodeIds) {
            nodeIds(Arrays.asList(nodeIds));
            return this;
        }

        @Override
        public ResumeWorkflowRunResponse build() {
            return new ResumeWorkflowRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
