/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform where you enter a SQL query using Spark SQL syntax to transform the data. The output is a
 * single <code>DynamicFrame</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SparkSQL implements SdkPojo, Serializable, ToCopyableBuilder<SparkSQL.Builder, SparkSQL> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SparkSQL::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(SparkSQL::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SQL_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SqlQuery").getter(getter(SparkSQL::sqlQuery)).setter(setter(Builder::sqlQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlQuery").build()).build();

    private static final SdkField<List<SqlAlias>> SQL_ALIASES_FIELD = SdkField
            .<List<SqlAlias>> builder(MarshallingType.LIST)
            .memberName("SqlAliases")
            .getter(getter(SparkSQL::sqlAliases))
            .setter(setter(Builder::sqlAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField
            .<List<GlueSchema>> builder(MarshallingType.LIST)
            .memberName("OutputSchemas")
            .getter(getter(SparkSQL::outputSchemas))
            .setter(setter(Builder::outputSchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlueSchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlueSchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            SQL_QUERY_FIELD, SQL_ALIASES_FIELD, OUTPUT_SCHEMAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Inputs", INPUTS_FIELD);
                    put("SqlQuery", SQL_QUERY_FIELD);
                    put("SqlAliases", SQL_ALIASES_FIELD);
                    put("OutputSchemas", OUTPUT_SCHEMAS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String sqlQuery;

    private final List<SqlAlias> sqlAliases;

    private final List<GlueSchema> outputSchemas;

    private SparkSQL(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.sqlQuery = builder.sqlQuery;
        this.sqlAliases = builder.sqlAliases;
        this.outputSchemas = builder.outputSchemas;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data inputs identified by their node names. You can associate a table name with each input node to use in the
     * SQL query. The name you choose must meet the Spark SQL naming restrictions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The data inputs identified by their node names. You can associate a table name with each input node to
     *         use in the SQL query. The name you choose must meet the Spark SQL naming restrictions.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * A SQL query that must use Spark SQL syntax and return a single data set.
     * </p>
     * 
     * @return A SQL query that must use Spark SQL syntax and return a single data set.
     */
    public final String sqlQuery() {
        return sqlQuery;
    }

    /**
     * For responses, this returns true if the service returned a value for the SqlAliases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSqlAliases() {
        return sqlAliases != null && !(sqlAliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of aliases. An alias allows you to specify what name to use in the SQL for a given input. For example, you
     * have a datasource named "MyDataSource". If you specify <code>From</code> as MyDataSource, and <code>Alias</code>
     * as SqlName, then in your SQL you can do:
     * </p>
     * <p>
     * <code>select * from SqlName</code>
     * </p>
     * <p>
     * and that gets data from MyDataSource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSqlAliases} method.
     * </p>
     * 
     * @return A list of aliases. An alias allows you to specify what name to use in the SQL for a given input. For
     *         example, you have a datasource named "MyDataSource". If you specify <code>From</code> as MyDataSource,
     *         and <code>Alias</code> as SqlName, then in your SQL you can do:</p>
     *         <p>
     *         <code>select * from SqlName</code>
     *         </p>
     *         <p>
     *         and that gets data from MyDataSource.
     */
    public final List<SqlAlias> sqlAliases() {
        return sqlAliases;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSchemas property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSchemas() {
        return outputSchemas != null && !(outputSchemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the data schema for the SparkSQL transform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSchemas} method.
     * </p>
     * 
     * @return Specifies the data schema for the SparkSQL transform.
     */
    public final List<GlueSchema> outputSchemas() {
        return outputSchemas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(hasSqlAliases() ? sqlAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSchemas() ? outputSchemas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkSQL)) {
            return false;
        }
        SparkSQL other = (SparkSQL) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(sqlQuery(), other.sqlQuery())
                && hasSqlAliases() == other.hasSqlAliases() && Objects.equals(sqlAliases(), other.sqlAliases())
                && hasOutputSchemas() == other.hasOutputSchemas() && Objects.equals(outputSchemas(), other.outputSchemas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SparkSQL").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("SqlQuery", sqlQuery()).add("SqlAliases", hasSqlAliases() ? sqlAliases() : null)
                .add("OutputSchemas", hasOutputSchemas() ? outputSchemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "SqlQuery":
            return Optional.ofNullable(clazz.cast(sqlQuery()));
        case "SqlAliases":
            return Optional.ofNullable(clazz.cast(sqlAliases()));
        case "OutputSchemas":
            return Optional.ofNullable(clazz.cast(outputSchemas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SparkSQL, T> g) {
        return obj -> g.apply((SparkSQL) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SparkSQL> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data inputs identified by their node names. You can associate a table name with each input node to use in
         * the SQL query. The name you choose must meet the Spark SQL naming restrictions.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names. You can associate a table name with each input node to
         *        use in the SQL query. The name you choose must meet the Spark SQL naming restrictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The data inputs identified by their node names. You can associate a table name with each input node to use in
         * the SQL query. The name you choose must meet the Spark SQL naming restrictions.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names. You can associate a table name with each input node to
         *        use in the SQL query. The name you choose must meet the Spark SQL naming restrictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * A SQL query that must use Spark SQL syntax and return a single data set.
         * </p>
         * 
         * @param sqlQuery
         *        A SQL query that must use Spark SQL syntax and return a single data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlQuery(String sqlQuery);

        /**
         * <p>
         * A list of aliases. An alias allows you to specify what name to use in the SQL for a given input. For example,
         * you have a datasource named "MyDataSource". If you specify <code>From</code> as MyDataSource, and
         * <code>Alias</code> as SqlName, then in your SQL you can do:
         * </p>
         * <p>
         * <code>select * from SqlName</code>
         * </p>
         * <p>
         * and that gets data from MyDataSource.
         * </p>
         * 
         * @param sqlAliases
         *        A list of aliases. An alias allows you to specify what name to use in the SQL for a given input. For
         *        example, you have a datasource named "MyDataSource". If you specify <code>From</code> as MyDataSource,
         *        and <code>Alias</code> as SqlName, then in your SQL you can do:</p>
         *        <p>
         *        <code>select * from SqlName</code>
         *        </p>
         *        <p>
         *        and that gets data from MyDataSource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlAliases(Collection<SqlAlias> sqlAliases);

        /**
         * <p>
         * A list of aliases. An alias allows you to specify what name to use in the SQL for a given input. For example,
         * you have a datasource named "MyDataSource". If you specify <code>From</code> as MyDataSource, and
         * <code>Alias</code> as SqlName, then in your SQL you can do:
         * </p>
         * <p>
         * <code>select * from SqlName</code>
         * </p>
         * <p>
         * and that gets data from MyDataSource.
         * </p>
         * 
         * @param sqlAliases
         *        A list of aliases. An alias allows you to specify what name to use in the SQL for a given input. For
         *        example, you have a datasource named "MyDataSource". If you specify <code>From</code> as MyDataSource,
         *        and <code>Alias</code> as SqlName, then in your SQL you can do:</p>
         *        <p>
         *        <code>select * from SqlName</code>
         *        </p>
         *        <p>
         *        and that gets data from MyDataSource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlAliases(SqlAlias... sqlAliases);

        /**
         * <p>
         * A list of aliases. An alias allows you to specify what name to use in the SQL for a given input. For example,
         * you have a datasource named "MyDataSource". If you specify <code>From</code> as MyDataSource, and
         * <code>Alias</code> as SqlName, then in your SQL you can do:
         * </p>
         * <p>
         * <code>select * from SqlName</code>
         * </p>
         * <p>
         * and that gets data from MyDataSource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.SqlAlias.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.SqlAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.SqlAlias.Builder#build()} is called immediately and its
         * result is passed to {@link #sqlAliases(List<SqlAlias>)}.
         * 
         * @param sqlAliases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.SqlAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlAliases(java.util.Collection<SqlAlias>)
         */
        Builder sqlAliases(Consumer<SqlAlias.Builder>... sqlAliases);

        /**
         * <p>
         * Specifies the data schema for the SparkSQL transform.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the SparkSQL transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(Collection<GlueSchema> outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the SparkSQL transform.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the SparkSQL transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(GlueSchema... outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the SparkSQL transform.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.GlueSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #outputSchemas(List<GlueSchema>)}.
         * 
         * @param outputSchemas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSchemas(java.util.Collection<GlueSchema>)
         */
        Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String sqlQuery;

        private List<SqlAlias> sqlAliases = DefaultSdkAutoConstructList.getInstance();

        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SparkSQL model) {
            name(model.name);
            inputs(model.inputs);
            sqlQuery(model.sqlQuery);
            sqlAliases(model.sqlAliases);
            outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = ManyInputsCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = ManyInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getSqlQuery() {
            return sqlQuery;
        }

        public final void setSqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
        }

        @Override
        public final Builder sqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
            return this;
        }

        public final List<SqlAlias.Builder> getSqlAliases() {
            List<SqlAlias.Builder> result = SqlAliasesCopier.copyToBuilder(this.sqlAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSqlAliases(Collection<SqlAlias.BuilderImpl> sqlAliases) {
            this.sqlAliases = SqlAliasesCopier.copyFromBuilder(sqlAliases);
        }

        @Override
        public final Builder sqlAliases(Collection<SqlAlias> sqlAliases) {
            this.sqlAliases = SqlAliasesCopier.copy(sqlAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlAliases(SqlAlias... sqlAliases) {
            sqlAliases(Arrays.asList(sqlAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlAliases(Consumer<SqlAlias.Builder>... sqlAliases) {
            sqlAliases(Stream.of(sqlAliases).map(c -> SqlAlias.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema... outputSchemas) {
            outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas) {
            outputSchemas(Stream.of(outputSchemas).map(c -> GlueSchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SparkSQL build() {
            return new SparkSQL(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
