/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDataQualityRuleRecommendationRunRequest extends GlueRequest implements
        ToCopyableBuilder<StartDataQualityRuleRecommendationRunRequest.Builder, StartDataQualityRuleRecommendationRunRequest> {
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(StartDataQualityRuleRecommendationRunRequest::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(StartDataQualityRuleRecommendationRunRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfWorkers").getter(getter(StartDataQualityRuleRecommendationRunRequest::numberOfWorkers))
            .setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(StartDataQualityRuleRecommendationRunRequest::timeout))
            .setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<String> CREATED_RULESET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedRulesetName").getter(getter(StartDataQualityRuleRecommendationRunRequest::createdRulesetName))
            .setter(setter(Builder::createdRulesetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedRulesetName").build())
            .build();

    private static final SdkField<String> DATA_QUALITY_SECURITY_CONFIGURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataQualitySecurityConfiguration")
            .getter(getter(StartDataQualityRuleRecommendationRunRequest::dataQualitySecurityConfiguration))
            .setter(setter(Builder::dataQualitySecurityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySecurityConfiguration")
                    .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(StartDataQualityRuleRecommendationRunRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, ROLE_FIELD,
            NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, CREATED_RULESET_NAME_FIELD, DATA_QUALITY_SECURITY_CONFIGURATION_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DataSource", DATA_SOURCE_FIELD);
                    put("Role", ROLE_FIELD);
                    put("NumberOfWorkers", NUMBER_OF_WORKERS_FIELD);
                    put("Timeout", TIMEOUT_FIELD);
                    put("CreatedRulesetName", CREATED_RULESET_NAME_FIELD);
                    put("DataQualitySecurityConfiguration", DATA_QUALITY_SECURITY_CONFIGURATION_FIELD);
                    put("ClientToken", CLIENT_TOKEN_FIELD);
                }
            });

    private final DataSource dataSource;

    private final String role;

    private final Integer numberOfWorkers;

    private final Integer timeout;

    private final String createdRulesetName;

    private final String dataQualitySecurityConfiguration;

    private final String clientToken;

    private StartDataQualityRuleRecommendationRunRequest(BuilderImpl builder) {
        super(builder);
        this.dataSource = builder.dataSource;
        this.role = builder.role;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.createdRulesetName = builder.createdRulesetName;
        this.dataQualitySecurityConfiguration = builder.dataQualitySecurityConfiguration;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The data source (Glue table) associated with this run.
     * </p>
     * 
     * @return The data source (Glue table) associated with this run.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * An IAM role supplied to encrypt the results of the run.
     * </p>
     * 
     * @return An IAM role supplied to encrypt the results of the run.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The number of <code>G.1X</code> workers to be used in the run. The default is 5.
     * </p>
     * 
     * @return The number of <code>G.1X</code> workers to be used in the run. The default is 5.
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
     * terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     * </p>
     * 
     * @return The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
     *         terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * A name for the ruleset.
     * </p>
     * 
     * @return A name for the ruleset.
     */
    public final String createdRulesetName() {
        return createdRulesetName;
    }

    /**
     * <p>
     * The name of the security configuration created with the data quality encryption option.
     * </p>
     * 
     * @return The name of the security configuration created with the data quality encryption option.
     */
    public final String dataQualitySecurityConfiguration() {
        return dataQualitySecurityConfiguration;
    }

    /**
     * <p>
     * Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or starting
     * multiple instances of the same resource.
     * </p>
     * 
     * @return Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or
     *         starting multiple instances of the same resource.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(createdRulesetName());
        hashCode = 31 * hashCode + Objects.hashCode(dataQualitySecurityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDataQualityRuleRecommendationRunRequest)) {
            return false;
        }
        StartDataQualityRuleRecommendationRunRequest other = (StartDataQualityRuleRecommendationRunRequest) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(role(), other.role())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(createdRulesetName(), other.createdRulesetName())
                && Objects.equals(dataQualitySecurityConfiguration(), other.dataQualitySecurityConfiguration())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDataQualityRuleRecommendationRunRequest").add("DataSource", dataSource())
                .add("Role", role()).add("NumberOfWorkers", numberOfWorkers()).add("Timeout", timeout())
                .add("CreatedRulesetName", createdRulesetName())
                .add("DataQualitySecurityConfiguration", dataQualitySecurityConfiguration()).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "CreatedRulesetName":
            return Optional.ofNullable(clazz.cast(createdRulesetName()));
        case "DataQualitySecurityConfiguration":
            return Optional.ofNullable(clazz.cast(dataQualitySecurityConfiguration()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartDataQualityRuleRecommendationRunRequest, T> g) {
        return obj -> g.apply((StartDataQualityRuleRecommendationRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDataQualityRuleRecommendationRunRequest> {
        /**
         * <p>
         * The data source (Glue table) associated with this run.
         * </p>
         * 
         * @param dataSource
         *        The data source (Glue table) associated with this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The data source (Glue table) associated with this run.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * An IAM role supplied to encrypt the results of the run.
         * </p>
         * 
         * @param role
         *        An IAM role supplied to encrypt the results of the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The number of <code>G.1X</code> workers to be used in the run. The default is 5.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of <code>G.1X</code> workers to be used in the run. The default is 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
         * terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
         * </p>
         * 
         * @param timeout
         *        The timeout for a run in minutes. This is the maximum time that a run can consume resources before it
         *        is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * A name for the ruleset.
         * </p>
         * 
         * @param createdRulesetName
         *        A name for the ruleset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdRulesetName(String createdRulesetName);

        /**
         * <p>
         * The name of the security configuration created with the data quality encryption option.
         * </p>
         * 
         * @param dataQualitySecurityConfiguration
         *        The name of the security configuration created with the data quality encryption option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration);

        /**
         * <p>
         * Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or
         * starting multiple instances of the same resource.
         * </p>
         * 
         * @param clientToken
         *        Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or
         *        starting multiple instances of the same resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private DataSource dataSource;

        private String role;

        private Integer numberOfWorkers;

        private Integer timeout;

        private String createdRulesetName;

        private String dataQualitySecurityConfiguration;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDataQualityRuleRecommendationRunRequest model) {
            super(model);
            dataSource(model.dataSource);
            role(model.role);
            numberOfWorkers(model.numberOfWorkers);
            timeout(model.timeout);
            createdRulesetName(model.createdRulesetName);
            dataQualitySecurityConfiguration(model.dataQualitySecurityConfiguration);
            clientToken(model.clientToken);
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final String getCreatedRulesetName() {
            return createdRulesetName;
        }

        public final void setCreatedRulesetName(String createdRulesetName) {
            this.createdRulesetName = createdRulesetName;
        }

        @Override
        public final Builder createdRulesetName(String createdRulesetName) {
            this.createdRulesetName = createdRulesetName;
            return this;
        }

        public final String getDataQualitySecurityConfiguration() {
            return dataQualitySecurityConfiguration;
        }

        public final void setDataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
        }

        @Override
        public final Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDataQualityRuleRecommendationRunRequest build() {
            return new StartDataQualityRuleRecommendationRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
