/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing information about an asynchronous change to a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatusDetails implements SdkPojo, Serializable, ToCopyableBuilder<StatusDetails.Builder, StatusDetails> {
    private static final SdkField<Table> REQUESTED_CHANGE_FIELD = SdkField.<Table> builder(MarshallingType.SDK_POJO)
            .memberName("RequestedChange").getter(getter(StatusDetails::requestedChange))
            .setter(setter(Builder::requestedChange)).constructor(Table::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedChange").build()).build();

    private static final SdkField<List<ViewValidation>> VIEW_VALIDATIONS_FIELD = SdkField
            .<List<ViewValidation>> builder(MarshallingType.LIST)
            .memberName("ViewValidations")
            .getter(getter(StatusDetails::viewValidations))
            .setter(setter(Builder::viewValidations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewValidations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ViewValidation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ViewValidation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUESTED_CHANGE_FIELD,
            VIEW_VALIDATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("RequestedChange", REQUESTED_CHANGE_FIELD);
                    put("ViewValidations", VIEW_VALIDATIONS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Table requestedChange;

    private final List<ViewValidation> viewValidations;

    private StatusDetails(BuilderImpl builder) {
        this.requestedChange = builder.requestedChange;
        this.viewValidations = builder.viewValidations;
    }

    /**
     * <p>
     * A <code>Table</code> object representing the requested changes.
     * </p>
     * 
     * @return A <code>Table</code> object representing the requested changes.
     */
    public final Table requestedChange() {
        return requestedChange;
    }

    /**
     * For responses, this returns true if the service returned a value for the ViewValidations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasViewValidations() {
        return viewValidations != null && !(viewValidations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ViewValidation</code> objects that contain information for an analytical engine to validate a
     * view.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViewValidations} method.
     * </p>
     * 
     * @return A list of <code>ViewValidation</code> objects that contain information for an analytical engine to
     *         validate a view.
     */
    public final List<ViewValidation> viewValidations() {
        return viewValidations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requestedChange());
        hashCode = 31 * hashCode + Objects.hashCode(hasViewValidations() ? viewValidations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusDetails)) {
            return false;
        }
        StatusDetails other = (StatusDetails) obj;
        return Objects.equals(requestedChange(), other.requestedChange()) && hasViewValidations() == other.hasViewValidations()
                && Objects.equals(viewValidations(), other.viewValidations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatusDetails").add("RequestedChange", requestedChange())
                .add("ViewValidations", hasViewValidations() ? viewValidations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestedChange":
            return Optional.ofNullable(clazz.cast(requestedChange()));
        case "ViewValidations":
            return Optional.ofNullable(clazz.cast(viewValidations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StatusDetails, T> g) {
        return obj -> g.apply((StatusDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatusDetails> {
        /**
         * <p>
         * A <code>Table</code> object representing the requested changes.
         * </p>
         * 
         * @param requestedChange
         *        A <code>Table</code> object representing the requested changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedChange(Table requestedChange);

        /**
         * <p>
         * A <code>Table</code> object representing the requested changes.
         * </p>
         * This is a convenience method that creates an instance of the {@link Table.Builder} avoiding the need to
         * create one manually via {@link Table#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Table.Builder#build()} is called immediately and its result is
         * passed to {@link #requestedChange(Table)}.
         * 
         * @param requestedChange
         *        a consumer that will call methods on {@link Table.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestedChange(Table)
         */
        default Builder requestedChange(Consumer<Table.Builder> requestedChange) {
            return requestedChange(Table.builder().applyMutation(requestedChange).build());
        }

        /**
         * <p>
         * A list of <code>ViewValidation</code> objects that contain information for an analytical engine to validate a
         * view.
         * </p>
         * 
         * @param viewValidations
         *        A list of <code>ViewValidation</code> objects that contain information for an analytical engine to
         *        validate a view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewValidations(Collection<ViewValidation> viewValidations);

        /**
         * <p>
         * A list of <code>ViewValidation</code> objects that contain information for an analytical engine to validate a
         * view.
         * </p>
         * 
         * @param viewValidations
         *        A list of <code>ViewValidation</code> objects that contain information for an analytical engine to
         *        validate a view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewValidations(ViewValidation... viewValidations);

        /**
         * <p>
         * A list of <code>ViewValidation</code> objects that contain information for an analytical engine to validate a
         * view.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.ViewValidation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.ViewValidation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.ViewValidation.Builder#build()} is called immediately and
         * its result is passed to {@link #viewValidations(List<ViewValidation>)}.
         * 
         * @param viewValidations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.ViewValidation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewValidations(java.util.Collection<ViewValidation>)
         */
        Builder viewValidations(Consumer<ViewValidation.Builder>... viewValidations);
    }

    static final class BuilderImpl implements Builder {
        private Table requestedChange;

        private List<ViewValidation> viewValidations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StatusDetails model) {
            requestedChange(model.requestedChange);
            viewValidations(model.viewValidations);
        }

        public final Table.Builder getRequestedChange() {
            return requestedChange != null ? requestedChange.toBuilder() : null;
        }

        public final void setRequestedChange(Table.BuilderImpl requestedChange) {
            this.requestedChange = requestedChange != null ? requestedChange.build() : null;
        }

        @Override
        public final Builder requestedChange(Table requestedChange) {
            this.requestedChange = requestedChange;
            return this;
        }

        public final List<ViewValidation.Builder> getViewValidations() {
            List<ViewValidation.Builder> result = ViewValidationListCopier.copyToBuilder(this.viewValidations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViewValidations(Collection<ViewValidation.BuilderImpl> viewValidations) {
            this.viewValidations = ViewValidationListCopier.copyFromBuilder(viewValidations);
        }

        @Override
        public final Builder viewValidations(Collection<ViewValidation> viewValidations) {
            this.viewValidations = ViewValidationListCopier.copy(viewValidations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder viewValidations(ViewValidation... viewValidations) {
            viewValidations(Arrays.asList(viewValidations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder viewValidations(Consumer<ViewValidation.Builder>... viewValidations) {
            viewValidations(Stream.of(viewValidations).map(c -> ViewValidation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StatusDetails build() {
            return new StatusDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
