/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration properties for the task run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskRunProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskRunProperties.Builder, TaskRunProperties> {
    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskType").getter(getter(TaskRunProperties::taskTypeAsString)).setter(setter(Builder::taskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskType").build()).build();

    private static final SdkField<ImportLabelsTaskRunProperties> IMPORT_LABELS_TASK_RUN_PROPERTIES_FIELD = SdkField
            .<ImportLabelsTaskRunProperties> builder(MarshallingType.SDK_POJO)
            .memberName("ImportLabelsTaskRunProperties")
            .getter(getter(TaskRunProperties::importLabelsTaskRunProperties))
            .setter(setter(Builder::importLabelsTaskRunProperties))
            .constructor(ImportLabelsTaskRunProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportLabelsTaskRunProperties")
                    .build()).build();

    private static final SdkField<ExportLabelsTaskRunProperties> EXPORT_LABELS_TASK_RUN_PROPERTIES_FIELD = SdkField
            .<ExportLabelsTaskRunProperties> builder(MarshallingType.SDK_POJO)
            .memberName("ExportLabelsTaskRunProperties")
            .getter(getter(TaskRunProperties::exportLabelsTaskRunProperties))
            .setter(setter(Builder::exportLabelsTaskRunProperties))
            .constructor(ExportLabelsTaskRunProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportLabelsTaskRunProperties")
                    .build()).build();

    private static final SdkField<LabelingSetGenerationTaskRunProperties> LABELING_SET_GENERATION_TASK_RUN_PROPERTIES_FIELD = SdkField
            .<LabelingSetGenerationTaskRunProperties> builder(MarshallingType.SDK_POJO)
            .memberName("LabelingSetGenerationTaskRunProperties")
            .getter(getter(TaskRunProperties::labelingSetGenerationTaskRunProperties))
            .setter(setter(Builder::labelingSetGenerationTaskRunProperties))
            .constructor(LabelingSetGenerationTaskRunProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LabelingSetGenerationTaskRunProperties").build()).build();

    private static final SdkField<FindMatchesTaskRunProperties> FIND_MATCHES_TASK_RUN_PROPERTIES_FIELD = SdkField
            .<FindMatchesTaskRunProperties> builder(MarshallingType.SDK_POJO)
            .memberName("FindMatchesTaskRunProperties")
            .getter(getter(TaskRunProperties::findMatchesTaskRunProperties))
            .setter(setter(Builder::findMatchesTaskRunProperties))
            .constructor(FindMatchesTaskRunProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindMatchesTaskRunProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TYPE_FIELD,
            IMPORT_LABELS_TASK_RUN_PROPERTIES_FIELD, EXPORT_LABELS_TASK_RUN_PROPERTIES_FIELD,
            LABELING_SET_GENERATION_TASK_RUN_PROPERTIES_FIELD, FIND_MATCHES_TASK_RUN_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TaskType", TASK_TYPE_FIELD);
                    put("ImportLabelsTaskRunProperties", IMPORT_LABELS_TASK_RUN_PROPERTIES_FIELD);
                    put("ExportLabelsTaskRunProperties", EXPORT_LABELS_TASK_RUN_PROPERTIES_FIELD);
                    put("LabelingSetGenerationTaskRunProperties", LABELING_SET_GENERATION_TASK_RUN_PROPERTIES_FIELD);
                    put("FindMatchesTaskRunProperties", FIND_MATCHES_TASK_RUN_PROPERTIES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String taskType;

    private final ImportLabelsTaskRunProperties importLabelsTaskRunProperties;

    private final ExportLabelsTaskRunProperties exportLabelsTaskRunProperties;

    private final LabelingSetGenerationTaskRunProperties labelingSetGenerationTaskRunProperties;

    private final FindMatchesTaskRunProperties findMatchesTaskRunProperties;

    private TaskRunProperties(BuilderImpl builder) {
        this.taskType = builder.taskType;
        this.importLabelsTaskRunProperties = builder.importLabelsTaskRunProperties;
        this.exportLabelsTaskRunProperties = builder.exportLabelsTaskRunProperties;
        this.labelingSetGenerationTaskRunProperties = builder.labelingSetGenerationTaskRunProperties;
        this.findMatchesTaskRunProperties = builder.findMatchesTaskRunProperties;
    }

    /**
     * <p>
     * The type of task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link TaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskTypeAsString}.
     * </p>
     * 
     * @return The type of task run.
     * @see TaskType
     */
    public final TaskType taskType() {
        return TaskType.fromValue(taskType);
    }

    /**
     * <p>
     * The type of task run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link TaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskTypeAsString}.
     * </p>
     * 
     * @return The type of task run.
     * @see TaskType
     */
    public final String taskTypeAsString() {
        return taskType;
    }

    /**
     * <p>
     * The configuration properties for an importing labels task run.
     * </p>
     * 
     * @return The configuration properties for an importing labels task run.
     */
    public final ImportLabelsTaskRunProperties importLabelsTaskRunProperties() {
        return importLabelsTaskRunProperties;
    }

    /**
     * <p>
     * The configuration properties for an exporting labels task run.
     * </p>
     * 
     * @return The configuration properties for an exporting labels task run.
     */
    public final ExportLabelsTaskRunProperties exportLabelsTaskRunProperties() {
        return exportLabelsTaskRunProperties;
    }

    /**
     * <p>
     * The configuration properties for a labeling set generation task run.
     * </p>
     * 
     * @return The configuration properties for a labeling set generation task run.
     */
    public final LabelingSetGenerationTaskRunProperties labelingSetGenerationTaskRunProperties() {
        return labelingSetGenerationTaskRunProperties;
    }

    /**
     * <p>
     * The configuration properties for a find matches task run.
     * </p>
     * 
     * @return The configuration properties for a find matches task run.
     */
    public final FindMatchesTaskRunProperties findMatchesTaskRunProperties() {
        return findMatchesTaskRunProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(importLabelsTaskRunProperties());
        hashCode = 31 * hashCode + Objects.hashCode(exportLabelsTaskRunProperties());
        hashCode = 31 * hashCode + Objects.hashCode(labelingSetGenerationTaskRunProperties());
        hashCode = 31 * hashCode + Objects.hashCode(findMatchesTaskRunProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskRunProperties)) {
            return false;
        }
        TaskRunProperties other = (TaskRunProperties) obj;
        return Objects.equals(taskTypeAsString(), other.taskTypeAsString())
                && Objects.equals(importLabelsTaskRunProperties(), other.importLabelsTaskRunProperties())
                && Objects.equals(exportLabelsTaskRunProperties(), other.exportLabelsTaskRunProperties())
                && Objects.equals(labelingSetGenerationTaskRunProperties(), other.labelingSetGenerationTaskRunProperties())
                && Objects.equals(findMatchesTaskRunProperties(), other.findMatchesTaskRunProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskRunProperties").add("TaskType", taskTypeAsString())
                .add("ImportLabelsTaskRunProperties", importLabelsTaskRunProperties())
                .add("ExportLabelsTaskRunProperties", exportLabelsTaskRunProperties())
                .add("LabelingSetGenerationTaskRunProperties", labelingSetGenerationTaskRunProperties())
                .add("FindMatchesTaskRunProperties", findMatchesTaskRunProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskType":
            return Optional.ofNullable(clazz.cast(taskTypeAsString()));
        case "ImportLabelsTaskRunProperties":
            return Optional.ofNullable(clazz.cast(importLabelsTaskRunProperties()));
        case "ExportLabelsTaskRunProperties":
            return Optional.ofNullable(clazz.cast(exportLabelsTaskRunProperties()));
        case "LabelingSetGenerationTaskRunProperties":
            return Optional.ofNullable(clazz.cast(labelingSetGenerationTaskRunProperties()));
        case "FindMatchesTaskRunProperties":
            return Optional.ofNullable(clazz.cast(findMatchesTaskRunProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TaskRunProperties, T> g) {
        return obj -> g.apply((TaskRunProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskRunProperties> {
        /**
         * <p>
         * The type of task run.
         * </p>
         * 
         * @param taskType
         *        The type of task run.
         * @see TaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskType
         */
        Builder taskType(String taskType);

        /**
         * <p>
         * The type of task run.
         * </p>
         * 
         * @param taskType
         *        The type of task run.
         * @see TaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskType
         */
        Builder taskType(TaskType taskType);

        /**
         * <p>
         * The configuration properties for an importing labels task run.
         * </p>
         * 
         * @param importLabelsTaskRunProperties
         *        The configuration properties for an importing labels task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importLabelsTaskRunProperties(ImportLabelsTaskRunProperties importLabelsTaskRunProperties);

        /**
         * <p>
         * The configuration properties for an importing labels task run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportLabelsTaskRunProperties.Builder}
         * avoiding the need to create one manually via {@link ImportLabelsTaskRunProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportLabelsTaskRunProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #importLabelsTaskRunProperties(ImportLabelsTaskRunProperties)}.
         * 
         * @param importLabelsTaskRunProperties
         *        a consumer that will call methods on {@link ImportLabelsTaskRunProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importLabelsTaskRunProperties(ImportLabelsTaskRunProperties)
         */
        default Builder importLabelsTaskRunProperties(
                Consumer<ImportLabelsTaskRunProperties.Builder> importLabelsTaskRunProperties) {
            return importLabelsTaskRunProperties(ImportLabelsTaskRunProperties.builder()
                    .applyMutation(importLabelsTaskRunProperties).build());
        }

        /**
         * <p>
         * The configuration properties for an exporting labels task run.
         * </p>
         * 
         * @param exportLabelsTaskRunProperties
         *        The configuration properties for an exporting labels task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportLabelsTaskRunProperties(ExportLabelsTaskRunProperties exportLabelsTaskRunProperties);

        /**
         * <p>
         * The configuration properties for an exporting labels task run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportLabelsTaskRunProperties.Builder}
         * avoiding the need to create one manually via {@link ExportLabelsTaskRunProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportLabelsTaskRunProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #exportLabelsTaskRunProperties(ExportLabelsTaskRunProperties)}.
         * 
         * @param exportLabelsTaskRunProperties
         *        a consumer that will call methods on {@link ExportLabelsTaskRunProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportLabelsTaskRunProperties(ExportLabelsTaskRunProperties)
         */
        default Builder exportLabelsTaskRunProperties(
                Consumer<ExportLabelsTaskRunProperties.Builder> exportLabelsTaskRunProperties) {
            return exportLabelsTaskRunProperties(ExportLabelsTaskRunProperties.builder()
                    .applyMutation(exportLabelsTaskRunProperties).build());
        }

        /**
         * <p>
         * The configuration properties for a labeling set generation task run.
         * </p>
         * 
         * @param labelingSetGenerationTaskRunProperties
         *        The configuration properties for a labeling set generation task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingSetGenerationTaskRunProperties(
                LabelingSetGenerationTaskRunProperties labelingSetGenerationTaskRunProperties);

        /**
         * <p>
         * The configuration properties for a labeling set generation task run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LabelingSetGenerationTaskRunProperties.Builder} avoiding the need to create one manually via
         * {@link LabelingSetGenerationTaskRunProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelingSetGenerationTaskRunProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #labelingSetGenerationTaskRunProperties(LabelingSetGenerationTaskRunProperties)}.
         * 
         * @param labelingSetGenerationTaskRunProperties
         *        a consumer that will call methods on {@link LabelingSetGenerationTaskRunProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelingSetGenerationTaskRunProperties(LabelingSetGenerationTaskRunProperties)
         */
        default Builder labelingSetGenerationTaskRunProperties(
                Consumer<LabelingSetGenerationTaskRunProperties.Builder> labelingSetGenerationTaskRunProperties) {
            return labelingSetGenerationTaskRunProperties(LabelingSetGenerationTaskRunProperties.builder()
                    .applyMutation(labelingSetGenerationTaskRunProperties).build());
        }

        /**
         * <p>
         * The configuration properties for a find matches task run.
         * </p>
         * 
         * @param findMatchesTaskRunProperties
         *        The configuration properties for a find matches task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findMatchesTaskRunProperties(FindMatchesTaskRunProperties findMatchesTaskRunProperties);

        /**
         * <p>
         * The configuration properties for a find matches task run.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindMatchesTaskRunProperties.Builder}
         * avoiding the need to create one manually via {@link FindMatchesTaskRunProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindMatchesTaskRunProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #findMatchesTaskRunProperties(FindMatchesTaskRunProperties)}.
         * 
         * @param findMatchesTaskRunProperties
         *        a consumer that will call methods on {@link FindMatchesTaskRunProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findMatchesTaskRunProperties(FindMatchesTaskRunProperties)
         */
        default Builder findMatchesTaskRunProperties(Consumer<FindMatchesTaskRunProperties.Builder> findMatchesTaskRunProperties) {
            return findMatchesTaskRunProperties(FindMatchesTaskRunProperties.builder()
                    .applyMutation(findMatchesTaskRunProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String taskType;

        private ImportLabelsTaskRunProperties importLabelsTaskRunProperties;

        private ExportLabelsTaskRunProperties exportLabelsTaskRunProperties;

        private LabelingSetGenerationTaskRunProperties labelingSetGenerationTaskRunProperties;

        private FindMatchesTaskRunProperties findMatchesTaskRunProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskRunProperties model) {
            taskType(model.taskType);
            importLabelsTaskRunProperties(model.importLabelsTaskRunProperties);
            exportLabelsTaskRunProperties(model.exportLabelsTaskRunProperties);
            labelingSetGenerationTaskRunProperties(model.labelingSetGenerationTaskRunProperties);
            findMatchesTaskRunProperties(model.findMatchesTaskRunProperties);
        }

        public final String getTaskType() {
            return taskType;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(TaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public final ImportLabelsTaskRunProperties.Builder getImportLabelsTaskRunProperties() {
            return importLabelsTaskRunProperties != null ? importLabelsTaskRunProperties.toBuilder() : null;
        }

        public final void setImportLabelsTaskRunProperties(ImportLabelsTaskRunProperties.BuilderImpl importLabelsTaskRunProperties) {
            this.importLabelsTaskRunProperties = importLabelsTaskRunProperties != null ? importLabelsTaskRunProperties.build()
                    : null;
        }

        @Override
        public final Builder importLabelsTaskRunProperties(ImportLabelsTaskRunProperties importLabelsTaskRunProperties) {
            this.importLabelsTaskRunProperties = importLabelsTaskRunProperties;
            return this;
        }

        public final ExportLabelsTaskRunProperties.Builder getExportLabelsTaskRunProperties() {
            return exportLabelsTaskRunProperties != null ? exportLabelsTaskRunProperties.toBuilder() : null;
        }

        public final void setExportLabelsTaskRunProperties(ExportLabelsTaskRunProperties.BuilderImpl exportLabelsTaskRunProperties) {
            this.exportLabelsTaskRunProperties = exportLabelsTaskRunProperties != null ? exportLabelsTaskRunProperties.build()
                    : null;
        }

        @Override
        public final Builder exportLabelsTaskRunProperties(ExportLabelsTaskRunProperties exportLabelsTaskRunProperties) {
            this.exportLabelsTaskRunProperties = exportLabelsTaskRunProperties;
            return this;
        }

        public final LabelingSetGenerationTaskRunProperties.Builder getLabelingSetGenerationTaskRunProperties() {
            return labelingSetGenerationTaskRunProperties != null ? labelingSetGenerationTaskRunProperties.toBuilder() : null;
        }

        public final void setLabelingSetGenerationTaskRunProperties(
                LabelingSetGenerationTaskRunProperties.BuilderImpl labelingSetGenerationTaskRunProperties) {
            this.labelingSetGenerationTaskRunProperties = labelingSetGenerationTaskRunProperties != null ? labelingSetGenerationTaskRunProperties
                    .build() : null;
        }

        @Override
        public final Builder labelingSetGenerationTaskRunProperties(
                LabelingSetGenerationTaskRunProperties labelingSetGenerationTaskRunProperties) {
            this.labelingSetGenerationTaskRunProperties = labelingSetGenerationTaskRunProperties;
            return this;
        }

        public final FindMatchesTaskRunProperties.Builder getFindMatchesTaskRunProperties() {
            return findMatchesTaskRunProperties != null ? findMatchesTaskRunProperties.toBuilder() : null;
        }

        public final void setFindMatchesTaskRunProperties(FindMatchesTaskRunProperties.BuilderImpl findMatchesTaskRunProperties) {
            this.findMatchesTaskRunProperties = findMatchesTaskRunProperties != null ? findMatchesTaskRunProperties.build()
                    : null;
        }

        @Override
        public final Builder findMatchesTaskRunProperties(FindMatchesTaskRunProperties findMatchesTaskRunProperties) {
            this.findMatchesTaskRunProperties = findMatchesTaskRunProperties;
            return this;
        }

        @Override
        public TaskRunProperties build() {
            return new TaskRunProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
